/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_9;

public class ChasingGoal
extends class_1352 {
    public static class_2960 ID = new class_2960("brutalbosses:chasetarget");
    private final class_1308 mob;
    private float chaseDist;
    private class_1309 target = null;
    private final ChaseParams params;
    private int ticksToNextUpdate = 0;

    public ChasingGoal(class_1308 mob, IAIParams params) {
        this.params = (ChaseParams)params;
        this.chaseDist = this.params.chasedistance * this.params.chasedistance;
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void method_6270() {
        this.target = null;
    }

    public void method_6268() {
        this.mob.method_5988().method_20248(this.target.method_23317(), this.target.method_23320(), this.target.method_23321());
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        double distSqr = this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        this.ticksToNextUpdate = (int)Math.max(4.0, distSqr / 100.0);
        if (distSqr <= (double)this.chaseDist && this.mob.method_5985().method_6369((class_1297)this.target)) {
            this.mob.method_5942().method_6340();
        } else {
            class_11 path = this.mob.method_5942().method_6345();
            if (path != null) {
                class_2338 endPos;
                double endPosDist;
                class_9 endNode = path.method_45();
                if (endNode != null && ((endPosDist = this.target.method_5649((double)(endPos = new class_2338(endNode.field_40, endNode.field_39, endNode.field_38)).method_10263(), (double)endPos.method_10264(), (double)endPos.method_10260())) > (double)this.chaseDist || !this.mob.method_5985().method_6369((class_1297)this.target))) {
                    this.mob.method_5942().method_6335((class_1297)this.target, 1.0);
                }
            } else {
                this.mob.method_5942().method_6335((class_1297)this.target, 1.0);
            }
        }
    }

    public static class ChaseParams
    extends IAIParams.DefaultParams {
        private float chasedistance = 2.0f;
        private static final String CHASE_DIST = "chasedistance";

        public ChaseParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(CHASE_DIST)) {
                this.chasedistance = jsonElement.get(CHASE_DIST).getAsFloat();
            }
            return this;
        }
    }
}

