/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.ai.BigFireballAttackGoal;
import com.brutalbosses.entity.ai.ChangeGearGoal;
import com.brutalbosses.entity.ai.ChargeGoal;
import com.brutalbosses.entity.ai.ChasingGoal;
import com.brutalbosses.entity.ai.CommandRunGoal;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.ItemThrowAttackGoal;
import com.brutalbosses.entity.ai.JumpAttackGoal;
import com.brutalbosses.entity.ai.LavaRescueGoal;
import com.brutalbosses.entity.ai.MeleeHitGoal;
import com.brutalbosses.entity.ai.MeleeShieldAttackGoal;
import com.brutalbosses.entity.ai.OutofCombatRegen;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.brutalbosses.entity.ai.SmallFireballAttackGoal;
import com.brutalbosses.entity.ai.SnowballAttackGoal;
import com.brutalbosses.entity.ai.SpitCobwebGoal;
import com.brutalbosses.entity.ai.SummonMobsGoal;
import com.brutalbosses.entity.ai.TemporaryPotionGoal;
import com.brutalbosses.entity.ai.WhirlWind;
import com.brutalbosses.entity.ai.WitherSkullAttackGoal;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1379;
import net.minecraft.class_1383;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3745;
import net.minecraft.class_7923;

public class BossTypeManager {
    public Map<class_2960, BossType> bosses = ImmutableMap.of();
    public Set<class_2960> entityTypes = ImmutableSet.of();
    public static final BossTypeManager instance = new BossTypeManager();
    public Map<class_2960, BiConsumer<class_1297, IAIParams>> aiCreatorRegistry = ImmutableMap.of();
    public Map<class_2960, Function<JsonObject, IAIParams>> aiParamParsers = ImmutableMap.of();
    public ImmutableMap<class_2960, List<BossType>> lootTableSpawnEntries = ImmutableMap.of();

    private BossTypeManager() {
        this.registerAI(new class_2960("minecraft:randomwalk"), (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new class_1379((class_1314)entity, 0.8, 20)), null);
        this.registerAI(new class_2960("minecraft:meleeattack"), (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new class_1366((class_1314)entity, 1.0, true)), null);
        this.registerAI(new class_2960("minecraft:crossbow"), (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new class_1383((class_1588)((class_3745)((class_1603)entity)), 1.0, 30.0f)), null);
        this.registerAI(MeleeShieldAttackGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2001, (class_1352)new MeleeShieldAttackGoal((class_1308)entity, 1.0)), null);
        this.registerAI(new class_2960("minecraft:target"), (entity, params) -> ((class_1308)entity).field_6185.method_6277(-2000, (class_1352)new class_1400((class_1308)entity, class_1657.class, true)), null);
        this.registerAI(LavaRescueGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new LavaRescueGoal((class_1308)entity)), null);
        this.registerAI(ChasingGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2001, (class_1352)new ChasingGoal((class_1308)entity, (IAIParams)params)), ChasingGoal.ChaseParams::new);
        this.registerAI(SmallFireballAttackGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new SmallFireballAttackGoal((class_1308)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(WitherSkullAttackGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new WitherSkullAttackGoal((class_1308)entity, (IAIParams)params)), WitherSkullAttackGoal.WitherSkullParams::new);
        this.registerAI(SnowballAttackGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new SnowballAttackGoal((class_1308)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(OutofCombatRegen.ID, (entity, params) -> ((class_1308)entity).field_6185.method_6277(-2000, (class_1352)new OutofCombatRegen((class_1308)entity, (IAIParams)params)), OutofCombatRegen.CombatParams::new);
        this.registerAI(SpitCobwebGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new SpitCobwebGoal((class_1308)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(SummonMobsGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new SummonMobsGoal((class_1308)entity, (IAIParams)params)), SummonMobsGoal.SummonParams::new);
        this.registerAI(WhirlWind.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new WhirlWind((class_1308)entity, (IAIParams)params)), WhirlWind.WhirldWindParams::new);
        this.registerAI(new class_2960("brutalbosses:whirldwind"), (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new WhirlWind((class_1308)entity, (IAIParams)params)), WhirlWind.WhirldWindParams::new);
        this.registerAI(MeleeHitGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new MeleeHitGoal((class_1308)entity, (IAIParams)params)), MeleeHitGoal.MeleeHitParams::new);
        this.registerAI(ChargeGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new ChargeGoal((class_1308)entity, (IAIParams)params)), ChargeGoal.ChargeParams::new);
        this.registerAI(BigFireballAttackGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new BigFireballAttackGoal((class_1308)entity, (IAIParams)params)), SimpleRangedAttackGoal.RangedParams::new);
        this.registerAI(ItemThrowAttackGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new ItemThrowAttackGoal((class_1308)entity, (IAIParams)params)), ItemThrowAttackGoal.ItemThrowParams::new);
        this.registerAI(TemporaryPotionGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new TemporaryPotionGoal((class_1308)entity, (IAIParams)params)), TemporaryPotionGoal.TempPotionParams::new);
        this.registerAI(ChangeGearGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new ChangeGearGoal((class_1308)entity, (IAIParams)params)), ChangeGearGoal.ChangeGearParams::new);
        this.registerAI(JumpAttackGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new JumpAttackGoal((class_1308)entity, (IAIParams)params)), JumpAttackGoal.JumpAttackParams::new);
        this.registerAI(CommandRunGoal.ID, (entity, params) -> ((class_1308)entity).field_6201.method_6277(-2000, (class_1352)new CommandRunGoal((class_1308)entity, (IAIParams)params)), CommandRunGoal.CommandParams::new);
    }

    public void registerAI(class_2960 ID, BiConsumer<class_1297, IAIParams> aiCreator, Function<JsonObject, IAIParams> paramsParser) {
        ImmutableMap.Builder aiRegistry = ImmutableMap.builder();
        ImmutableMap.Builder aiSupplier = ImmutableMap.builder();
        aiRegistry.putAll(this.aiCreatorRegistry);
        aiSupplier.putAll(this.aiParamParsers);
        aiRegistry.put((Object)ID, aiCreator);
        if (paramsParser != null) {
            aiSupplier.put((Object)ID, paramsParser);
        }
        for (int i = 1; i < 5; ++i) {
            class_2960 additionalID = new class_2960(ID.method_12836(), ID.method_12832() + i);
            aiRegistry.put((Object)additionalID, aiCreator);
            if (paramsParser == null) continue;
            aiSupplier.put((Object)additionalID, paramsParser);
        }
        this.aiCreatorRegistry = aiRegistry.build();
        this.aiParamParsers = aiSupplier.build();
    }

    public void afterLoad() {
        ImmutableSet.Builder entityTypes = ImmutableSet.builder();
        HashMap<class_2960, List> tempSpawns = new HashMap<class_2960, List>();
        for (BossType bossType : this.bosses.values()) {
            entityTypes.add((Object)class_7923.field_41177.method_10221((Object)bossType.getEntityType()));
            BrutalBosses.LOGGER.info("Loaded boss variant for: " + class_7923.field_41177.method_10221((Object)bossType.getEntityType()));
            for (Map.Entry spawnEntry : bossType.getSpawnTables().entrySet()) {
                List contained = tempSpawns.computeIfAbsent((class_2960)spawnEntry.getKey(), loc -> new ArrayList());
                for (int i = 0; i < (Integer)spawnEntry.getValue(); ++i) {
                    contained.add(bossType);
                }
            }
        }
        this.entityTypes = entityTypes.build();
        ImmutableMap.Builder spawnMap = ImmutableMap.builder();
        for (Map.Entry entry : tempSpawns.entrySet()) {
            ImmutableList.Builder bossList = ImmutableList.builder();
            bossList.addAll((Iterable)entry.getValue());
            spawnMap.put((Object)((class_2960)entry.getKey()), (Object)bossList.build());
        }
        this.lootTableSpawnEntries = spawnMap.build();
    }

    public boolean isValidBossEntity(class_1297 entity) {
        return this.entityTypes.contains(class_7923.field_41177.method_10221((Object)entity.method_5864()));
    }

    public void setBossTypes(ImmutableMap<class_2960, BossType> bossTypes) {
        this.bosses = bossTypes;
    }
}

