/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.CustomEntityRenderData;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.brutalbosses.event.EventHandler;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1617;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3988;
import net.minecraft.class_4135;
import net.minecraft.class_5134;
import net.minecraft.class_7923;

public class BossType {
    private final class_1299 entityToUse;
    private class_2487 creationData = null;
    private final class_2960 id;
    private ImmutableMap<class_1291, Integer> potionMobEffects = ImmutableMap.of();
    private ImmutableMap<class_1304, class_1799> gearMap = ImmutableMap.of();
    private ImmutableMap<class_2960, IAIParams> aiData = ImmutableMap.of();
    private ImmutableMap<class_1320, Float> attributes = ImmutableMap.of();
    private ImmutableMap<class_2960, Integer> spawnTables = ImmutableMap.of();
    private ImmutableMap<String, Float> customAttributes = ImmutableMap.of();
    private String desc;
    private float scale = 1.0f;
    private int experienceDropped = 1;
    private int itemLootCount = 3;
    private boolean showBossBar = true;
    private boolean nameVisible = true;
    private boolean protectsTreasure = true;
    private int randomSpawnChance = 0;

    public BossType(class_1299 entityToUse, class_2960 id) {
        this.entityToUse = entityToUse;
        this.id = id;
    }

    public class_1308 createBossEntity(class_1937 world) {
        class_1297 entity = this.entityToUse.method_5883(world);
        if (entity instanceof class_3988) {
            ((class_3988)entity).field_17721 = new class_1916();
        }
        if (this.creationData != null) {
            if (this.creationData.method_10545("Pos")) {
                entity.method_5651(this.creationData);
            } else if (entity instanceof class_1309) {
                ((class_1309)entity).method_5749(this.creationData);
            }
        }
        if (!(entity instanceof BossCapEntity)) {
            BrutalBosses.LOGGER.warn("Not supported boss entity:" + this.entityToUse);
            return null;
        }
        ((BossCapEntity)entity).setBossCap(new BossCapability(entity));
        ((BossCapEntity)entity).getBossCap().setBossType(this);
        this.initForEntity((class_1309)((class_1308)entity));
        return (class_1308)entity;
    }

    public void initForClientEntity(class_1309 entity) {
        if (entity instanceof CustomEntityRenderData) {
            ((CustomEntityRenderData)entity).setVisualScale(this.scale);
            ((CustomEntityRenderData)entity).setDimension(this.entityToUse.method_18386().method_18383(this.scale));
        }
    }

    public void initForEntity(class_1309 boss) {
        this.initGear(boss);
        this.initStats(boss);
        this.initAI(boss);
        if (boss instanceof class_1308) {
            ((class_1308)boss).method_5971();
            if (boss.method_6127().method_27306(class_5134.field_23717)) {
                // empty if block
            }
        }
        boss.method_5665((class_2561)class_2561.method_43470((String)this.desc));
        boss.method_5880(this.nameVisible);
        if (this.protectsTreasure) {
            EventHandler.protectedBlocks.put(((BossCapEntity)boss).getBossCap().getSpawnPos(), boss.method_5667());
        }
    }

    private void initStats(class_1309 boss) {
        float healthPct = boss.method_6032() / boss.method_6063();
        for (Map.Entry attributeEntry : this.attributes.entrySet()) {
            if (boss.method_6127().method_27306((class_1320)attributeEntry.getKey())) {
                if (attributeEntry.getKey() == class_5134.field_23716 || attributeEntry.getKey() == class_5134.field_23721) {
                    boss.method_5996((class_1320)attributeEntry.getKey()).method_6192((double)((Float)attributeEntry.getValue()).floatValue() * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).globalDifficultyMultiplier);
                    continue;
                }
                boss.method_5996((class_1320)attributeEntry.getKey()).method_6192((double)((Float)attributeEntry.getValue()).floatValue());
                continue;
            }
            BrutalBosses.LOGGER.debug("Boss:" + this.id.toString() + " Attribute: " + ((class_1320)attributeEntry.getKey()).method_26830() + " is not applicable to: " + this.entityToUse);
        }
        boss.method_6033(boss.method_6063() * healthPct);
        for (Map.Entry MobEffectEntry : this.potionMobEffects.entrySet()) {
            boss.method_6088().put((class_1291)MobEffectEntry.getKey(), new class_1293((class_1291)MobEffectEntry.getKey(), 10000000, ((Integer)MobEffectEntry.getValue()).intValue()));
        }
    }

    public void initGear(class_1309 boss) {
        if (boss instanceof class_1308) {
            for (Map.Entry gearEntry : this.gearMap.entrySet()) {
                boss.method_5673((class_1304)gearEntry.getKey(), (class_1799)gearEntry.getValue());
            }
        }
    }

    private void initAI(class_1309 boss) {
        if (this.customAttributes.containsKey((Object)"removespellcastinggoals") && boss instanceof class_1308) {
            Iterator iterator = ((class_1308)boss).field_6201.method_35115().iterator();
            while (iterator.hasNext()) {
                class_4135 goal = (class_4135)iterator.next();
                if (!(goal.method_19058() instanceof class_1617.class_1620)) continue;
                goal.method_6270();
                iterator.remove();
            }
        }
        for (Map.Entry data : this.aiData.entrySet()) {
            if (!BossTypeManager.instance.aiCreatorRegistry.containsKey(data.getKey())) continue;
            BossTypeManager.instance.aiCreatorRegistry.get(data.getKey()).accept((class_1297)boss, (IAIParams)data.getValue());
        }
    }

    public class_2960 getID() {
        return this.id;
    }

    public void setMobEffects(ImmutableMap<class_1291, Integer> potionMobEffects) {
        this.potionMobEffects = potionMobEffects;
    }

    public void setGear(ImmutableMap<class_1304, class_1799> gearMap) {
        this.gearMap = gearMap;
    }

    public void setAttributes(ImmutableMap<class_1320, Float> attributes) {
        this.attributes = attributes;
    }

    public void setAIData(ImmutableMap<class_2960, IAIParams> aiData) {
        this.aiData = aiData;
    }

    public class_1299 getEntityType() {
        return this.entityToUse;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setSpawnTable(ImmutableMap<class_2960, Integer> spawnData) {
        this.spawnTables = spawnData;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof BossType) {
            return this.id.equals((Object)((BossType)other).id);
        }
        return false;
    }

    public ImmutableMap<class_2960, Integer> getSpawnTables() {
        return this.spawnTables;
    }

    public void setVisualScale(float scale) {
        this.scale = scale;
    }

    public float getVisualScale() {
        return this.scale;
    }

    public float getCustomAttributeValueOrDefault(String attributeID, float defaultValue) {
        return ((Float)this.customAttributes.getOrDefault((Object)attributeID, (Object)Float.valueOf(defaultValue))).floatValue();
    }

    public void setCustomAttributes(ImmutableMap<String, Float> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public void setRandomSpawnChance(int randomSpawnChance) {
        this.randomSpawnChance = randomSpawnChance;
    }

    public int getExperienceDrop() {
        return this.experienceDropped;
    }

    public void setExperienceDrop(int exp) {
        this.experienceDropped = exp;
    }

    public IAIParams getAIParams(class_2960 id) {
        return (IAIParams)this.aiData.get((Object)id);
    }

    public int getItemLootCount() {
        return this.itemLootCount;
    }

    public void setItemLootCount(int itemLootCount) {
        this.itemLootCount = itemLootCount;
    }

    public class_2487 serializeToClient() {
        class_2487 CompoundTag = new class_2487();
        CompoundTag.method_10582("id", this.id.toString());
        CompoundTag.method_10582("etype", class_7923.field_41177.method_10221((Object)this.entityToUse).toString());
        CompoundTag.method_10548("scale", this.scale);
        return CompoundTag;
    }

    public static BossType deserializeAtClient(class_2487 CompoundTag) {
        class_2960 id = class_2960.method_12829((String)CompoundTag.method_10558("id"));
        class_2960 entity = class_2960.method_12829((String)CompoundTag.method_10558("etype"));
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(entity);
        if (type == null || class_7923.field_41177.method_10221((Object)type).equals((Object)class_7923.field_41177.method_10137())) {
            return null;
        }
        BossType bossType = new BossType(type, id);
        bossType.setVisualScale(CompoundTag.method_10583("scale"));
        return bossType;
    }

    public void setBossBar(boolean show) {
        this.showBossBar = show;
    }

    public boolean showBossBar() {
        return this.showBossBar;
    }

    public void setEntityNBT(class_2487 entityNBT) {
        this.creationData = entityNBT;
    }

    public void setNameVisible(boolean visible) {
        this.nameVisible = visible;
    }

    public void setProtectsTreasure(boolean protectsTreasure) {
        this.protectsTreasure = protectsTreasure;
    }

    public boolean rollRandomSpawn() {
        return BrutalBosses.rand.nextInt(100) < this.randomSpawnChance;
    }
}

