/*
 * Decompiled with CFR 0.152.
 */
package com.lootintegrations.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lootintegrations.LootintegrationsMod;
import com.lootintegrations.loot.GlobalLootModifierIntegration;
import com.lootintegrations.loot.ILootTableID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class LootModifierManager
extends class_4309
implements IdentifiableResourceReloadListener {
    public static final Map<class_2960, List<GlobalLootModifierIntegration>> lootOptionsMap = new HashMap<class_2960, List<GlobalLootModifierIntegration>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final class_6862<class_1792> IGNORED_FOR_LOOT = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)"lootintegrations:ignored"));
    private static Set<class_2960> applying = new HashSet<class_2960>();

    public LootModifierManager() {
        super(GSON, "loot");
    }

    public static void applyTo(class_47 context, List<class_1799> items, class_52 lootTable) {
        if (!(lootTable instanceof ILootTableID)) {
            return;
        }
        class_2960 lootTableID = ((ILootTableID)lootTable).getID();
        if (applying.contains(lootTableID)) {
            return;
        }
        List<GlobalLootModifierIntegration> modifiers = lootOptionsMap.get(((ILootTableID)lootTable).getID());
        if (modifiers != null && !modifiers.isEmpty()) {
            applying.add(lootTableID);
            for (GlobalLootModifierIntegration modifier : modifiers) {
                modifier.doApply(items, context, lootTable);
            }
            applying.remove(lootTableID);
        }
    }

    protected void apply(Map<class_2960, JsonElement> resourceLocationJsonElementMap, class_3300 iResourceManager, class_3695 iProfiler) {
        lootOptionsMap.clear();
        for (Map.Entry<class_2960, JsonElement> entry : resourceLocationJsonElementMap.entrySet()) {
            if (!entry.getKey().method_12836().equals("lootintegrations")) {
                LootintegrationsMod.LOGGER.warn("Ignoring loot modifiers for:" + entry.getKey() + " use this folder name:lootintegrations");
                continue;
            }
            try {
                GlobalLootModifierIntegration modifier = GlobalLootModifierIntegration.read(entry.getKey(), entry.getValue());
                for (class_2960 integratedTable : modifier.integratedTables.keySet()) {
                    lootOptionsMap.computeIfAbsent(integratedTable, e -> new ArrayList()).add(modifier);
                }
            }
            catch (Error e2) {
                LootintegrationsMod.LOGGER.warn("Failed to load loot modifier file:" + entry.getKey(), (Throwable)e2);
            }
        }
    }

    public class_2960 getFabricId() {
        return new class_2960("lootintegrations", "lootintegrationreloadlistener");
    }
}

