/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.RandomStateAccessor;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3754;
import net.minecraft.class_5216;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5822;
import net.minecraft.class_6574;
import net.minecraft.class_6731;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_7138;

public record SampleDensityPlacementCondition(class_6880<class_6910> densityFunction, Optional<Double> minInclusive, Optional<Double> maxInclusive) implements PlacementCondition
{
    public static final MapCodec<SampleDensityPlacementCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37058.fieldOf("density_function").forGetter(SampleDensityPlacementCondition::densityFunction), (App)Codec.DOUBLE.optionalFieldOf("min_inclusive").forGetter(SampleDensityPlacementCondition::minInclusive), (App)Codec.DOUBLE.optionalFieldOf("max_inclusive").forGetter(SampleDensityPlacementCondition::maxInclusive)).apply((Applicative)instance, SampleDensityPlacementCondition::new));

    @Override
    public boolean test(PlacementCondition.Context context, class_2338 pos) {
        class_2794 class_27942 = context.generator();
        if (!(class_27942 instanceof class_3754)) {
            return false;
        }
        class_3754 chunkGenerator = (class_3754)class_27942;
        class_6910 df = ((class_6910)this.densityFunction.comp_349()).method_40469((class_6910.class_6915)new NoiseWiringHelper(context.seed(), ((class_5284)chunkGenerator.field_24774.comp_349()).comp_483(), context.randomState(), ((RandomStateAccessor)context.randomState()).getRandom()));
        double density = df.method_40464((class_6910.class_6912)new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        boolean min = this.minInclusive.isEmpty() || density >= this.minInclusive.get();
        boolean max = this.maxInclusive.isEmpty() || density <= this.maxInclusive.get();
        return min && max;
    }

    @Override
    public MapCodec<? extends PlacementCondition> codec() {
        return CODEC;
    }

    private static class NoiseWiringHelper
    implements class_6910.class_6915 {
        private final Map<class_6910, class_6910> wrapped = new HashMap<class_6910, class_6910>();
        private final boolean useLegacySource;
        private final long seed;
        final class_7138 randomState;
        final class_6574 random;

        private class_5819 newLegacyInstance(long noiseSeed) {
            return new class_5820(this.seed + noiseSeed);
        }

        NoiseWiringHelper(long seed, boolean useLegacySource, class_7138 randomState, class_6574 random) {
            this.seed = seed;
            this.useLegacySource = useLegacySource;
            this.randomState = randomState;
            this.random = random;
        }

        public class_6910.class_7270 method_42358(class_6910.class_7270 noiseHolder) {
            class_6880 noiseData = noiseHolder.comp_662();
            if (this.useLegacySource) {
                if (noiseData.method_40225(class_6731.field_35389)) {
                    class_5216 noise = class_5216.method_39186((class_5819)this.newLegacyInstance(0L), (class_5216.class_5487)new class_5216.class_5487(-7, 1.0, new double[]{1.0}));
                    return new class_6910.class_7270(noiseData, noise);
                }
                if (noiseData.method_40225(class_6731.field_35390)) {
                    class_5216 noise = class_5216.method_39186((class_5819)this.newLegacyInstance(1L), (class_5216.class_5487)new class_5216.class_5487(-7, 1.0, new double[]{1.0}));
                    return new class_6910.class_7270(noiseData, noise);
                }
                if (noiseData.method_40225(class_6731.field_35394)) {
                    class_5216 noise = class_5216.method_38476((class_5819)this.random.method_39000(class_6731.field_35394.method_29177()), (class_5216.class_5487)new class_5216.class_5487(0, 0.0, new double[0]));
                    return new class_6910.class_7270(noiseData, noise);
                }
            }
            class_5216 noise = this.randomState.method_41558((class_5321)noiseData.method_40230().orElseThrow());
            return new class_6910.class_7270(noiseData, noise);
        }

        private class_6910 wrapNew(class_6910 densityFunction) {
            if (densityFunction instanceof class_5822) {
                class_5822 $$1 = (class_5822)densityFunction;
                class_5819 $$2x = this.useLegacySource ? this.newLegacyInstance(0L) : this.random.method_39000(new class_2960("terrain"));
                return $$1.method_42386($$2x);
            }
            return densityFunction instanceof class_6916.class_6924 ? new class_6916.class_6924(this.seed) : densityFunction;
        }

        public class_6910 apply(class_6910 densityFunction) {
            return this.wrapped.computeIfAbsent(densityFunction, this::wrapNew);
        }
    }
}

