/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.api.event.TeamAllyEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class PartyTeam
extends AbstractTeam {
    UUID owner = class_156.field_25140;

    public PartyTeam(TeamManagerImpl manager, UUID id) {
        super(manager, id);
    }

    @Override
    public TeamType getType() {
        return TeamType.PARTY;
    }

    @Override
    protected void serializeExtraNBT(class_2487 tag) {
        tag.method_10582("owner", this.owner.toString());
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        this.owner = UUID.fromString(tag.method_10558("owner"));
    }

    @Override
    public TeamRank getRankForPlayer(UUID playerId) {
        return this.owner.equals(playerId) ? TeamRank.OWNER : super.getRankForPlayer(playerId);
    }

    public boolean isOwner(UUID profile) {
        return this.owner.equals(profile);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean isPartyTeam() {
        return true;
    }

    public int join(class_3222 player) throws CommandSyntaxException {
        Team oldTeam = this.manager.getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.method_5667()));
        if (!(oldTeam instanceof PlayerTeam)) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PlayerTeam playerTeam = (PlayerTeam)oldTeam;
        UUID id = player.method_5667();
        playerTeam.setEffectiveTeam(this);
        this.ranks.put(id, TeamRank.MEMBER);
        this.sendMessage(class_156.field_25140, (class_2561)class_2561.method_43469((String)"ftbteams.message.joined", (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1060));
        this.markDirty();
        playerTeam.ranks.remove(id);
        playerTeam.markDirty();
        playerTeam.updatePresence();
        this.manager.syncToAll(this, oldTeam);
        this.onPlayerChangeTeam(oldTeam, id, player, false);
        return 1;
    }

    public int invite(class_3222 inviter, Collection<GameProfile> profiles) throws CommandSyntaxException {
        if (!FTBTUtils.canPlayerUseCommand(inviter, "ftbteams.party.invite")) {
            throw TeamArgument.NO_PERMISSION.create();
        }
        for (GameProfile profile : profiles) {
            FTBTeamsAPI.api().getManager().getTeamForPlayerID(profile.getId()).ifPresent(team -> {
                if (!(team instanceof PartyTeam)) {
                    this.ranks.put(profile.getId(), TeamRank.INVITED);
                    this.markDirty();
                    this.sendMessage(inviter.method_5667(), (class_2561)class_2561.method_43469((String)"ftbteams.message.invited", (Object[])new Object[]{class_2561.method_43470((String)profile.getName()).method_27692(class_124.field_1054)}).method_27692(class_124.field_1060));
                    class_3222 invitee = FTBTUtils.getPlayerByUUID(this.manager.getServer(), profile.getId());
                    if (invitee != null && !invitee.method_5667().equals(inviter.method_5667())) {
                        invitee.method_7353((class_2561)class_2561.method_43469((String)"ftbteams.message.invite_sent", (Object[])new Object[]{inviter.method_5477().method_27661().method_27692(class_124.field_1054)}), false);
                        class_2561 acceptButton = this.makeInviteButton("ftbteams.accept", class_124.field_1060, "/ftbteams party join " + this.getShortName());
                        class_2561 declineButton = this.makeInviteButton("ftbteams.decline", class_124.field_1061, "/ftbteams party decline " + this.getShortName());
                        invitee.method_7353((class_2561)class_2561.method_43470((String)"[").method_10852(acceptButton).method_27693("] [").method_10852(declineButton).method_27693("]"), false);
                    }
                }
            });
        }
        return 1;
    }

    private class_2561 makeInviteButton(String xlate, class_124 color, String command) {
        return class_2561.method_43471((String)xlate).method_27696(class_2583.field_24360.method_10977(color).method_10958(new class_2558(class_2558.class_2559.field_11750, command)));
    }

    public int kick(class_2168 from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            UUID id = player.getId();
            Team oldTeam = this.manager.getTeamForPlayerID(id).orElseThrow(() -> ((SimpleCommandExceptionType)TeamArgument.NOT_IN_PARTY).create());
            if (oldTeam != this) {
                throw TeamArgument.NOT_IN_PARTY.create();
            }
            if (this.isOwner(id)) {
                throw TeamArgument.CANT_KICK_OWNER.create();
            }
            PlayerTeam team = this.manager.getPersonalTeamForPlayerID(id);
            team.setEffectiveTeam(team);
            class_3222 playerToKick = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            team.ranks.put(id, TeamRank.OWNER);
            UUID fromId = from.method_44023() != null ? from.method_44023().method_5667() : class_156.field_25140;
            this.sendMessage(fromId, (class_2561)class_2561.method_43469((String)"ftbteams.message.kicked", (Object[])new Object[]{this.manager.getPlayerName(id).method_27661().method_27692(class_124.field_1054), this.getName()}).method_27692(class_124.field_1065));
            team.markDirty();
            this.ranks.remove(id);
            this.markDirty();
            team.updatePresence();
            this.manager.syncToAll(this, team);
            if (playerToKick != null) {
                playerToKick.method_7353((class_2561)class_2561.method_43469((String)"ftbteams.message.kicked", (Object[])new Object[]{playerToKick.method_5477().method_27661().method_27692(class_124.field_1054), this.getName().method_27661().method_27692(class_124.field_1075)}), false);
                this.updateCommands(playerToKick);
            }
            team.onPlayerChangeTeam(this, id, playerToKick, false);
        }
        return 1;
    }

    public int promote(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        boolean changesMade = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.getRankForPlayer(id) == TeamRank.MEMBER) {
                this.ranks.put(id, TeamRank.OFFICER);
                class_5250 playerName = this.manager.getPlayerName(id).method_27661().method_27692(class_124.field_1054);
                this.sendMessage(from.method_5667(), (class_2561)class_2561.method_43469((String)"ftbteams.message.promoted", (Object[])new Object[]{playerName}).method_27692(class_124.field_1060));
                changesMade = true;
                continue;
            }
            throw TeamArgument.NOT_MEMBER.create((Object)this.manager.getPlayerName(id), (Object)this.getName());
        }
        if (changesMade) {
            this.markDirty();
            this.manager.syncToAll(this);
        }
        return 1;
    }

    public int demote(class_3222 from, Collection<GameProfile> players) throws CommandSyntaxException {
        boolean changesMade = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.getRankForPlayer(id) == TeamRank.OFFICER) {
                this.ranks.put(id, TeamRank.MEMBER);
                class_5250 playerName = this.manager.getPlayerName(id).method_27661().method_27692(class_124.field_1054);
                this.sendMessage(from.method_5667(), (class_2561)class_2561.method_43469((String)"ftbteams.message.demoted", (Object[])new Object[]{playerName}).method_27692(class_124.field_1065));
                changesMade = true;
                continue;
            }
            throw TeamArgument.NOT_OFFICER.create((Object)this.manager.getPlayerName(id), (Object)this.getName());
        }
        if (changesMade) {
            this.markDirty();
            this.manager.syncToAll(this);
        }
        return 1;
    }

    public int transferOwnership(class_2168 from, Collection<GameProfile> toProfiles) throws CommandSyntaxException {
        return this.transferOwnership(from, toProfiles.stream().findFirst().orElseThrow());
    }

    public int transferOwnership(class_2168 from, GameProfile toProfile) throws CommandSyntaxException {
        class_3222 toPlayer;
        UUID newOwnerID = toProfile.getId();
        if (!this.getMembers().contains(newOwnerID)) {
            throw TeamArgument.NOT_MEMBER.create((Object)toProfile.toString(), (Object)this.getName());
        }
        if (this.owner.equals(newOwnerID)) {
            from.method_45068((class_2561)class_2561.method_43470((String)"Already owner!").method_27692(class_124.field_1061));
            return 0;
        }
        this.ranks.put(this.owner, TeamRank.OFFICER);
        this.owner = newOwnerID;
        this.ranks.put(this.owner, TeamRank.OWNER);
        this.markDirty();
        class_3222 fromPlayer = from.method_44023();
        if (fromPlayer != null) {
            this.updateCommands(fromPlayer);
        }
        if ((toPlayer = from.method_9211().method_3760().method_14602(newOwnerID)) != null) {
            ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent((Team)this, fromPlayer, toPlayer));
            this.updateCommands(toPlayer);
        } else {
            ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent(this, fromPlayer, toProfile));
        }
        UUID fromId = fromPlayer == null ? class_156.field_25140 : fromPlayer.method_5667();
        class_5250 msg = class_2561.method_43469((String)"ftbteams.message.transfer_owner", (Object[])new Object[]{class_2561.method_43470((String)toProfile.getName()).method_27692(class_124.field_1054)}).method_27692(class_124.field_1060);
        this.sendMessage(fromId, (class_2561)msg);
        if (fromPlayer == null) {
            from.method_45068((class_2561)msg);
        }
        this.manager.syncToAll(this);
        return 1;
    }

    public int leave(UUID id) throws CommandSyntaxException {
        class_3222 player = FTBTeamsAPI.api().getManager().getServer().method_3760().method_14602(id);
        if (this.isOwner(id) && this.getMembers().size() > 1) {
            throw TeamArgument.OWNER_CANT_LEAVE.create();
        }
        PlayerTeam playerTeam = this.manager.getPersonalTeamForPlayerID(id);
        playerTeam.setEffectiveTeam(playerTeam);
        playerTeam.ranks.put(id, TeamRank.OWNER);
        String playerName = player == null ? id.toString() : player.method_7334().getName();
        this.sendMessage(class_156.field_25140, (class_2561)class_2561.method_43469((String)"ftbteams.message.left_party", (Object[])new Object[]{class_2561.method_43470((String)playerName).method_27692(class_124.field_1054)}).method_27692(class_124.field_1065));
        playerTeam.markDirty();
        this.ranks.remove(id);
        this.manager.markDirty();
        boolean deletingTeam = false;
        if (this.getMembers().isEmpty()) {
            deletingTeam = true;
            this.invalidateTeam();
            this.manager.deleteTeam(this);
            this.manager.saveNow();
            this.manager.tryDeleteTeamFile(this.getId() + ".snbt", "party");
        }
        playerTeam.updatePresence();
        playerTeam.onPlayerChangeTeam(this, id, player, deletingTeam);
        this.manager.syncToAll(this, playerTeam);
        return 1;
    }

    public int addAlly(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        if (source.method_44023() != null && !FTBTUtils.canPlayerUseCommand(source.method_44023(), "ftbteams.party.allies.add")) {
            throw TeamArgument.NO_PERMISSION.create();
        }
        UUID from = source.method_9228() == null ? class_156.field_25140 : source.method_9228().method_5667();
        ArrayList<GameProfile> addedPlayers = new ArrayList<GameProfile>();
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.isAllyOrBetter(id)) continue;
            this.ranks.put(id, TeamRank.ALLY);
            this.sendMessage(from, (class_2561)class_2561.method_43469((String)"ftbteams.message.add_ally", (Object[])new Object[]{this.manager.getPlayerName(id).method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1060));
            addedPlayers.add(player);
            class_3222 invitedPlayer = this.manager.getServer().method_3760().method_14602(id);
            if (invitedPlayer == null) continue;
            invitedPlayer.method_7353((class_2561)class_2561.method_43469((String)"ftbteams.message.now_allied", (Object[])new Object[]{this.getDisplayName()}).method_27692(class_124.field_1060), false);
        }
        if (!addedPlayers.isEmpty()) {
            this.markDirty();
            this.manager.syncToAll(this);
            ((Consumer)TeamEvent.ADD_ALLY.invoker()).accept(new TeamAllyEvent(this, addedPlayers, true));
            return 1;
        }
        return 0;
    }

    public int removeAlly(class_2168 source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.method_9228() == null ? class_156.field_25140 : source.method_9228().method_5667();
        ArrayList<GameProfile> removedPlayers = new ArrayList<GameProfile>();
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (!this.isAllyOrBetter(id) || this.isMember(id)) continue;
            this.ranks.remove(id);
            this.sendMessage(from, (class_2561)class_2561.method_43469((String)"ftbteams.message.remove_ally", (Object[])new Object[]{this.manager.getPlayerName(id).method_27661().method_27692(class_124.field_1054)}).method_27692(class_124.field_1065));
            removedPlayers.add(player);
            class_3222 removedPlayer = this.manager.getServer().method_3760().method_14602(id);
            if (removedPlayer == null) continue;
            removedPlayer.method_7353((class_2561)class_2561.method_43469((String)"ftbteams.message.no_longer_allied", (Object[])new Object[]{this.getDisplayName()}).method_27692(class_124.field_1065), false);
        }
        if (!removedPlayers.isEmpty()) {
            this.markDirty();
            this.manager.syncToAll(this);
            ((Consumer)TeamEvent.REMOVE_ALLY.invoker()).accept(new TeamAllyEvent(this, removedPlayers, false));
            return 1;
        }
        return 0;
    }

    public int listAllies(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Allies:"), false);
        boolean any = false;
        for (Map.Entry<UUID, TeamRank> entry : this.getPlayersByRank(TeamRank.ALLY).entrySet()) {
            if (entry.getValue().isAtLeast(TeamRank.MEMBER)) continue;
            source.method_9226(() -> this.manager.getPlayerName((UUID)entry.getKey()), false);
            any = true;
        }
        if (!any) {
            source.method_9226(() -> class_2561.method_43470((String)"None"), false);
        }
        return 1;
    }

    public int forceDisband(class_2168 from) throws CommandSyntaxException {
        HashSet<UUID> members = new HashSet<UUID>(this.getMembers());
        members.remove(this.owner);
        this.kick(from, members.stream().map(id -> new GameProfile(id, null)).toList());
        this.leave(this.owner);
        from.method_9226(() -> class_2561.method_43469((String)"ftbteams.message.team_disbanded", (Object[])new Object[]{this.getName(), this.getId()}).method_27692(class_124.field_1065), false);
        return 1;
    }
}

