/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.tabs;

import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;

public class TabFillingRegistry {
    private static final Map<class_5321<class_1761>, List<ITabFiller>> FILLERS = new IdentityHashMap<class_5321<class_1761>, List<ITabFiller>>();

    @SafeVarargs
    public static void register(ITabFiller filler, class_5321<class_1761> ... tabs) {
        for (class_5321<class_1761> tab : tabs) {
            TabFillingRegistry.registerInternal(tab, filler);
        }
    }

    public static void register(class_5321<class_1761> tab, ITabFiller ... fillers) {
        for (ITabFiller filler : fillers) {
            TabFillingRegistry.registerInternal(tab, filler);
        }
    }

    @SafeVarargs
    public static void registerSimple(class_1935 item, class_5321<class_1761> ... tabs) {
        for (class_5321<class_1761> tab : tabs) {
            TabFillingRegistry.registerInternal(tab, ITabFiller.simple(item));
        }
    }

    public static void registerSimple(class_5321<class_1761> tab, class_1935 ... items) {
        for (class_1935 item : items) {
            TabFillingRegistry.registerInternal(tab, ITabFiller.simple(item));
        }
    }

    @SafeVarargs
    public static void register(Supplier<? extends class_1935> item, class_5321<class_1761> ... tabs) {
        for (class_5321<class_1761> tab : tabs) {
            TabFillingRegistry.registerInternal(tab, ITabFiller.delegating(item));
        }
    }

    @SafeVarargs
    public static void register(class_5321<class_1761> tab, Supplier<? extends class_1935> ... items) {
        for (Supplier<? extends class_1935> item : items) {
            TabFillingRegistry.registerInternal(tab, ITabFiller.delegating(item));
        }
    }

    @ApiStatus.Internal
    public static void fillTabs() {
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((tab, entries) -> {
            class_5321 tabKey = class_7923.field_44687.method_29113((Object)tab).orElse(class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960("placebo", "dummy_tab")));
            FILLERS.getOrDefault(tabKey, Collections.emptyList()).forEach(f -> f.fillItemCategory(tab, (class_1761.class_7704)entries));
        });
    }

    private static void registerInternal(class_5321<class_1761> tab, ITabFiller filler) {
        FILLERS.computeIfAbsent(tab, k -> new ArrayList()).add(filler);
    }
}

