/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.patreon;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.PlaceboClient;
import dev.shadowsoffire.placebo.packets.PatreonDisableMessage;
import dev.shadowsoffire.placebo.patreon.PatreonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

public class WingsManager {
    public static Map<UUID, PatreonUtils.WingType> WINGS = new HashMap<UUID, PatreonUtils.WingType>();
    public static final Set<UUID> DISABLED = new HashSet<UUID>();

    public static void init() {
        new Thread(() -> {
            Placebo.LOGGER.info("Loading patreon wing data...");
            try {
                URL url = new URL("https://raw.githubusercontent.com/TheWinABagel/FakerLib/master/TestWings.txt");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String s;
                    while ((s = reader.readLine()) != null) {
                        String[] split = s.split(" ", 2);
                        if (split.length != 2) {
                            Placebo.LOGGER.error("Invalid patreon wing entry {} will be ignored.", (Object)s);
                            continue;
                        }
                        WINGS.put(UUID.fromString(split[0]), PatreonUtils.WingType.valueOf(split[1]));
                    }
                    reader.close();
                }
                catch (IOException ex) {
                    Placebo.LOGGER.error("Exception loading patreon wing data!");
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Placebo.LOGGER.info("Loaded {} patreon wings.", (Object)WINGS.size());
        }, "Placebo (FakerLib) Patreon Wing Loader").start();
    }

    public static void keys() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (PlaceboClient.TOGGLE_WINGS.method_1436()) {
                PatreonDisableMessage.sendToServer(new PatreonDisableMessage(1, client.field_1724.method_5667()));
            }
        });
    }

    public static PatreonUtils.WingType getType(UUID id) {
        return WINGS.get(id);
    }
}

