/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.json.GearSet;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.jetbrains.annotations.Nullable;

public class GearSetRegistry
extends WeightedDynamicRegistry<GearSet> {
    public static final GearSetRegistry INSTANCE = new GearSetRegistry();

    public GearSetRegistry() {
        super(Placebo.LOGGER, "gear_sets", false, false);
    }

    public <T extends Predicate<GearSet>> GearSet getRandomSet(class_5819 rand, float luck, @Nullable List<GearSet.SetPredicate> armorSets) {
        if (armorSets == null || armorSets.isEmpty()) {
            return (GearSet)this.getRandomItem(rand, luck);
        }
        List valid = this.registry.values().stream().filter(e -> {
            for (Predicate f : armorSets) {
                if (!f.test(e)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (valid.isEmpty()) {
            Placebo.LOGGER.error("Failed to locate any gear sets matching the following predicates: ");
            armorSets.forEach(s -> Placebo.LOGGER.error(s.toString()));
            return (GearSet)this.getRandomItem(rand, luck);
        }
        ArrayList list = new ArrayList(valid.size());
        valid.stream().map(l -> l.wrap(luck)).forEach(list::add);
        return class_6011.method_34986((class_5819)rand, list).map(class_6008.class_6010::method_34983).orElse(null);
    }

    @Override
    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(new class_2960("fakerlib", "gear_set"), GearSet.CODEC);
    }
}

