/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.GearSetRegistry;
import dev.shadowsoffire.placebo.json.WeightedItemStack;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6011;

public record GearSet(int weight, float quality, List<WeightedItemStack> mainhands, List<WeightedItemStack> offhands, List<WeightedItemStack> boots, List<WeightedItemStack> leggings, List<WeightedItemStack> chestplates, List<WeightedItemStack> helmets, List<String> tags) implements CodecProvider<GearSet>,
WeightedDynamicRegistry.ILuckyWeighted
{
    public static final Codec<GearSet> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField(Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), "quality", Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "mainhands", Collections.emptyList()).forGetter(g -> g.mainhands), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "offhands", Collections.emptyList()).forGetter(g -> g.offhands), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "boots", Collections.emptyList()).forGetter(g -> g.boots), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "leggings", Collections.emptyList()).forGetter(g -> g.leggings), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "chestplates", Collections.emptyList()).forGetter(g -> g.chestplates), (App)PlaceboCodecs.nullableField(WeightedItemStack.LIST_CODEC, "helmets", Collections.emptyList()).forGetter(g -> g.helmets), (App)Codec.STRING.listOf().fieldOf("tags").forGetter(g -> g.tags)).apply((Applicative)inst, GearSet::new));

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public float getQuality() {
        return this.quality;
    }

    public class_1309 apply(class_1309 entity) {
        for (class_1304 slot : class_1304.values()) {
            class_6011.method_34986((class_5819)entity.method_6051(), this.getPotentials(slot)).ifPresent(s -> s.apply(entity, slot));
        }
        return entity;
    }

    public List<WeightedItemStack> getPotentials(class_1304 slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case class_1304.field_6173 -> this.mainhands;
            case class_1304.field_6171 -> this.offhands;
            case class_1304.field_6166 -> this.boots;
            case class_1304.field_6172 -> this.leggings;
            case class_1304.field_6174 -> this.chestplates;
            case class_1304.field_6169 -> this.helmets;
        };
    }

    @Override
    public Codec<? extends GearSet> getCodec() {
        return CODEC;
    }

    public static class SetPredicate
    implements Predicate<GearSet> {
        public static final Codec<SetPredicate> CODEC = class_5699.method_39508(s -> s.key, SetPredicate::new);
        protected final String key;
        protected final Predicate<GearSet> internal;

        public SetPredicate(String key) {
            this.key = key;
            if (key.startsWith("#")) {
                String tag = key.substring(1);
                this.internal = t -> t.tags.contains(tag);
            } else {
                class_2960 id = new class_2960(key);
                this.internal = t -> GearSetRegistry.INSTANCE.getKey(t).equals((Object)id);
            }
        }

        @Override
        public boolean test(GearSet t) {
            return this.internal.test(t);
        }

        public String toString() {
            return "SetPredicate[" + this.key + "]";
        }
    }
}

