/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.compat;

import com.google.common.collect.Table;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.api.ModContext;
import com.mrcrayfish.configured.api.util.ConfigScreenHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.BalmConfigProperty;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.apache.commons.lang3.ClassUtils;

public class ConfiguredConfigProvider
implements IModConfigProvider {
    private static IModConfig mapConfig(final String modId, final BalmConfigData configData) {
        return new IModConfig(){

            public void update(IConfigEntry entry) {
                Balm.getConfig().saveBackingConfig(configData.getClass());
            }

            public IConfigEntry getRoot() {
                return ConfiguredConfigProvider.mapConfigRoot(modId, configData);
            }

            public ConfigType getType() {
                return ConfigType.UNIVERSAL;
            }

            public String getFileName() {
                return modId + "-common.toml";
            }

            public String getModId() {
                return modId;
            }

            public void loadWorldConfig(Path path, Consumer<IModConfig> consumer) {
            }
        };
    }

    private static IConfigEntry mapConfigRoot(final String modId, BalmConfigData configData) {
        Table<String, String, BalmConfigProperty<?>> properties = Balm.getConfig().getConfigProperties(configData.getClass());
        final ArrayList<IConfigEntry> children = new ArrayList<IConfigEntry>();
        for (String category : properties.rowKeySet()) {
            if (category.isEmpty()) {
                properties.row((Object)category).entrySet().stream().map(it -> ConfiguredConfigProvider.mapConfigProperty(modId, category, (String)it.getKey(), (BalmConfigProperty)it.getValue())).forEach(children::add);
                continue;
            }
            children.add(ConfiguredConfigProvider.mapConfigCategory(modId, category, properties.row((Object)category)));
        }
        return new IConfigEntry(){

            public List<IConfigEntry> getChildren() {
                return children;
            }

            public boolean isRoot() {
                return true;
            }

            public boolean isLeaf() {
                return false;
            }

            public IConfigValue<?> getValue() {
                return null;
            }

            public String getEntryName() {
                return "";
            }

            public class_2561 getTooltip() {
                return null;
            }

            public String getTranslationKey() {
                return "config." + modId + ".title";
            }
        };
    }

    private static IConfigEntry mapConfigCategory(final String modId, final String category, Map<String, BalmConfigProperty<?>> properties) {
        final List<IConfigEntry> children = properties.keySet().stream().map(it -> ConfiguredConfigProvider.mapConfigProperty(modId, category, it, (BalmConfigProperty)properties.get(it))).toList();
        return new IConfigEntry(){

            public List<IConfigEntry> getChildren() {
                return children;
            }

            public boolean isRoot() {
                return false;
            }

            public boolean isLeaf() {
                return false;
            }

            public IConfigValue<?> getValue() {
                return null;
            }

            public String getEntryName() {
                return category;
            }

            public class_2561 getTooltip() {
                return null;
            }

            public String getTranslationKey() {
                return "config." + modId + "." + category;
            }
        };
    }

    private static <T> IConfigEntry mapConfigProperty(final String modId, final String category, final String key, final BalmConfigProperty<T> property) {
        final T initialValue = property.getValue();
        return new IConfigEntry(){

            public List<IConfigEntry> getChildren() {
                return List.of();
            }

            public boolean isRoot() {
                return false;
            }

            public boolean isLeaf() {
                return true;
            }

            public IConfigValue<?> getValue() {
                return new IConfigValue<T>(){

                    public T get() {
                        return property.getValue();
                    }

                    public T getDefault() {
                        return property.getDefaultValue();
                    }

                    public void set(T o) {
                        property.setValue(o);
                    }

                    public boolean isValid(T o) {
                        return ClassUtils.isAssignable(o.getClass(), property.getType(), (boolean)true);
                    }

                    public boolean isDefault() {
                        return Objects.equals(property.getDefaultValue(), property.getValue());
                    }

                    public boolean isChanged() {
                        return !Objects.equals(property.getValue(), initialValue);
                    }

                    public void restore() {
                        property.setValue(property.getDefaultValue());
                    }

                    public class_2561 getComment() {
                        return category.isEmpty() ? class_2561.method_43471((String)("config." + modId + "." + key + ".tooltip")) : class_2561.method_43471((String)("config." + modId + "." + category + "." + key + ".tooltip"));
                    }

                    public String getTranslationKey() {
                        return category.isEmpty() ? "config." + modId + "." + key : "config." + modId + "." + category + "." + key;
                    }

                    public class_2561 getValidationHint() {
                        return null;
                    }

                    public String getName() {
                        return key;
                    }

                    public void cleanCache() {
                    }

                    public boolean requiresWorldRestart() {
                        return false;
                    }

                    public boolean requiresGameRestart() {
                        return false;
                    }
                };
            }

            public String getEntryName() {
                return category + "." + key;
            }

            public class_2561 getTooltip() {
                return category.isEmpty() ? class_2561.method_43471((String)("config." + modId + "." + key + ".tooltip")) : class_2561.method_43471((String)("config." + modId + "." + category + "." + key + ".tooltip"));
            }

            public String getTranslationKey() {
                return category.isEmpty() ? "config." + modId + "." + key : "config." + modId + "." + category + "." + key;
            }
        };
    }

    public static class_437 createConfigScreen(String modId, class_437 parent) {
        List<? extends BalmConfigData> configs = Balm.getConfig().getConfigsByMod(modId);
        HashMap configsByType = new HashMap();
        Set mappedConfigs = configs.stream().map(it -> ConfiguredConfigProvider.mapConfig(modId, it)).collect(Collectors.toSet());
        configsByType.put(ConfigType.UNIVERSAL, mappedConfigs);
        return ConfigScreenHelper.createSelectionScreen((class_437)parent, (class_2561)class_2561.method_43471((String)("config." + modId + ".title")), configsByType, (class_2960)new class_2960("textures/block/stone.png"));
    }

    public Set<IModConfig> getConfigurationsForMod(ModContext modContext) {
        List<? extends BalmConfigData> configs = Balm.getConfig().getConfigsByMod(modContext.modId());
        return configs.stream().map(it -> ConfiguredConfigProvider.mapConfig(modContext.modId(), it)).collect(Collectors.toSet());
    }
}

