/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.balm.api.config.AbstractBalmConfig;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.entity.BalmEntity;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.network.NetworkVersions;
import net.blay09.mods.balm.api.network.ServerboundModListMessage;
import net.blay09.mods.balm.api.proxy.SidedProxy;
import net.blay09.mods.balm.common.command.BalmCommand;
import net.blay09.mods.balm.config.ExampleConfig;
import net.blay09.mods.balm.fabric.FabricBalmHooks;
import net.blay09.mods.balm.fabric.FabricBalmProxy;
import net.blay09.mods.balm.fabric.FabricBalmRuntime;
import net.blay09.mods.balm.fabric.fluid.BalmFluidStorage;
import net.blay09.mods.balm.fabric.network.FabricBalmNetworking;
import net.blay09.mods.balm.fabric.provider.FabricBalmProviders;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class FabricBalm
implements ModInitializer {
    private static final SidedProxy<FabricBalmProxy> proxy = Balm.sidedProxy("net.blay09.mods.balm.fabric.FabricBalmProxy", "net.blay09.mods.balm.fabric.client.FabricBalmClientProxy");

    public static FabricBalmProxy getProxy() {
        return proxy.get();
    }

    public void onInitialize() {
        ((FabricBalmRuntime)Balm.getRuntime()).initializeRuntime();
        ((FabricBalmHooks)Balm.getHooks()).initialize();
        ((AbstractBalmConfig)Balm.getConfig()).initialize();
        ExampleConfig.initialize();
        Balm.getCommands().register(BalmCommand::register);
        Balm.getNetworking().allowClientAndServerOnly("balm");
        Balm.getNetworking().defineNetworkVersion("balm", "2");
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            class_2487 data = ((BalmEntity)oldPlayer).getFabricBalmData();
            ((BalmEntity)newPlayer).setFabricBalmData(data);
        });
        FabricBalmProviders providers = (FabricBalmProviders)Balm.getProviders();
        providers.registerProvider(new class_2960("balm", "container"), class_1263.class);
        providers.registerProvider(new class_2960("balm", "fluid_tank"), FluidTank.class);
        providers.registerProvider(new class_2960("balm", "energy_storage"), EnergyStorage.class);
        ItemStorage.SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            BalmContainerProvider containerProvider;
            class_1263 container;
            if (blockEntity instanceof BalmContainerProvider && (container = (containerProvider = (BalmContainerProvider)blockEntity).getContainer((class_2350)direction)) != null) {
                return InventoryStorage.of((class_1263)container, (class_2350)direction);
            }
            return null;
        });
        FluidStorage.SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            BalmFluidTankProvider fluidTankProvider;
            FluidTank fluidTank;
            if (blockEntity instanceof BalmFluidTankProvider && (fluidTank = (fluidTankProvider = (BalmFluidTankProvider)blockEntity).getFluidTank((class_2350)direction)) != null) {
                return new BalmFluidStorage(fluidTank);
            }
            return null;
        });
        Balm.getNetworking().registerServerboundPacket(new class_2960("balm", "mod_list"), ServerboundModListMessage.class, (message, buf) -> {
            buf.method_10804(message.modList().size());
            message.modList().forEach((modId, versions) -> {
                buf.method_10814(modId);
                buf.method_10814(versions.modVersion());
                buf.method_10814(versions.networkVersion());
                buf.writeBoolean(versions.requireRemote());
            });
        }, buf -> {
            HashMap<String, NetworkVersions> modVersions = new HashMap<String, NetworkVersions>();
            int modCount = buf.method_10816();
            for (int i = 0; i < modCount; ++i) {
                String modId = buf.method_19772();
                modVersions.put(modId, new NetworkVersions(buf.method_19772(), buf.method_19772(), buf.readBoolean()));
            }
            return new ServerboundModListMessage(modVersions);
        }, (player, message) -> {
            FabricBalmNetworking networking = (FabricBalmNetworking)Balm.getNetworking();
            for (Map.Entry<String, NetworkVersions> entry : message.modList().entrySet()) {
                String modId = entry.getKey();
                NetworkVersions clientVersions = entry.getValue();
                Optional<NetworkVersions> serverVersionsOpt = networking.getNetworkVersions(modId, BalmEnvironment.SERVER);
                if (serverVersionsOpt.isEmpty()) {
                    if (!clientVersions.requireRemote()) continue;
                    player.field_13987.method_14367((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_missing_on_server", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1061)}));
                    return;
                }
                NetworkVersions serverVersions = serverVersionsOpt.get();
                if (clientVersions.networkVersion().equals(serverVersions.networkVersion())) continue;
                player.field_13987.method_14367((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_version_mismatch", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1065), class_2561.method_43470((String)serverVersions.modVersion()).method_27692(class_124.field_1060), class_2561.method_43470((String)clientVersions.modVersion()).method_27692(class_124.field_1061)}));
                return;
            }
            for (String modId : networking.getRegisteredMods()) {
                NetworkVersions serverVersions = networking.getNetworkVersions(modId, BalmEnvironment.SERVER).orElseThrow();
                if (!serverVersions.requireRemote() || message.modList().containsKey(modId)) continue;
                String serverModVersion = serverVersions.modVersion();
                player.field_13987.method_14367((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_missing_on_client", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1061), class_2561.method_43470((String)modId).method_27692(class_124.field_1065), class_2561.method_43470((String)serverModVersion).method_27692(class_124.field_1060)}));
                return;
            }
        });
        Balm.initializeIfLoaded("team_reborn_energy", "net.blay09.mods.balm.fabric.compat.energy.RebornEnergy");
    }
}

