/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util.client;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.CustomComponentParser;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TextComponentParser;
import dev.ftb.mods.ftblibrary.util.client.ImageComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;

public class ClientTextComponentUtils {
    private static final Function<String, class_2561> DEFAULT_STRING_TO_COMPONENT = ClientTextComponentUtils::defaultStringToComponent;
    private static final List<CustomComponentParser> CUSTOM_COMPONENT_PARSERS = new ArrayList<CustomComponentParser>();

    public static void addCustomParser(CustomComponentParser function) {
        CUSTOM_COMPONENT_PARSERS.add(function);
    }

    public static class_2561 parse(String s) {
        return TextComponentParser.parse(s, DEFAULT_STRING_TO_COMPONENT);
    }

    private static class_2561 defaultStringToComponent(String s) {
        if (s.isEmpty()) {
            return class_2561.method_43473();
        }
        if (s.indexOf(58) != -1) {
            Map<String, String> map = StringUtils.splitProperties(s);
            for (CustomComponentParser parser : CUSTOM_COMPONENT_PARSERS) {
                class_2561 c = parser.parse(s, map);
                if (c == null || c == class_2561.field_25310) continue;
                return c;
            }
            if (map.containsKey("image")) {
                ImageComponent c = new ImageComponent();
                c.image = Icon.getIcon(map.get("image"));
                if (map.containsKey("width")) {
                    c.width = Integer.parseInt(map.get("width"));
                }
                if (map.containsKey("height")) {
                    c.height = Integer.parseInt(map.get("height"));
                }
                c.align = ImageComponent.ImageAlign.fromString(map.getOrDefault("align", "center"));
                c.fit = map.getOrDefault("fit", "false").equals("true");
                class_5250 output = class_5250.method_43477((class_7417)c);
                if (map.containsKey("text")) {
                    output.method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)ClientTextComponentUtils.parse(map.get("text")))));
                }
                return output;
            }
            if (map.containsKey("open_url")) {
                return ClientTextComponentUtils.parse(map.get("text")).method_27661().method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, map.get("open_url"))));
            }
        }
        return ClientTextComponentUtils.parse(class_1074.method_4662((String)s, (Object[])new Object[0]));
    }

    public static class_5348 ellipsize(class_327 font, class_5348 text, int maxWidth) {
        int strWidth = font.method_27525(text);
        int ellipsisWidth = font.method_27525((class_5348)class_5244.field_39678);
        if (strWidth > maxWidth) {
            return ellipsisWidth >= maxWidth ? font.method_1714(text, maxWidth) : class_5348.method_29433((class_5348[])new class_5348[]{font.method_1714(text, maxWidth - ellipsisWidth), class_5244.field_39678});
        }
        return text;
    }
}

