/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FTBLibraryClientConfig;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSelectorScreen;
import dev.ftb.mods.ftblibrary.config.ui.SearchModeIndex;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.ModUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class SelectFluidScreen
extends ResourceSelectorScreen<FluidStack> {
    public static final SearchModeIndex<ResourceSearchMode<FluidStack>> KNOWN_MODES = new SearchModeIndex();

    public SelectFluidScreen(FluidConfig config, ConfigCallback callback) {
        super(config, callback);
    }

    @Override
    protected int defaultQuantity() {
        return (int)FluidStackHooks.bucketAmount();
    }

    @Override
    protected SearchModeIndex<ResourceSearchMode<FluidStack>> getSearchModeIndex() {
        return KNOWN_MODES;
    }

    @Override
    protected ResourceSelectorScreen.ResourceButton makeResourceButton(Panel panel, SelectableResource<FluidStack> resource) {
        return new FluidStackButton(panel, Objects.requireNonNullElse(resource, SelectableResource.fluid(FluidStack.empty())));
    }

    static {
        KNOWN_MODES.appendMode(ResourceSearchMode.ALL_FLUIDS);
    }

    private class FluidStackButton
    extends ResourceSelectorScreen.ResourceButton {
        private FluidStackButton(Panel panel, SelectableResource<FluidStack> resource) {
            super(SelectFluidScreen.this, panel, resource);
        }

        @Override
        public boolean shouldAdd(String search) {
            if ((search = search.toLowerCase()).isEmpty()) {
                return true;
            }
            if (search.startsWith("@")) {
                return RegistrarManager.getId((Object)((FluidStack)this.getStack()).getFluid(), (class_5321)class_7924.field_41270).method_12836().contains(search.substring(1));
            }
            if (search.startsWith("#") && class_2960.method_20207((String)search.substring(1))) {
                return ((FluidStack)this.getStack()).getFluid().method_40178().method_40220(class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)new class_2960(search.substring(1))));
            }
            return ((FluidStack)this.getStack()).getName().getString().toLowerCase().contains(search);
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (!((FluidStack)this.getStack()).isEmpty()) {
                list.add(((FluidStack)this.getStack()).getName());
                if (((Boolean)FTBLibraryClientConfig.FLUID_MODNAME.get()).booleanValue()) {
                    ModUtils.getModName(((FluidStack)this.getStack()).getFluid()).ifPresent(name -> list.add((class_2561)class_2561.method_43470((String)name).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056})));
                }
            }
        }
    }
}

