/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ResourceConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.OptionalLong;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class ItemStackConfig
extends ResourceConfigValue<class_1799> {
    private final boolean allowEmpty;
    private final boolean isFixedSize;
    private final long fixedSize;

    public ItemStackConfig(boolean single, boolean empty) {
        this.isFixedSize = single && !empty;
        this.fixedSize = 0L;
        this.allowEmpty = empty;
        this.defaultValue = class_1799.field_8037;
        this.value = class_1799.field_8037;
    }

    public ItemStackConfig(long fixedSize) {
        Validate.isTrue((fixedSize >= 1L ? 1 : 0) != 0);
        this.isFixedSize = true;
        this.fixedSize = fixedSize;
        this.allowEmpty = false;
        this.defaultValue = class_1799.field_8037;
        this.value = class_1799.field_8037;
    }

    @Override
    public class_1799 copy(class_1799 value) {
        return value.method_7960() ? class_1799.field_8037 : value.method_7972();
    }

    @Override
    public class_2561 getStringForGUI(@Nullable class_1799 v) {
        if (v == null || v.method_7960()) {
            return class_2561.method_43471((String)"gui.none");
        }
        if (v.method_7947() <= 1) {
            return v.method_7964();
        }
        return class_2561.method_43470((String)(v.method_7947() + "x ")).method_10852(v.method_7964());
    }

    @Override
    public void onClicked(Widget clickedWidget, MouseButton button, ConfigCallback callback) {
        if (this.getCanEdit()) {
            new SelectItemStackScreen(this, callback).openGui();
        }
    }

    @Override
    public class_1799 getValue() {
        class_1799 val = (class_1799)super.getValue();
        return val.method_7960() ? class_1799.field_8037 : val;
    }

    @Override
    public boolean allowEmptyResource() {
        return this.allowEmpty;
    }

    @Override
    public OptionalLong fixedResourceSize() {
        return this.isFixedSize ? OptionalLong.of(this.fixedSize) : OptionalLong.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.getValue().method_7960();
    }

    @Override
    public SelectableResource<class_1799> getResource() {
        return SelectableResource.item(this.getValue());
    }

    @Override
    public boolean setResource(SelectableResource<class_1799> selectedStack) {
        return this.setCurrentValue(selectedStack.stack());
    }
}

