/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.net.EditConfigPacket;
import dev.ftb.mods.ftblibrary.net.EditNBTPacket;
import dev.ftb.mods.ftblibrary.ui.misc.UITesting;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_106;
import net.minecraft.class_109;
import net.minecraft.class_117;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_141;
import net.minecraft.class_159;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3719;
import net.minecraft.class_3965;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5562;
import net.minecraft.class_5642;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_7157;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_85;

public class FTBLibraryCommands {
    public static final Map<UUID, class_2487> EDITING_NBT = new HashMap<UUID, class_2487>();

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 type) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftblibrary").requires(commandSource -> commandSource.method_9259(2))).then(class_2170.method_9247((String)"gamemode").executes(context -> {
            if (!((class_2168)context.getSource()).method_9207().method_7337()) {
                ((class_2168)context.getSource()).method_9207().method_7336(class_1934.field_9220);
            } else {
                ((class_2168)context.getSource()).method_9207().method_7336(class_1934.field_9215);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"rain").executes(context -> {
            if (((class_2168)context.getSource()).method_9225().method_8419()) {
                ((class_2168)context.getSource()).method_9225().method_27910(6000, 0, false, false);
            } else {
                ((class_2168)context.getSource()).method_9225().method_27910(0, 6000, true, false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"day").executes(context -> {
            long addDay = (24000L - ((class_2168)context.getSource()).method_9225().method_8532() % 24000L + 6000L) % 24000L;
            if (addDay != 0L) {
                for (class_3218 world : ((class_2168)context.getSource()).method_9211().method_3738()) {
                    world.method_29199(world.method_8532() + addDay);
                }
            }
            return 1;
        }))).then(class_2170.method_9247((String)"night").executes(context -> {
            long addDay = (24000L - ((class_2168)context.getSource()).method_9225().method_8532() % 24000L + 18000L) % 24000L;
            if (addDay != 0L) {
                for (class_3218 world : ((class_2168)context.getSource()).method_9211().method_3738()) {
                    world.method_29199(world.method_8532() + addDay);
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nbtedit").then(class_2170.method_9247((String)"block").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> {
            class_2561 title;
            class_2338 pos = class_2262.method_9697((CommandContext)context, (String)"pos");
            class_2586 blockEntity = ((class_2168)context.getSource()).method_9225().method_8321(pos);
            if (blockEntity == null) {
                return;
            }
            info.method_10582("type", "block");
            info.method_10569("x", pos.method_10263());
            info.method_10569("y", pos.method_10264());
            info.method_10569("z", pos.method_10260());
            tag.method_10543(blockEntity.method_38242());
            tag.method_10551("x");
            tag.method_10551("y");
            tag.method_10551("z");
            info.method_10582("id", tag.method_10558("id"));
            tag.method_10551("id");
            class_2499 list = new class_2499();
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Class"), (class_2561)class_2561.method_43470((String)blockEntity.getClass().getName()));
            class_2960 key = RegistrarManager.getId((Object)blockEntity.method_11017(), (class_5321)class_7924.field_41255);
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"ID"), (class_2561)class_2561.method_43470((String)(key == null ? "null" : key.toString())));
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Block"), (class_2561)class_2561.method_43470((String)String.valueOf(RegistrarManager.getId((Object)blockEntity.method_11010().method_26204(), (class_5321)class_7924.field_41254))));
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Block Class"), (class_2561)class_2561.method_43470((String)blockEntity.method_11010().method_26204().getClass().getName()));
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Position"), (class_2561)class_2561.method_43470((String)("[" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + "]")));
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Mod"), (class_2561)class_2561.method_43470((String)(key == null ? "null" : Platform.getOptionalMod((String)key.method_12836()).map(Mod::getName).orElse("Unknown"))));
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Ticking"), (class_2561)class_2561.method_43470((String)(blockEntity instanceof class_5562 ? "true" : "false")));
            info.method_10566("text", (class_2520)list);
            class_2561 class_25612 = title = blockEntity instanceof class_1275 ? ((class_1275)blockEntity).method_5476() : null;
            if (title == null) {
                title = class_2561.method_43470((String)blockEntity.getClass().getSimpleName());
            }
            info.method_10582("title", class_2561.class_2562.method_10867((class_2561)title));
        }))))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            if (entity instanceof class_1657) {
                return;
            }
            info.method_10582("type", "entity");
            info.method_10569("id", entity.method_5628());
            entity.method_5662(tag);
            class_2499 list = new class_2499();
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Class"), (class_2561)class_2561.method_43470((String)entity.getClass().getName()));
            class_2960 key = RegistrarManager.getId((Object)entity.method_5864(), (class_5321)class_7924.field_41266);
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"ID"), (class_2561)class_2561.method_43470((String)(key == null ? "null" : key.toString())));
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Mod"), (class_2561)class_2561.method_43470((String)(key == null ? "null" : Platform.getOptionalMod((String)key.method_12836()).map(Mod::getName).orElse("Unknown"))));
            info.method_10566("text", (class_2520)list);
            info.method_10582("title", class_2561.class_2562.method_10867((class_2561)entity.method_5476()));
        }))))).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            info.method_10582("type", "player");
            info.method_25927("id", player.method_5667());
            player.method_5647(tag);
            tag.method_10551("id");
            class_2499 list = new class_2499();
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Name"), player.method_5477());
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"Display Name"), player.method_5476());
            FTBLibraryCommands.addInfo(list, (class_2561)class_2561.method_43470((String)"UUID"), (class_2561)class_2561.method_43470((String)player.method_5667().toString()));
            info.method_10566("text", (class_2520)list);
            info.method_10582("title", class_2561.class_2562.method_10867((class_2561)player.method_5476()));
        }))))).then(class_2170.method_9247((String)"item").executes(context -> FTBLibraryCommands.editNBT((CommandContext<class_2168>)context, (info, tag) -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            info.method_10582("type", "item");
            player.method_5998(class_1268.field_5808).method_7953(tag);
        }))))).then(class_2170.method_9247((String)"generate_loot_tables").executes(FTBLibraryCommands::generateLootTables))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clientconfig").requires(class_2168::method_43737)).executes(context -> {
            new EditConfigPacket(true).sendTo(Objects.requireNonNull(((class_2168)context.getSource()).method_44023()));
            return 1;
        }));
        if (Platform.isDevelopmentEnvironment()) {
            command.then(class_2170.method_9247((String)"test_screen").executes(context -> {
                if (((class_2168)context.getSource()).method_9211().method_3816()) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Can't do this on dedicated server!").method_27692(class_124.field_1061));
                } else {
                    UITesting.openTestScreen();
                }
                return 1;
            }));
        }
        dispatcher.register(command);
    }

    @Deprecated
    private static int generateLootTables(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_239 pick = player.method_5745(30.0, 1.0f, true);
        if (pick.method_17783() != class_239.class_240.field_1332) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be facing a valid block"));
            return 0;
        }
        class_3965 trace = (class_3965)pick;
        class_3218 level = source.method_9225();
        class_2586 blockEntity = level.method_8321(trace.method_17777());
        if (!(blockEntity instanceof class_2595) && !(blockEntity instanceof class_3719)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be facing a chest or barrel"));
            return 0;
        }
        class_2621 chest = (class_2621)blockEntity;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (int i = 0; i < chest.method_5439(); ++i) {
            class_1799 item = chest.method_5438(i);
            if (item.method_7960()) continue;
            items.add(item);
        }
        try {
            String chestPathName;
            class_55.class_56 tablePool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f));
            for (class_1799 e : items) {
                class_1747 blockItem;
                class_1792 class_17922;
                class_2487 itemTag;
                class_85.class_86 itemBuilder = class_77.method_411((class_1935)e.method_7909()).method_437(1);
                if (e.method_7947() > 1) {
                    itemBuilder.method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)e.method_7947())));
                }
                if ((itemTag = e.method_7948()).method_10545("copy") || e.method_7909() instanceof class_1772 || (class_17922 = e.method_7909()) instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2480) {
                    itemBuilder.method_438((class_117.class_118)class_159.method_677((class_2487)itemTag));
                } else if (e.method_7942()) {
                    if (itemTag.method_10545("level")) {
                        String range = itemTag.method_10558("level");
                        if (range.contains(",")) {
                            String[] split = range.split(",");
                            itemBuilder.method_438((class_117.class_118)class_106.method_481((class_5658)class_5662.method_32462((float)Float.parseFloat(split[0]), (float)Float.parseFloat(split[1]))));
                        } else {
                            itemBuilder.method_438((class_117.class_118)class_106.method_481((class_5658)class_5662.method_32462((float)0.0f, (float)Float.parseFloat(range))));
                        }
                    } else if (itemTag.method_10545("set")) {
                        class_5642.class_6158 enchantBuilder = new class_5642.class_6158();
                        class_1890.method_8222((class_1799)e).forEach((enchant, l) -> enchantBuilder.method_35539(enchant, (class_5658)class_44.method_32448((float)l.intValue())));
                        itemBuilder.method_438((class_117.class_118)enchantBuilder);
                    } else {
                        itemBuilder.method_438((class_117.class_118)class_109.method_489());
                    }
                }
                tablePool.method_351((class_79.class_80)itemBuilder);
            }
            class_52.class_53 lootTable = class_52.method_324().method_336(tablePool);
            Gson gson = class_5270.method_27862().setPrettyPrinting().create();
            String output = gson.toJson((Object)lootTable.method_338());
            Path path = source.method_9211().method_3831().toPath();
            Path outputDir = path.resolve("moddata/ftb-library/generated/");
            Object outputFileName = "loot-" + (blockEntity instanceof class_2595 ? "chest" : "barrel") + "-" + LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replaceAll(":|\\.", "_") + ".json";
            class_2561 customName = chest.method_5797();
            if (customName != null && customName.getString().contains("/") && !customName.getString().contains("..") && (chestPathName = customName.getString()).chars().filter(c -> c == 47).count() == 2L) {
                String[] pathParts = chestPathName.split("/");
                outputFileName = String.format("%s.json", pathParts[2]);
                outputDir = path.resolve(String.format("kubejs/%s/loot_tables/%s/", pathParts[0], pathParts[1]));
            }
            if (!Files.exists(outputDir, new LinkOption[0])) {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            Files.writeString(outputDir.resolve((String)outputFileName), (CharSequence)output, new OpenOption[0]);
            Path dir = outputDir.resolve((String)outputFileName);
            source.method_9226(() -> class_2561.method_43470((String)("Loot table stored at " + dir.toString().replace(path.toAbsolutePath().toString(), ""))), true);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Something went wrong, check the logs"));
            FTBLibrary.LOGGER.error((Object)e);
            return 0;
        }
        return 1;
    }

    private static void addInfo(class_2499 list, class_2561 key, class_2561 value) {
        list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)key.method_27661().method_27692(class_124.field_1078).method_27693(": ").method_10852((class_2561)value.method_27661().method_27692(class_124.field_1065)))));
    }

    private static int editNBT(CommandContext<class_2168> context, NBTEditCallback data) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2487 info = new class_2487();
        class_2487 tag = new class_2487();
        data.accept(info, tag);
        if (!info.method_33133()) {
            EDITING_NBT.put(player.method_5667(), info);
            new EditNBTPacket(info, tag).sendTo(player);
            return 1;
        }
        return 0;
    }

    private static interface NBTEditCallback {
        public void accept(class_2487 var1, class_2487 var2) throws CommandSyntaxException;
    }
}

