/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.s2c;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.cobalt.network.Message;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.MelodyLoader;
import immersive_melodies.resources.ServerMelodyManager;
import immersive_melodies.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class MelodyListMessage
extends Message {
    private final Map<class_2960, MelodyDescriptor> melodies = new HashMap<class_2960, MelodyDescriptor>();

    public MelodyListMessage(class_1657 receiver) {
        for (Map.Entry<class_2960, MelodyLoader.LazyMelody> lazyMelodyEntry : ServerMelodyManager.getDatapackMelodies().entrySet()) {
            this.melodies.put(lazyMelodyEntry.getKey(), lazyMelodyEntry.getValue().getDescriptor());
        }
        if (Config.getInstance().showOtherPlayersMelodies) {
            this.melodies.putAll(ServerMelodyManager.getIndex().getMelodies());
        } else {
            ServerMelodyManager.getIndex().getMelodies().forEach((id, desc) -> {
                if (Utils.ownsMelody(id, receiver)) {
                    this.melodies.put((class_2960)id, (MelodyDescriptor)desc);
                }
            });
        }
    }

    @Override
    public void encode(class_2540 b) {
        b.writeInt(this.melodies.size());
        for (Map.Entry<class_2960, MelodyDescriptor> entry : this.melodies.entrySet()) {
            b.method_10812(entry.getKey());
            entry.getValue().encodeLite(b);
        }
    }

    public MelodyListMessage(class_2540 b) {
        int size = b.readInt();
        for (int i = 0; i < size; ++i) {
            this.melodies.put(b.method_10810(), new MelodyDescriptor(b));
        }
    }

    @Override
    public void receive(class_1657 e) {
        Common.networkManager.handleMelodyListMessage(this);
    }

    public Map<class_2960, MelodyDescriptor> getMelodies() {
        return this.melodies;
    }
}

