/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network;

import immersive_melodies.cobalt.network.NetworkHandler;
import immersive_melodies.network.c2s.UploadMelodyRequest;
import immersive_melodies.network.s2c.MelodyResponse;
import immersive_melodies.resources.Melody;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PacketSplitter {
    private static final int FRAGMENT_SIZE = 8192;

    private static List<byte[]> fragmentate(Melody melody) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        melody.encode(buffer);
        byte[] array = new byte[buffer.writerIndex()];
        buffer.getBytes(0, array);
        LinkedList<byte[]> fragments = new LinkedList<byte[]>();
        for (int i = 0; i < array.length; i += 8192) {
            byte[] fragment = new byte[Math.min(8192, array.length - i)];
            System.arraycopy(array, i, fragment, 0, fragment.length);
            fragments.add(fragment);
        }
        return fragments;
    }

    public static void sendToServer(String name, Melody melody) {
        List<byte[]> fragments = PacketSplitter.fragmentate(melody);
        int length = fragments.stream().mapToInt(f -> ((byte[])f).length).sum();
        for (byte[] fragment : fragments) {
            NetworkHandler.sendToServer(new UploadMelodyRequest(name, fragment, length));
        }
    }

    public static void sendToPlayer(class_2960 identifier, Melody melody, class_3222 player) {
        List<byte[]> fragments = PacketSplitter.fragmentate(melody);
        int length = fragments.stream().mapToInt(f -> ((byte[])f).length).sum();
        for (byte[] fragment : fragments) {
            NetworkHandler.sendToPlayer(new MelodyResponse(identifier, fragment, length), player);
        }
    }
}

