/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies;

import immersive_melodies.Common;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class MidiListener {
    public static void launch() {
        new Thread(new MidiListenerThread()).start();
    }

    static class MidiListenerThread
    implements Runnable {
        MidiListenerThread() {
        }

        @Override
        public void run() {
            try {
                MidiDevice.Info[] midiDevices;
                for (MidiDevice.Info info : midiDevices = MidiSystem.getMidiDeviceInfo()) {
                    try {
                        MidiDevice device = MidiSystem.getMidiDevice(info);
                        Common.LOGGER.info("MIDI Device: {} - {}", (Object)info.getName(), (Object)info.getDescription());
                        if (device.getMaxTransmitters() == 0) continue;
                        device.open();
                        Transmitter transmitter = device.getTransmitter();
                        transmitter.setReceiver(new MidiReceiver());
                    }
                    catch (MidiUnavailableException e) {
                        Common.LOGGER.warn("MIDI Device unavailable: {}", (Object)info.getName(), (Object)e);
                    }
                }
            }
            catch (Exception e) {
                Common.LOGGER.error("Error initializing MIDI devices", (Throwable)e);
            }
        }
    }

    static class MidiReceiver
    implements Receiver {
        MidiReceiver() {
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            byte[] data = message.getMessage();
            StringBuilder sb = new StringBuilder("MIDI message received: ");
            for (byte b : data) {
                sb.append(String.format("%02X ", b));
            }
            Common.LOGGER.info(sb.toString());
        }

        @Override
        public void close() {
        }
    }
}

