/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.kenddie.fantasyarmor.FantasyArmor;
import net.kenddie.fantasyarmor.config.ConfigValues;

public final class FAConfig {
    private static final Path CONFIG_FILE_PATH = Paths.get("config", "fantasy_armor", "fantasy_armor.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ConfigValues values;

    private FAConfig() {
    }

    public static void save() {
        File configFile = CONFIG_FILE_PATH.toFile();
        File parentFile = configFile.getParentFile();
        if (parentFile == null) {
            return;
        }
        if (!parentFile.mkdirs() && !parentFile.isDirectory()) {
            FantasyArmor.LOGGER.warn("Failed to save config: Directory could not be created.");
            return;
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)values, (Appendable)writer);
        }
        catch (IOException e) {
            FantasyArmor.LOGGER.warn("Failed to save config: ", (Throwable)e);
        }
    }

    public static void load() {
        try (FileReader reader = new FileReader(CONFIG_FILE_PATH.toFile());){
            values = (ConfigValues)GSON.fromJson((Reader)reader, ConfigValues.class);
        }
        catch (IOException e) {
            FantasyArmor.LOGGER.warn("Failed to read config (default parameters will be used): ", (Throwable)e);
            FAConfig.loadDefaults();
        }
    }

    public static void loadDefaults() {
        values = new ConfigValues(true, true, true, 250);
    }

    public static boolean exists() {
        return CONFIG_FILE_PATH.toFile().exists();
    }

    public static ConfigValues getValues() {
        return values;
    }

    static {
        FAConfig.loadDefaults();
    }
}

