/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.blossom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.yurisuika.blossom.block.FloweringLeavesBlock;
import dev.yurisuika.blossom.server.command.BlossomCommand;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1163;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1926;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class Blossom
implements ModInitializer,
ClientModInitializer {
    public static File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "blossom.json");
    public static Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
    public static Config config = new Config();
    public static final class_6862<class_1959> ALLOWS_BLOSSOMS = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("blossom", "allows_blossoms"));
    public static final class_6862<class_2248> BLOSSOMS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("blossom", "blossoms"));
    public static final class_2248 FLOWERING_OAK_LEAVES = new FloweringLeavesBlock(class_2246.field_10503, FabricBlockSettings.method_9630((class_4970)class_2246.field_10503).method_29292());

    public static void saveConfig() {
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)Blossom.getConfig()));
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        try {
            config = file.exists() ? (Config)gson.fromJson(Files.readString(file.toPath()), Config.class) : new Config();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Blossom.checkBounds();
        Blossom.setConfig(config);
    }

    public static void setConfig(Config config) {
        Blossom.config = config;
    }

    public static Config getConfig() {
        return config;
    }

    public static void checkBounds() {
        int min = Math.max(Math.min(Math.min(Blossom.config.count.min, 64), Blossom.config.count.max), 1);
        int max = Math.max(Math.max(Math.min(Blossom.config.count.max, 64), Blossom.config.count.min), 1);
        Blossom.config.rate = Math.max(Blossom.config.rate, 1);
        Blossom.config.count.min = min;
        Blossom.config.count.max = max;
        Blossom.saveConfig();
    }

    public static void registerCompostables() {
        CompostingChanceRegistry.INSTANCE.add((class_1935)FLOWERING_OAK_LEAVES, (Object)Float.valueOf(0.3f));
    }

    public static void registerFlammables() {
        FlammableBlockRegistry.getDefaultInstance().add(FLOWERING_OAK_LEAVES, 30, 60);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerRenderLayers() {
        BlockRenderLayerMap.INSTANCE.putBlock(FLOWERING_OAK_LEAVES, class_1921.method_23581());
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerColorProviders() {
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> world != null && pos != null ? class_1163.method_4966((class_1920)world, (class_2338)pos) : class_1926.method_8344((double)0.5, (double)1.0), (Object[])new class_2248[]{FLOWERING_OAK_LEAVES});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex > 0 ? -1 : class_310.method_1551().method_1505().method_1697(((class_1747)stack.method_7909()).method_7711().method_9564(), null, null, tintIndex), (Object[])new class_1935[]{FLOWERING_OAK_LEAVES});
    }

    public void onInitialize() {
        if (!file.exists()) {
            Blossom.saveConfig();
        }
        Blossom.loadConfig();
        CommandRegistrationCallback.EVENT.register(BlossomCommand::register);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("blossom", "flowering_oak_leaves"), (Object)FLOWERING_OAK_LEAVES);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("blossom", "flowering_oak_leaves"), (Object)new class_1747(FLOWERING_OAK_LEAVES, new class_1792.class_1793()));
        Blossom.registerFlammables();
        Blossom.registerCompostables();
    }

    public void onInitializeClient() {
        Blossom.registerRenderLayers();
        Blossom.registerColorProviders();
    }

    public static class Config {
        public boolean exposed = true;
        public int rate = 5;
        public Count count = new Count(2, 4);
    }

    public static class Count {
        public int min;
        public int max;

        public Count(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

