/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.rpgmana.mixin;

import com.cleannrooster.rpgmana.Rpgmana;
import com.cleannrooster.rpgmana.api.ManaInterface;
import com.cleannrooster.rpgmana.api.SpellcostMixinInterface;
import com.cleannrooster.rpgmana.item.ItemInit;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Sound;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.WorldScheduler;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.SoundHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpellHelper.class})
public class SpellCastMixin {
    private static float getManaCost(class_1657 player, Spell spell, SpellCast.Action action, float progress) {
        float channelMultiplier = 1.0f;
        switch (action) {
            case CHANNEL: {
                channelMultiplier = SpellHelper.channelValueMultiplier((Spell)spell);
                break;
            }
            case RELEASE: {
                channelMultiplier = SpellHelper.isChanneled((Spell)spell) ? 1.0f : (progress >= 1.0f ? 1.0f : 0.0f);
            }
        }
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext(channelMultiplier, 1.0f, (class_243)null, SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)player), SpellHelper.impactTargetingMode((Spell)spell));
        float coeff = 0.0f;
        int proj = 1;
        if (spell.impact != null && ((SpellcostMixinInterface)spell.cost).calculateManaCost()) {
            for (Spell.Impact impact : spell.impact) {
                if (impact.action == null || impact.action.damage == null) continue;
                coeff += impact.action.damage.spell_power_coefficient;
            }
            if (spell.impact != null && spell.impact.length > 0) {
                coeff /= (float)spell.impact.length;
            }
            if (spell.release != null && spell.release.target != null && spell.release.target.projectile != null) {
                proj += spell.release.target.projectile.launch_properties.extra_launch_count;
            }
        }
        float mult = (float)((double)Rpgmana.config.inspiration * 0.01 * (double)SpellPowerEnchanting.getEnchantmentLevel((class_1887)Rpgmana.ARCHMAGE, (class_1309)player, (class_1799)player.method_6047()) - (double)Rpgmana.config.manastabilized * 0.01 * (double)SpellPowerEnchanting.getEnchantmentLevel((class_1887)Rpgmana.MANASTABILIZED, (class_1309)player, (class_1799)player.method_6047()) + player.method_26825((class_1320)Rpgmana.MANACOST) * (double)0.01f);
        return mult * context.total() * (((SpellcostMixinInterface)spell.cost).calculateManaCost() ? Math.max(20.0f, 40.0f * coeff * (float)proj) : ((SpellcostMixinInterface)spell.cost).getManaCost());
    }

    private static boolean matches(String subject, String nullableRegex) {
        if (subject == null) {
            return false;
        }
        if (nullableRegex == null || nullableRegex.isEmpty()) {
            return false;
        }
        Pattern pattern = Pattern.compile(nullableRegex, 2);
        Matcher matcher = pattern.matcher(subject);
        return matcher.find();
    }

    @Inject(at={@At(value="HEAD")}, method={"ammoForSpell"}, cancellable=true)
    private static void ammoForSpellMana(class_1657 player, Spell spell, class_1799 itemStack, CallbackInfoReturnable<SpellHelper.AmmoResult> returnable) {
        ManaInterface manaInterface;
        boolean satisfied = true;
        class_1799 ammo = null;
        if (player.method_6059(Rpgmana.BORROWEDPOWER) || player instanceof ManaInterface && (manaInterface = (ManaInterface)player).getMana() > 0.0) {
            ammo = ItemInit.MANA.method_7854();
            returnable.setReturnValue((Object)new SpellHelper.AmmoResult(satisfied, ammo));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"performSpell"}, cancellable=true)
    private static void performSpell(class_1937 world, class_1657 player, class_2960 spellId, List<class_1297> targets, SpellCast.Action action, float progress, CallbackInfo info) {
        Spell spell = SpellRegistry.getSpell((class_2960)spellId);
        if (!SpellCastMixin.matches(spellId.toString(), Rpgmana.config.blacklist_spell_casting_regex) && player instanceof ManaInterface) {
            ManaInterface manaInterface = (ManaInterface)player;
            if (spell.release != null && spell.cost != null && spell.cost.item_id != null && !spell.cost.item_id.contains("arrow")) {
                SpellCast.Attempt attempt = SpellHelper.attemptCasting((class_1657)player, (class_1799)player.method_6047(), (class_2960)spellId);
                if (attempt.isSuccess()) {
                    progress = Math.max(Math.min(progress, 1.0f), 0.0f);
                    float channelMultiplier = 1.0f;
                    boolean shouldPerformImpact = true;
                    switch (action) {
                        case CHANNEL: {
                            channelMultiplier = SpellHelper.channelValueMultiplier((Spell)spell);
                            break;
                        }
                        case RELEASE: {
                            channelMultiplier = SpellHelper.isChanneled((Spell)spell) ? 1.0f : (progress >= 1.0f ? 1.0f : 0.0f);
                            SpellCastSyncHelper.clearCasting((class_1657)player);
                        }
                    }
                    float finalProgress = progress;
                    if (SpellHelper.ammoForSpell((class_1657)player, (Spell)spell, (class_1799)player.method_6047()).ammo() != null && SpellHelper.ammoForSpell((class_1657)player, (Spell)spell, (class_1799)player.method_6047()).ammo().method_7909() == ItemInit.MANA && player instanceof SpellCasterEntity) {
                        SpellCasterEntity casterEntity = (SpellCasterEntity)player;
                        ((WorldScheduler)world).schedule(1, () -> {
                            if (!casterEntity.getCooldownManager().isCoolingDown(spellId) && action == SpellCast.Action.RELEASE) {
                                casterEntity.getCooldownManager().set(spellId, 2);
                            }
                            manaInterface.spendMana(-SpellCastMixin.getManaCost(player, spell, action, finalProgress));
                        });
                    }
                } else {
                    boolean needsArrow = false;
                    if (spell.cost != null) {
                        class_2960 id = new class_2960(spell.cost.item_id);
                        if (spell.cost.item_id != null) {
                            needsArrow = id.method_12832().contains("arrow");
                        }
                    }
                    if (SpellHelper.ammoForSpell((class_1657)player, (Spell)spell, (class_1799)player.method_6047()).satisfied() || needsArrow) {
                        return;
                    }
                    Supplier trackingPlayers = Suppliers.memoize(() -> PlayerLookup.tracking((class_1297)player));
                    class_1799 itemStack = player.method_6047();
                    ParticleHelper.sendBatches((class_1297)player, (ParticleBatch[])spell.release.particles);
                    SoundHelper.playSound((class_1937)world, (class_1297)player, (Sound)spell.release.sound);
                    float castingSpeed = ((SpellCasterEntity)player).getCurrentCastingSpeed();
                    AnimationHelper.sendAnimation((class_1657)player, (Collection)((Collection)trackingPlayers.get()), (SpellCast.Animation)SpellCast.Animation.RELEASE, (String)spell.release.animation, (float)castingSpeed);
                    SpellHelper.imposeCooldown((class_1657)player, (class_2960)spellId, (Spell)spell, (float)1.0f);
                    player.method_7322(spell.cost.exhaust * SpellEngineMod.config.spell_cost_exhaust_multiplier);
                    if (SpellEngineMod.config.spell_cost_durability_allowed && spell.cost.durability > 0) {
                        itemStack.method_7956(spell.cost.durability, (class_1309)player, playerObj -> {
                            playerObj.method_20235(class_1304.field_6173);
                            playerObj.method_20235(class_1304.field_6171);
                        });
                    }
                    if (spell.cost.effect_id != null) {
                        class_1291 effect = (class_1291)class_7923.field_41174.method_10223(new class_2960(spell.cost.effect_id));
                        player.method_6016(effect);
                    }
                    SpellCastSyncHelper.clearCasting((class_1657)player);
                    info.cancel();
                }
            }
        }
    }
}

