/*
 * Decompiled with CFR 0.152.
 */
package com.spellbladenext.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.spellbladenext.Spellblades;
import com.spellbladenext.entity.Magister;
import com.spellbladenext.entity.ai.BackUp;
import com.spellbladenext.entity.ai.MagisterSensor;
import com.spellbladenext.entity.ai.MeleeAttack;
import com.spellbladenext.entity.ai.SpellAttack;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4102;
import net.minecraft.class_4107;
import net.minecraft.class_4109;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4115;
import net.minecraft.class_4117;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4215;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_5321;
import net.minecraft.class_5418;
import net.minecraft.class_6670;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_7898;
import net.minecraft.class_7923;

public class MagisterAI {
    private static final int ANGER_DURATION = 600;
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final double ACTIVITY_SOUND_LIKELIHOOD_PER_TICK = 0.0125;
    private static final int MAX_LOOK_DIST = 8;
    private static final int INTERACTION_RANGE = 8;
    private static final double TARGETING_RANGE = 12.0;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;
    private static final int HOME_CLOSE_ENOUGH_DISTANCE = 2;
    private static final int HOME_TOO_FAR_DISTANCE = 100;
    private static final int HOME_STROLL_AROUND_DISTANCE = 5;
    public static final class_4149<MagisterSensor> MAGISTER_SENSOR_SENSOR_TYPE = MagisterAI.register("golem_detected", MagisterSensor::new);

    private static <U extends class_4148<?>> class_4149<U> register(String p_26829_, Supplier<U> p_26830_) {
        return (class_4149)class_2378.method_10230((class_2378)class_7923.field_41130, (class_2960)new class_2960(Spellblades.MOD_ID, p_26829_), (Object)new class_4149(p_26830_));
    }

    public static class_4095<?> makeBrain(Magister reaver, class_4095<Magister> brain) {
        MagisterAI.initCoreActivity(reaver, brain);
        MagisterAI.initIdleActivity(reaver, brain);
        MagisterAI.initFightActivity(reaver, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    protected static void initMemories(Magister reaver) {
        class_4208 globalPos = class_4208.method_19443((class_5321)reaver.method_37908().method_27983(), (class_2338)reaver.method_24515());
        reaver.method_18868().method_18878(class_4140.field_18438, (Object)globalPos);
    }

    private static void initCoreActivity(Magister reaver, class_4095<Magister> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)new class_4112(), (Object)class_7898.method_47227(piglin -> !reaver.isScout || reaver.nemesis == null, (class_7894)class_4117.method_47191((float)0.75f)), (Object)class_4107.method_46964(), (Object)class_4829.method_47143()));
    }

    private static void initIdleActivity(Magister reaver, class_4095<Magister> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)new class_4112(), (Object)class_4824.method_47119(MagisterAI::findNearestValidAttackTarget), MagisterAI.makeRandomFollowTask(), (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)16)));
    }

    private static void initFightActivity(Magister reaver, class_4095<Magister> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47138(livingEntity -> !MagisterAI.isNearestValidAttackTarget(reaver, livingEntity)), new BackUp(8, 0.75f), MagisterAI.create(1.125f), new SpellAttack(), (Object)((Object)new MeleeAttack(20))), class_4140.field_22355);
    }

    public static class_7893<class_1308> create(float speed) {
        return MagisterAI.create(entity -> Float.valueOf(speed));
    }

    public static class_7893<class_1308> create(Function<class_1309, Float> speed) {
        return class_7898.method_47224(context -> context.group((App)context.method_47235(class_4140.field_18445), (App)context.method_47235(class_4140.field_18446), (App)context.method_47244(class_4140.field_22355), (App)context.method_47235(class_4140.field_18442)).apply((Applicative)context, (walkTarget, lookTarget, attackTarget, visibleMobs) -> (world, entity, time) -> {
            Magister magister;
            class_1309 livingEntity = (class_1309)context.method_47243(attackTarget);
            Optional optional = context.method_47233(visibleMobs);
            if (optional.isPresent() && ((class_6670)optional.get()).method_38972(livingEntity) && class_4215.method_25940((class_1308)entity, (class_1309)livingEntity, (int)1) || entity instanceof Magister && (magister = (Magister)entity).isCaster() && magister.method_5739((class_1297)livingEntity) <= 16.0f) {
                walkTarget.method_47252();
            } else {
                lookTarget.method_47249((Object)new class_4102((class_1297)livingEntity, true));
                walkTarget.method_47249((Object)new class_4142((class_4115)new class_4102((class_1297)livingEntity, false), ((Float)speed.apply(entity)).floatValue(), 0));
            }
            return true;
        }));
    }

    private static class_4118<class_1309> makeRandomFollowTask() {
        return new class_4118((List)ImmutableList.builder().addAll(MagisterAI.makeFollowTasks()).add((Object)Pair.of((Object)new class_4101(30, 60), (Object)1)).build());
    }

    private static ImmutableList<Pair<class_7894<class_1309>, Integer>> makeFollowTasks() {
        return ImmutableList.of((Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_6097, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47057((class_1299)class_1299.field_22281, (float)8.0f), (Object)1), (Object)Pair.of((Object)class_4119.method_47056((float)8.0f), (Object)1));
    }

    public static void updateActivity(Magister reaver) {
        class_4095<Magister> brain = reaver.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
        class_4168 activity2 = brain.method_24538().orElse(null);
        if (activity != activity2) {
            MagisterAI.playActivitySound(reaver);
        }
        reaver.method_19540(brain.method_18896(class_4140.field_22355));
    }

    private static boolean isNearestValidAttackTarget(Magister reaver, class_1309 livingEntity) {
        if (reaver.isScout() && reaver.method_6047().method_7960()) {
            return false;
        }
        return MagisterAI.findNearestValidAttackTarget(reaver).filter(livingEntity2 -> livingEntity2 == livingEntity).isPresent();
    }

    static Optional<? extends class_1309> findNearestValidAttackTarget(Magister abstractPiglin) {
        if (abstractPiglin.isScout() && abstractPiglin.method_6047().method_7960()) {
            return Optional.empty();
        }
        Optional optional = class_4215.method_24560((class_1309)abstractPiglin, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && class_4148.method_37456((class_1309)abstractPiglin, (class_1309)((class_1309)optional.get()))) {
            return optional;
        }
        Optional optional2 = MagisterAI.getTargetIfWithinRange(abstractPiglin, (class_4140<? extends class_1309>)class_4140.field_22354);
        return optional2.isPresent() ? optional2 : abstractPiglin.method_18868().method_46873(class_4140.field_25360);
    }

    private static Optional<? extends class_1309> getTargetIfWithinRange(Magister abstractPiglin, class_4140<? extends class_1309> memoryModuleType) {
        return abstractPiglin.method_18868().method_46873(memoryModuleType).filter(livingEntity -> livingEntity.method_24516((class_1297)abstractPiglin, 36.0) && !livingEntity.method_6059(Spellblades.MAGISTERFRIEND) && !(livingEntity instanceof Magister));
    }

    protected static void wasHurtBy(Magister reaver, class_1309 livingEntity) {
        if (!(livingEntity instanceof class_5418)) {
            MagisterAI.maybeRetaliate(reaver, livingEntity);
        }
    }

    protected static void maybeRetaliate(Magister abstractPiglin, class_1309 livingEntity) {
        if (!abstractPiglin.method_18868().method_18906(class_4168.field_22399) && class_4148.method_37456((class_1309)abstractPiglin, (class_1309)livingEntity) && !class_4215.method_24558((class_1309)abstractPiglin, (class_1309)livingEntity, (double)4.0)) {
            if (livingEntity.method_5864() == class_1299.field_6097 && abstractPiglin.method_37908().method_8450().method_8355(class_1928.field_25402)) {
                MagisterAI.setAngerTargetToNearestTargetablePlayerIfFound(abstractPiglin, livingEntity);
                MagisterAI.broadcastUniversalAnger(abstractPiglin);
            } else {
                MagisterAI.setAngerTarget(abstractPiglin, livingEntity);
                MagisterAI.broadcastAngerTarget(abstractPiglin, livingEntity);
            }
        }
    }

    protected static void broadcastUniversalAnger(Magister abstractPiglin) {
        MagisterAI.getAdultPiglins(abstractPiglin).forEach(abstractPiglinx -> MagisterAI.getNearestVisibleTargetablePlayer(abstractPiglinx).ifPresent(player -> MagisterAI.setAngerTarget(abstractPiglinx, (class_1309)player)));
    }

    private static List<Magister> getAdultPiglins(Magister abstractPiglin) {
        return (List)abstractPiglin.method_18868().method_46873(class_4140.field_25755).orElse(ImmutableList.of());
    }

    protected static void broadcastAngerTarget(Magister abstractPiglin, class_1309 livingEntity) {
        MagisterAI.getAdultPiglins(abstractPiglin).forEach(abstractPiglinx -> MagisterAI.setAngerTargetIfCloserThanCurrent(abstractPiglinx, livingEntity));
    }

    private static Optional<class_1309> getAngerTarget(Magister abstractPiglin) {
        return class_4215.method_24560((class_1309)abstractPiglin, (class_4140)class_4140.field_22333);
    }

    private static void setAngerTargetIfCloserThanCurrent(Magister abstractPiglin, class_1309 livingEntity) {
        Optional<class_1309> optional = MagisterAI.getAngerTarget(abstractPiglin);
        class_1309 livingEntity2 = class_4215.method_24562((class_1309)abstractPiglin, optional, (class_1309)livingEntity);
        if (!optional.isPresent() || optional.get() != livingEntity2) {
            MagisterAI.setAngerTarget(abstractPiglin, livingEntity2);
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(Magister abstractPiglin, class_1309 livingEntity) {
        Optional<class_1657> optional = MagisterAI.getNearestVisibleTargetablePlayer(abstractPiglin);
        if (optional.isPresent()) {
            MagisterAI.setAngerTarget(abstractPiglin, (class_1309)optional.get());
        } else {
            MagisterAI.setAngerTarget(abstractPiglin, livingEntity);
        }
    }

    public static Optional<class_1657> getNearestVisibleTargetablePlayer(Magister abstractPiglin) {
        return abstractPiglin.method_18868().method_18896(class_4140.field_22354) ? abstractPiglin.method_18868().method_46873(class_4140.field_22354) : Optional.empty();
    }

    protected static void setAngerTarget(Magister reaver, class_1309 livingEntity) {
        reaver.method_18868().method_18875(class_4140.field_19293);
        reaver.method_18868().method_24525(class_4140.field_22333, (Object)livingEntity.method_5667(), 600L);
    }

    protected static void maybePlayActivitySound(Magister reaver) {
        if ((double)reaver.method_37908().field_9229.method_43057() < 0.0125) {
            MagisterAI.playActivitySound(reaver);
        }
    }

    private static void playActivitySound(Magister reaver) {
        reaver.method_18868().method_24538().ifPresent(activity -> {});
    }
}

