/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.orcinus.galosphere.api.BannerAttachable;
import net.orcinus.galosphere.api.GoldenBreath;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.items.SterlingArmorItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin
implements BannerAttachable,
GoldenBreath,
SpectreBoundSpyglass {
    @Shadow
    protected class_1799 field_6277;
    @Unique
    private static final class_2940<class_1799> BANNER_STACK = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13322);
    @Unique
    private static final class_2940<Float> GOLDEN_AIR_SUPPLY = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13320);
    @Unique
    private static final class_2940<Boolean> USING_SPECTRE_BOUNDED_SPYGLASS = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13323);
    @Unique
    private boolean preserved;

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    public void G$defineSynchedData(CallbackInfo ci) {
        class_2945 data = ((class_1309)this).method_5841();
        data.method_12784(BANNER_STACK, (Object)class_1799.field_8037);
        data.method_12784(GOLDEN_AIR_SUPPLY, (Object)Float.valueOf(0.0f));
        data.method_12784(USING_SPECTRE_BOUNDED_SPYGLASS, (Object)false);
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData"})
    public void G$addAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        tag.method_10566("BannerStack", (class_2520)((class_1799)((class_1309)this).method_5841().method_12789(BANNER_STACK)).method_7953(new class_2487()));
        tag.method_10548("GoldenAirSupply", this.getGoldenAirSupply());
        tag.method_10556("UsingSpectreBoundedSpyglass", this.isUsingSpectreBoundedSpyglass());
        tag.method_10556("Preserved", this.preserved);
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData"})
    public void G$readAdditionalSavaData(class_2487 tag, CallbackInfo ci) {
        this.setBanner(class_1799.method_7915((class_2487)tag.method_10562("BannerStack")));
        this.setGoldenAirSupply(tag.method_10583("GoldenAirSupply"));
        this.setUsingSpectreBoundedSpyglass(tag.method_10577("UsingSpectreBoundedSpyglass"));
        if (this.preserved) {
            this.preserved = tag.method_10577("Preserved");
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void G$tick(CallbackInfo ci) {
        BannerAttachable bannerEntity;
        class_1309 $this = (class_1309)this;
        if (SpectreBoundSpyglass.canUseSpectreBoundSpyglass(this.field_6277) && this.field_6277.method_7969() != null && !$this.method_37908().field_9236) {
            class_1297 spectreBound = ((class_3218)$this.method_37908()).method_14190(this.field_6277.method_7969().method_25926("SpectreBoundUUID"));
            Optional.ofNullable(spectreBound).filter(Spectre.class::isInstance).map(Spectre.class::cast).filter(class_1309::method_5805).ifPresent(spectre -> {
                if ($this instanceof class_1657) {
                    class_1657 player = (class_1657)$this;
                    if (spectre.getManipulatorUUID() != player.method_5667()) {
                        boolean withinDistance;
                        boolean bl = withinDistance = Math.sqrt(Math.pow(player.method_23317() - spectre.method_23317(), 2.0) + Math.pow(player.method_23321() - spectre.method_23321(), 2.0)) < 110.0;
                        if (withinDistance) {
                            spectre.setCamera(player);
                        }
                    }
                }
            });
        }
        if ($this instanceof BannerAttachable && !(bannerEntity = (BannerAttachable)$this).getBanner().method_7960()) {
            if ($this instanceof class_1498) {
                class_1498 horse = (class_1498)$this;
                if (!((BannerAttachable)horse).getBanner().method_7960() && !horse.method_6786().method_31574(GItems.STERLING_HORSE_ARMOR)) {
                    class_1799 copy = ((BannerAttachable)horse).getBanner();
                    horse.method_5775(copy);
                    ((BannerAttachable)horse).setBanner(class_1799.field_8037);
                }
            } else if (!$this.method_6118(class_1304.field_6169).method_31574(GItems.STERLING_HELMET)) {
                class_1799 copy = bannerEntity.getBanner();
                $this.method_5775(copy);
                bannerEntity.setBanner(class_1799.field_8037);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"decreaseAirSupply"}, cancellable=true)
    private void G$decreaseAirSupply(int i, CallbackInfoReturnable<Integer> cir) {
        if (this.getGoldenAirSupply() > 0.0f) {
            cir.setReturnValue((Object)i);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isAlive()Z", shift=At.Shift.AFTER, ordinal=0)}, method={"baseTick"})
    private void G$baseTick(CallbackInfo ci) {
        class_1309 $this = (class_1309)this;
        if (this.getGoldenAirSupply() > 0.0f) {
            this.setGoldenAirSupply(this.decreaseGoldenAirSupply($this, (int)this.getGoldenAirSupply()));
        }
    }

    protected int decreaseGoldenAirSupply(class_1309 livingEntity, int i) {
        int reductionValue;
        int j = class_1890.method_8211((class_1309)livingEntity);
        int n = reductionValue = livingEntity.method_5777(class_3486.field_15517) ? 1 : 4;
        if (j > 0 && livingEntity.method_6051().method_43048(j + 1) > 0) {
            return i;
        }
        return Math.max(i - reductionValue, 0);
    }

    @Inject(at={@At(value="HEAD")}, method={"die"})
    private void G$die(class_1282 damageSource, CallbackInfo ci) {
        BannerAttachable bannerAttachable;
        class_1498 horse;
        class_1309 $this = (class_1309)this;
        if ($this instanceof class_1498 && (horse = (class_1498)$this) instanceof BannerAttachable && !(bannerAttachable = (BannerAttachable)horse).getBanner().method_7960() && horse.method_6786().method_31574(GItems.STERLING_HORSE_ARMOR)) {
            class_1799 copy = bannerAttachable.getBanner();
            horse.method_5775(copy);
            bannerAttachable.setBanner(class_1799.field_8037);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isInWall"}, cancellable=true)
    private void G$isInWall(CallbackInfoReturnable<Boolean> cir) {
        class_1309 $this = (class_1309)this;
        if ($this != null && $this.method_6059(GMobEffects.ASTRAL)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(FFF)F", shift=At.Shift.AFTER)}, method={"getDamageAfterArmorAbsorb"}, cancellable=true)
    private void G$getDamageAfterArmorAbsorb(class_1282 damageSource, float f, CallbackInfoReturnable<Float> cir) {
        class_1308 mob;
        boolean flag;
        class_1309 $this = (class_1309)this;
        class_1304[] class_1304Array = damageSource.method_5529();
        boolean bl = flag = class_1304Array instanceof class_1308 && ((mob = (class_1308)class_1304Array).method_6046() == class_1310.field_6291 || mob.method_5864().method_20210(GEntityTypeTags.STERLING_IMMUNE_ENTITY_TYPES));
        if (flag) {
            class_1498 horse;
            if ($this instanceof class_1498 && (horse = (class_1498)$this).method_6786().method_31574(GItems.STERLING_HORSE_ARMOR)) {
                cir.setReturnValue((Object)Float.valueOf(f - 4.0f));
            }
            float illagerReduction = 0.0f;
            for (class_1304 equipmentSlot : class_1304.values()) {
                class_1792 class_17922 = $this.method_6118(equipmentSlot).method_7909();
                if (!(class_17922 instanceof SterlingArmorItem)) continue;
                SterlingArmorItem sterlingArmorItem = (SterlingArmorItem)class_17922;
                if (equipmentSlot.method_5925() != class_1304.class_1305.field_6178) continue;
                illagerReduction += sterlingArmorItem.getInsurgentResistance(equipmentSlot);
            }
            if (illagerReduction > 0.0f) {
                float value = 4.0f * (f / illagerReduction);
                cir.setReturnValue((Object)Float.valueOf(value));
            }
        }
    }

    @Override
    public void setBanner(class_1799 stack) {
        ((class_1309)this).method_5841().method_12778(BANNER_STACK, (Object)stack);
    }

    @Override
    public class_1799 getBanner() {
        return (class_1799)((class_1309)this).method_5841().method_12789(BANNER_STACK);
    }

    @Override
    public void setGoldenAirSupply(float goldenAirSupply) {
        ((class_1309)this).method_5841().method_12778(GOLDEN_AIR_SUPPLY, (Object)Float.valueOf(goldenAirSupply));
    }

    @Override
    public float getGoldenAirSupply() {
        return ((Float)((class_1309)this).method_5841().method_12789(GOLDEN_AIR_SUPPLY)).floatValue();
    }

    @Override
    public boolean isUsingSpectreBoundedSpyglass() {
        return (Boolean)((class_1309)this).method_5841().method_12789(USING_SPECTRE_BOUNDED_SPYGLASS);
    }

    @Override
    public void setUsingSpectreBoundedSpyglass(boolean usingSpectreBoundedSpyglass) {
        ((class_1309)this).method_5841().method_12778(USING_SPECTRE_BOUNDED_SPYGLASS, (Object)usingSpectreBoundedSpyglass);
    }
}

