/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Undermine
extends class_4097<Berserker> {
    private static final int DURATION = class_3532.method_15386((float)22.4f);
    private static final int MAX_DURATION = 50;

    public Undermine() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.RAMPAGE_TICKS, (Object)class_4141.field_18457, (Object)class_4140.field_22355, (Object)class_4141.field_18456, GMemoryModuleTypes.IMPALING_COOLDOWN, (Object)class_4141.field_18457, GMemoryModuleTypes.IS_SMASHING, (Object)class_4141.field_18457, GMemoryModuleTypes.IS_IMPALING, (Object)class_4141.field_18458, GMemoryModuleTypes.IS_SUMMONING, (Object)class_4141.field_18457), 50);
    }

    protected boolean checkExtraStartConditions(class_3218 serverLevel, Berserker mob) {
        List list = serverLevel.method_18467(class_1309.class, mob.method_5829());
        for (class_1309 nearby : list) {
            if (!nearby.method_5805() || nearby.method_5864() == GEntityTypes.BERSERKER) continue;
            return false;
        }
        return mob.method_41328(class_4050.field_18076) && mob.shouldAttack() && mob.method_43259((class_1297)mob.method_18868().method_18904(class_4140.field_22355).get(), 15.0, 20.0);
    }

    protected boolean canStillUse(class_3218 serverLevel, Berserker mob, long l) {
        return true;
    }

    protected void start(class_3218 serverLevel, Berserker mob, long l) {
        class_4095<Berserker> brain = mob.method_18868();
        brain.method_24525(class_4140.field_22475, (Object)true, (long)DURATION);
        brain.method_24525(GMemoryModuleTypes.IS_IMPALING, (Object)class_3902.field_17274, 50L);
        brain.method_18878(GMemoryModuleTypes.IMPALING_COUNT, (Object)(brain.method_18904(GMemoryModuleTypes.IMPALING_COUNT).orElse(0) + 1));
        brain.method_18875(class_4140.field_18445);
        mob.setPhase(Berserker.Phase.UNDERMINE);
        mob.method_5783(GSoundEvents.BERSERKER_SMASH, 3.0f, 1.0f);
    }

    protected void tick(class_3218 serverLevel, Berserker mob, long l) {
        Optional memory = mob.method_18868().method_18904(class_4140.field_22355);
        memory.ifPresent(target -> mob.method_5988().method_19615(target.method_19538()));
        mob.method_18868().method_18875(class_4140.field_18445);
        if (mob.method_18868().method_18896(class_4140.field_22475)) {
            return;
        }
        if (memory.isPresent() && mob.canTargetEntity((class_1297)memory.get())) {
            class_1309 target2 = (class_1309)memory.get();
            double d = Math.min(target2.method_23318(), mob.method_23318());
            double e = Math.max(target2.method_23318(), mob.method_23318()) + 1.0;
            float f = (float)class_3532.method_15349((double)(target2.method_23321() - mob.method_23321()), (double)(target2.method_23317() - mob.method_23317()));
            if (mob.method_5739((class_1297)target2) < 4.0f) {
                float g;
                int index;
                mob.method_5702(class_2183.class_2184.field_9851, new class_243(-1.0, -1.0, -1.0));
                for (index = 0; index < 5; ++index) {
                    g = f + (float)index * (float)Math.PI * 0.4f;
                    this.createPillar(mob, 0, 4.0f, 0.0f, mob.method_23317() + (double)class_3532.method_15362((float)g) * 1.5, mob.method_23321() + (double)class_3532.method_15374((float)g) * 1.5, d, e, g);
                }
                for (index = 0; index < 8; ++index) {
                    g = f + (float)index * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.createPillar(mob, 3, 4.0f, 0.0f, mob.method_23317() + (double)class_3532.method_15362((float)g) * 2.5, mob.method_23321() + (double)class_3532.method_15374((float)g) * 2.5, d, e, g);
                }
            } else {
                mob.method_5702(class_2183.class_2184.field_9851, target2.method_19538());
                for (int index = 0; index < 16; ++index) {
                    double h = 1.25 * (double)(index + 1);
                    this.createPillar(mob, index, 6.0f, 0.2f, mob.method_23317() + (double)class_3532.method_15362((float)f) * h + (double)((mob.method_6051().method_43057() - 0.5f) * 0.4f), mob.method_23321() + (double)class_3532.method_15374((float)f) * h + (double)((mob.method_6051().method_43057() - 0.5f) * 0.4f), d, e, f);
                }
            }
        }
        mob.method_18868().method_24525(class_4140.field_22475, (Object)true, (long)(50 - DURATION));
    }

    private void createPillar(Berserker mob, int index, float damage, float damageLowerRate, double d, double e, double f, double g, float h) {
        class_2338 blockPos = class_2338.method_49637((double)d, (double)g, (double)e);
        boolean bl = false;
        double j = 0.0;
        do {
            class_265 voxelShape;
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState = mob.method_37908().method_8320(blockPos2);
            if (!blockState.method_26206((class_1922)mob.method_37908(), blockPos2, class_2350.field_11036)) continue;
            if (!mob.method_37908().method_22347(blockPos) && !(voxelShape = mob.method_37908().method_8320(blockPos).method_26220((class_1922)mob.method_37908(), blockPos)).method_1110()) {
                j = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)f) - 1);
        if (bl) {
            if (damageLowerRate > 0.0f) {
                damage -= (float)index * damageLowerRate;
            }
            mob.method_37908().method_8649((class_1297)new PinkSaltPillar(mob.method_37908(), d, (double)blockPos.method_10264() + j, e, h, index, damage, (class_1309)mob));
        }
    }

    protected void stop(class_3218 serverLevel, Berserker mob, long l) {
        mob.setPhase(Berserker.Phase.IDLING);
        Optional memory = mob.method_18868().method_18904(class_4140.field_22355);
        Optional undermine = mob.method_18868().method_18904(GMemoryModuleTypes.IMPALING_COUNT);
        if (undermine.isPresent() && (Integer)undermine.get() >= 3) {
            mob.method_18868().method_24525(GMemoryModuleTypes.IMPALING_COOLDOWN, (Object)class_3902.field_17274, 50L);
            mob.method_18868().method_18878(GMemoryModuleTypes.IMPALING_COUNT, (Object)0);
        } else if (memory.isPresent() && (double)((class_1309)memory.get()).method_5739((class_1297)mob) < 4.0) {
            mob.method_18868().method_24525(GMemoryModuleTypes.IMPALING_COOLDOWN, (Object)class_3902.field_17274, 400L);
        }
    }
}

