/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_6019;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Summon
extends class_4097<Berserker> {
    private static final int MAX_DURATION = 70;

    public Summon() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.RAMPAGE_TICKS, (Object)class_4141.field_18457, (Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_18442, (Object)class_4141.field_18456, GMemoryModuleTypes.IS_SMASHING, (Object)class_4141.field_18457, GMemoryModuleTypes.IS_IMPALING, (Object)class_4141.field_18457, GMemoryModuleTypes.IS_SUMMONING, (Object)class_4141.field_18458, GMemoryModuleTypes.SUMMONING_COOLDOWN, (Object)class_4141.field_18457, GMemoryModuleTypes.SUMMON_COUNT, (Object)class_4141.field_18458), 70);
    }

    protected boolean checkExtraStartConditions(class_3218 serverLevel, Berserker livingEntity) {
        return livingEntity.method_6032() / livingEntity.method_6063() <= 0.66f && livingEntity.method_41328(class_4050.field_18076) && livingEntity.shouldAttack();
    }

    protected boolean canStillUse(class_3218 serverLevel, Berserker livingEntity, long l) {
        return true;
    }

    protected void start(class_3218 serverLevel, Berserker livingEntity, long l) {
        class_4095<Berserker> brain = livingEntity.method_18868();
        brain.method_24525(GMemoryModuleTypes.IS_SUMMONING, (Object)class_3902.field_17274, 70L);
        brain.method_18875(class_4140.field_18445);
        livingEntity.setPhase(Berserker.Phase.SUMMONING);
        livingEntity.method_5783(GSoundEvents.BERSERKER_SUMMONING, 10.0f, 1.0f);
    }

    protected void tick(class_3218 serverLevel, Berserker livingEntity, long l) {
        class_4095<Berserker> brain = livingEntity.method_18868();
        brain.method_18878(GMemoryModuleTypes.SUMMON_COUNT, (Object)(brain.method_18904(GMemoryModuleTypes.SUMMON_COUNT).orElse(0) + 1));
        List<class_1309> list = serverLevel.method_18467(class_1309.class, livingEntity.method_5829().method_1014(4.0)).stream().filter(livingEntity::canTargetEntity).filter(e -> e.method_5667() != livingEntity.method_5667()).toList();
        float time = livingEntity.method_18868().method_36978(GMemoryModuleTypes.IS_SUMMONING);
        if (time > 20.0f) {
            for (class_1309 entity : list) {
                if (time % 4.0f != 0.0f) continue;
                entity.method_5643(serverLevel.method_48963().method_48812((class_1309)livingEntity), 2.0f);
            }
        }
        int max = class_6019.method_35017((int)3, (int)5).method_35008(serverLevel.method_8409());
        if (serverLevel.method_8407() == class_1267.field_5807) {
            max = class_6019.method_35017((int)4, (int)8).method_35008(serverLevel.method_8409());
        }
        if (brain.method_18896(GMemoryModuleTypes.SUMMON_COUNT) && (Integer)brain.method_18904(GMemoryModuleTypes.SUMMON_COUNT).get() > max) {
            return;
        }
        brain.method_18875(class_4140.field_18445);
        ArrayList positions = Lists.newArrayList();
        int range = 5;
        int yRange = 2;
        for (int y = -yRange; y <= yRange; ++y) {
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 position = livingEntity.method_24515().method_10069(x, y, z);
                    if (!serverLevel.method_8320(position.method_10074()).method_26206((class_1922)serverLevel, position.method_10074(), class_2350.field_11036) || !serverLevel.method_8320(position).method_26215()) continue;
                    positions.add(position);
                }
            }
        }
        class_2338 randomPos = (class_2338)positions.get(serverLevel.method_8409().method_43048(positions.size()));
        Preserved preserved = (Preserved)GEntityTypes.PRESERVED.method_5888(serverLevel, null, null, livingEntity.method_24515(), class_3730.field_16461, true, true);
        preserved.method_5808(randomPos.method_10263(), randomPos.method_10264(), randomPos.method_10260(), 0.0f, 0.0f);
        preserved.method_6033(preserved.method_6063() * ((float)livingEntity.method_6051().method_43051(4, 7) / 10.0f));
        serverLevel.method_30771((class_1297)preserved);
    }

    protected void stop(class_3218 serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
        livingEntity.method_18868().method_24525(GMemoryModuleTypes.SUMMONING_COOLDOWN, (Object)class_3902.field_17274, 600L);
        livingEntity.method_18868().method_18878(GMemoryModuleTypes.SUMMON_COUNT, (Object)0);
    }
}

