/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4816;
import net.minecraft.class_4818;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5753;
import net.minecraft.class_6019;
import net.minecraft.class_7894;
import net.minecraft.class_7895;
import net.minecraft.class_7898;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.ai.tasks.ConditionalWalkIfTargetOutOfReach;
import net.orcinus.galosphere.entities.ai.tasks.Shake;
import net.orcinus.galosphere.entities.ai.tasks.Smash;
import net.orcinus.galosphere.entities.ai.tasks.Summon;
import net.orcinus.galosphere.entities.ai.tasks.Undermine;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class BerserkerAi {
    public static class_4095<?> makeBrain(Berserker berserker, class_4095<Berserker> brain) {
        BerserkerAi.initCoreActivity(brain);
        BerserkerAi.initIdleActivity(brain);
        BerserkerAi.initShakeActivity(brain);
        BerserkerAi.initFightActivity(berserker, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void initCoreActivity(class_4095<Berserker> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(GMemoryModuleTypes.RAMPAGE_TICKS)));
    }

    private static void initIdleActivity(class_4095<Berserker> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4824.method_47119(BerserkerAi::findNearestValidAttackTarget), (Object)class_7895.method_47067((float)8.0f, (class_6019)class_6019.method_35017((int)30, (int)60)), BerserkerAi.createIdleMovementBehaviors()));
    }

    private static void initShakeActivity(class_4095<Berserker> brain) {
        brain.method_24527(class_4168.field_38202, 5, ImmutableList.of((Object)((Object)new Shake())), GMemoryModuleTypes.IS_SHAKING);
    }

    private static void initFightActivity(Berserker berserker, class_4095<Berserker> brain) {
        Predicate<class_1309> predicate = livingEntity -> {
            Berserker blighted;
            return livingEntity instanceof Berserker && (!(blighted = (Berserker)((Object)livingEntity)).method_41328(class_4050.field_38097) || blighted.getPhase() != Berserker.Phase.UNDERMINE);
        };
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_7898.method_47227(Berserker::shouldUseMeleeAttack, (class_7894)class_4816.method_46987((int)600)), (Object)((Object)new Smash()), (Object)class_7898.method_47227(predicate, ConditionalWalkIfTargetOutOfReach.create(1.2f)), (Object)((Object)new Undermine()), (Object)((Object)new Summon()), (Object)class_4828.method_47139(livingEntity -> !berserker.canTargetEntity((class_1297)livingEntity), (mob, livingEntity) -> {}, (boolean)false)), class_4140.field_22355);
    }

    private static class_4118<Berserker> createIdleMovementBehaviors() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.3f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.2f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    private static Optional<? extends class_1309> findNearestValidAttackTarget(Berserker blighted) {
        return blighted.method_18868().method_18904(class_4140.field_30243);
    }

    public static void updateActivity(Berserker blighted) {
        blighted.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_38202, (Object)class_4168.field_22396, (Object)class_4168.field_18595));
    }
}

