/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import net.orcinus.galosphere.api.BottlePickable;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.entities.ai.SpectreAi;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GNetwork;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class Spectre
extends class_1429
implements class_1432,
BottlePickable,
Spectatable {
    private static final class_2940<Optional<UUID>> MANIPULATOR = class_2945.method_12791(Spectre.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> CAN_BE_MANIPULATED = class_2945.method_12791(Spectre.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FROM_BOTTLE = class_2945.method_12791(Spectre.class, (class_2941)class_2943.field_13323);
    protected static final ImmutableList<class_4149<? extends class_4148<? super Spectre>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, (Object)class_4149.field_37447, GSensorTypes.SPECTRE_TEMPTATIONS);
    protected static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_18445, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18452, (Object)class_4140.field_30243, (Object)class_4140.field_18448, (Object)class_4140.field_37443, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object[])new class_4140[]{class_4140.field_28327, class_4140.field_39408, GMemoryModuleTypes.NEAREST_LICHEN_MOSS});

    public Spectre(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        return 0.0f;
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31573(GItemTags.SPECTRE_TEMPT_ITEMS);
    }

    public void method_24650(class_3218 serverLevel, class_1429 animal) {
        class_3222 serverPlayer = this.method_6478();
        if (serverPlayer == null) {
            serverPlayer = animal.method_6478();
        }
        if (serverPlayer != null) {
            serverPlayer.method_7281(class_3468.field_15410);
            class_174.field_1190.method_855(serverPlayer, (class_1429)this, animal, null);
        }
        this.method_5614(6000);
        animal.method_5614(6000);
        this.method_6477();
        animal.method_6477();
        this.method_18868().method_18878(class_4140.field_37443, (Object)class_3902.field_17274);
        serverLevel.method_8421((class_1297)this, (byte)18);
        if (serverLevel.method_8450().method_8355(class_1928.field_19391)) {
            serverLevel.method_8649((class_1297)new class_1303((class_1937)serverLevel, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().method_43048(7) + 1));
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)GEntityTypes.SPECTRE.method_5883((class_1937)serverLevel);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MANIPULATOR, Optional.empty());
        this.field_6011.method_12784(CAN_BE_MANIPULATED, (Object)false);
        this.field_6011.method_12784(FROM_BOTTLE, (Object)false);
    }

    public static boolean checkSpectreSpawnRules(class_1299<? extends class_1309> type, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(GBlockTags.SPECTRES_SPAWNABLE_ON);
    }

    public int method_5978() {
        return 1;
    }

    public int method_5986() {
        return 1;
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return super.method_18394(pose, entityDimensions) - 0.1f;
    }

    public void method_5749(class_2487 tag) {
        UUID uuid;
        super.method_5749(tag);
        if (tag.method_25928("Manipulator")) {
            uuid = tag.method_25926("Manipulator");
        } else {
            String s = tag.method_10558("Manipulator");
            uuid = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)s);
        }
        if (uuid != null) {
            this.setManipulatorUUID(uuid);
        }
        this.setFromBottle(tag.method_10577("FromBottle"));
        this.setCanBeManipulated(tag.method_10577("CanBeManipulated"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.getManipulatorUUID() != null) {
            tag.method_25927("Manipulator", this.getManipulatorUUID());
        }
        tag.method_10556("FromBottle", this.fromBottle());
        tag.method_10556("CanBeManipulated", this.canBeManipulated());
    }

    @Nullable
    protected class_3414 method_5994() {
        return GSoundEvents.SPECTRE_AMBIENT;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return GSoundEvents.SPECTRE_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return GSoundEvents.SPECTRE_DEATH;
    }

    @Override
    @Nullable
    public UUID getManipulatorUUID() {
        return ((Optional)this.field_6011.method_12789(MANIPULATOR)).orElse(null);
    }

    @Override
    public void setManipulatorUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(MANIPULATOR, Optional.ofNullable(uuid));
    }

    @Override
    public void spectateTick(UUID uuid) {
        class_1657 player = this.method_37908().method_18470(uuid);
        if (player != null) {
            player.field_6212 = 0.0f;
            player.field_6250 = 0.0f;
            player.method_6100(false);
            if (!player.method_31550() || this.method_29504()) {
                this.setManipulatorUUID(null);
                if (this.method_37908().field_9236) {
                    this.stopUsingSpyglass(player);
                } else {
                    ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(false);
                    player.method_17356(GSoundEvents.SPECTRE_MANIPULATE_END, this.method_5634(), 1.0f, 1.0f);
                }
            }
        }
        if (!this.method_37908().method_8608() && player == null) {
            this.field_6011.method_12778(MANIPULATOR, Optional.empty());
        }
    }

    public boolean canBeManipulated() {
        return (Boolean)this.field_6011.method_12789(CAN_BE_MANIPULATED);
    }

    public void setCanBeManipulated(boolean canBeManipulated) {
        this.field_6011.method_12778(CAN_BE_MANIPULATED, (Object)canBeManipulated);
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1407 flyingPathNavigation = new class_1407((class_1308)this, level);
        flyingPathNavigation.method_6332(false);
        flyingPathNavigation.method_6354(true);
        flyingPathNavigation.method_6331(true);
        return flyingPathNavigation;
    }

    public void method_5773() {
        super.method_5773();
        if (this.canBeManipulated() && this.field_5974.method_43057() < 0.05f) {
            for (int i = 0; i < this.field_5974.method_43048(2) + 1; ++i) {
                this.spawnFluidParticle(this.method_37908(), this.method_23317() - (double)0.3f, this.method_23317() + (double)0.3f, this.method_23321() - (double)0.3f, this.method_23321() + (double)0.3f, this.method_23323(0.5), (class_2394)GParticleTypes.ALLURITE_RAIN);
            }
        }
    }

    private void spawnFluidParticle(class_1937 world, double minX, double maxX, double minZ, double maxZ, double y, class_2394 options) {
        world.method_8406(options, class_3532.method_16436((double)world.field_9229.method_43058(), (double)minX, (double)maxX), y, class_3532.method_16436((double)world.field_9229.method_43058(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    public boolean method_5747(float f, float g, class_1282 damageSource) {
        return false;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
    }

    protected void method_5623(double d, boolean bl, class_2680 blockState, class_2338 blockPos) {
    }

    protected boolean method_5776() {
        return this.method_6581();
    }

    protected class_4095.class_5303<Spectre> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return SpectreAi.makeBrain((class_4095<Spectre>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Spectre> method_18868() {
        return super.method_18868();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("spectreBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("spectreActivityUpdate");
        SpectreAi.updateActivity(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 48.0);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608() || this.matchesClientPlayerUUID()) {
            ((Optional)this.field_6011.method_12789(MANIPULATOR)).ifPresent(this::spectateTick);
        }
    }

    public boolean method_5974(double d) {
        return !this.method_16914() && !this.fromBottle();
    }

    public boolean method_17326() {
        return super.method_17326() || this.fromBottle();
    }

    @Environment(value=EnvType.CLIENT)
    public void stopUsingSpyglass(class_1657 player) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == player) {
            client.method_1504((class_1297)player);
        }
    }

    public void method_6091(class_243 velocity) {
        if (this.getManipulatorUUID() != null) {
            ((Optional)this.field_6011.method_12789(MANIPULATOR)).map(arg_0 -> ((class_1937)this.method_37908()).method_18470(arg_0)).ifPresent(uuid -> this.copyPlayerRotation((class_1309)this, (class_1657)uuid));
        } else {
            super.method_6091(velocity);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 stack = player.method_5998(interactionHand);
        if (this.canBeManipulated() && (stack.method_31574(GItems.SPECTRE_BOUND_SPYGLASS) || stack.method_31574(class_1802.field_27070))) {
            this.method_5783(GSoundEvents.SPECTRE_LOCK_TO_SPYGLASS, 1.0f, 1.0f);
            class_1799 spectreBoundedSpyglass = new class_1799((class_1935)GItems.SPECTRE_BOUND_SPYGLASS);
            if (this.method_16914()) {
                spectreBoundedSpyglass.method_7977(this.method_5797());
            }
            SpectreBoundSpyglass.addSpectreBoundedTags(this, spectreBoundedSpyglass.method_7948());
            player.method_6122(interactionHand, spectreBoundedSpyglass);
            this.setCanBeManipulated(false);
            return class_1269.field_5812;
        }
        if (stack.method_31574(class_1802.field_8469)) {
            this.method_37908().method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), GSoundEvents.SPECTRE_BOTTLE_FILL, class_3419.field_15254, 1.0f, 1.0f);
            if (!this.method_37908().method_8608()) {
                this.method_32876(class_5712.field_28725);
                class_1799 itemStack2 = new class_1799((class_1935)GItems.BOTTLE_OF_SPECTRE);
                class_2487 compoundTag = new class_2487();
                this.method_5662(compoundTag);
                itemStack2.method_7980(compoundTag);
                player.method_6122(interactionHand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)itemStack2));
                this.method_31472();
            }
            return class_1269.field_5812;
        }
        if (stack.method_31574(GItems.ALLURITE_SHARD) && this.getManipulatorUUID() == null && !this.canBeManipulated()) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.setCanBeManipulated(true);
            this.method_5783(GSoundEvents.SPECTRE_RECEIVE_ITEM, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return super.method_5992(player, interactionHand);
    }

    public void setCamera(class_1657 player) {
        if (!this.method_37908().method_8608()) {
            ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(true);
            this.setManipulatorUUID(player.method_5667());
            class_2540 buf = PacketByteBufs.create();
            buf.method_10797(player.method_5667());
            buf.writeInt(this.method_5628());
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)GNetwork.SEND_PERSPECTIVE, (class_2540)buf);
            player.method_17356(GSoundEvents.SPECTRE_MANIPULATE_BEGIN, this.method_5634(), 1.0f, 1.0f);
        }
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    @Override
    public boolean fromBottle() {
        return (Boolean)this.field_6011.method_12789(FROM_BOTTLE);
    }

    @Override
    public void setFromBottle(boolean fromBottle) {
        this.field_6011.method_12778(FROM_BOTTLE, (Object)fromBottle);
    }
}

