/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_6019;
import net.orcinus.galosphere.blocks.PinkSaltChamberBlock;
import net.orcinus.galosphere.blocks.PinkSaltClusterBlock;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class PinkSaltChamberBlockEntity
extends class_2586 {
    private final List<Preserved> preserves = Lists.newArrayList();
    public final int maxCooldown = 6000;
    private int cooldown = 0;

    public PinkSaltChamberBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(GBlockEntityTypes.PINK_SALT_CHAMBER, blockPos, blockState);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.cooldown = compoundTag.method_10550("Cooldown");
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569("Cooldown", this.cooldown);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, PinkSaltChamberBlockEntity blockEntity) {
        if (blockState.method_11654(PinkSaltChamberBlock.PHASE) == PinkSaltChamberBlock.ChamberPhase.INACTIVE) {
            return;
        }
        Optional<Preserved> preserved = blockEntity.preserves.stream().filter(class_1309::method_5805).findAny();
        if (!blockEntity.preserves.isEmpty() && preserved.isEmpty()) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657(PinkSaltChamberBlock.PHASE, (Comparable)((Object)PinkSaltChamberBlock.ChamberPhase.COOLDOWN)), 2);
            level.method_8396(null, blockPos, GSoundEvents.PINK_SALT_CHAMBER_DEACTIVATE, class_3419.field_15245, 1.0f, 1.0f);
            blockEntity.preserves.clear();
            blockEntity.resetCooldown();
        }
        if (blockEntity.cooldown >= blockEntity.maxCooldown) {
            if (blockState.method_11654(PinkSaltChamberBlock.PHASE) == PinkSaltChamberBlock.ChamberPhase.COOLDOWN) {
                boolean flag2 = false;
                for (class_2350 direction : class_2350.values()) {
                    boolean flag;
                    class_2680 relativeState = level.method_8320(blockPos.method_10093(direction));
                    boolean bl = flag = relativeState.method_27852(GBlocks.PINK_SALT_CLUSTER) && relativeState.method_11654((class_2769)PinkSaltClusterBlock.FACING) == direction;
                    if (!flag) continue;
                    flag2 = true;
                    break;
                }
                PinkSaltChamberBlock.ChamberPhase phase = flag2 ? PinkSaltChamberBlock.ChamberPhase.CHARGED : PinkSaltChamberBlock.ChamberPhase.INACTIVE;
                level.method_8652(blockPos, (class_2680)blockState.method_11657(PinkSaltChamberBlock.PHASE, (Comparable)((Object)phase)), 2);
            }
            ArrayList poses = Lists.newArrayList();
            int maxCount = class_6019.method_35017((int)3, (int)5).method_35008(level.method_8409());
            if (level.method_8407() == class_1267.field_5807) {
                maxCount = class_6019.method_35017((int)4, (int)10).method_35008(level.method_8409());
            }
            List<class_1657> list = level.method_18467(class_1657.class, new class_238(blockPos).method_1014(6.0)).stream().filter(class_1309::method_5805).filter(player -> !player.method_31549().field_7477).toList();
            list.stream().filter(class_3222.class::isInstance).map(class_3222.class::cast).forEach(GCriteriaTriggers.ACTIVATE_PINK_SALT_CHAMBER::trigger);
            list.stream().findAny().ifPresent(player -> {
                int range = 5;
                int yRange = 2;
                for (int y = -yRange; y <= yRange; ++y) {
                    for (int x = -range; x <= range; ++x) {
                        for (int z = -range; z <= range; ++z) {
                            class_2338 position = blockPos.method_10069(x, y, z);
                            if (!level.method_8320(position.method_10074()).method_26206((class_1922)level, position.method_10074(), class_2350.field_11036) || !level.method_8320(position).method_26215()) continue;
                            poses.add(position);
                        }
                    }
                }
            });
            if (!poses.isEmpty()) {
                for (int count = 0; count < maxCount; ++count) {
                    class_2338 randomPos = (class_2338)poses.get(level.method_8409().method_43048(poses.size()));
                    if (!(level instanceof class_3218)) continue;
                    class_3218 serverLevel = (class_3218)level;
                    blockEntity.addParticles(blockPos, serverLevel, randomPos);
                    blockEntity.handleSpawning(serverLevel, randomPos);
                }
                level.method_8396(null, blockPos, GSoundEvents.PINK_SALT_CHAMBER_SUMMON, class_3419.field_15245, 1.0f, 1.0f);
                blockEntity.resetCooldown();
            }
        } else {
            ++blockEntity.cooldown;
        }
    }

    private void resetCooldown() {
        this.cooldown = 0;
    }

    private void handleSpawning(class_3218 serverLevel, class_2338 pos) {
        if (serverLevel.method_8407() == class_1267.field_5801) {
            serverLevel.method_8652(pos, GBlocks.PINK_SALT_CLUSTER.method_9564(), 2);
        } else {
            Preserved preserved = (Preserved)GEntityTypes.PRESERVED.method_5888(serverLevel, null, null, pos, class_3730.field_16461, true, true);
            preserved.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
            preserved.method_5971();
            preserved.setFromChamber(true);
            serverLevel.method_30771((class_1297)preserved);
            this.preserves.add(preserved);
        }
    }

    private void addParticles(class_2338 blockPos, class_3218 serverLevel, class_2338 pos) {
        class_243 vec3 = blockPos.method_46558().method_1031(0.0, 0.5, 0.0);
        class_243 vec32 = pos.method_46558().method_1031(0.0, 1.0, 0.0).method_1020(vec3);
        class_243 vec33 = vec32.method_1029();
        for (int i = 1; i < class_3532.method_15357((double)vec32.method_1033()) + 7; ++i) {
            class_243 vec34 = blockPos.method_46558().method_1019(vec33.method_1021((double)i));
            serverLevel.method_14199((class_2394)class_2398.field_11205, vec34.field_1352, vec34.field_1351, vec34.field_1350, 30, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

