/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.staff;

import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;

public class HexBoltImpactParticleEffect
extends ParticleEffectType {
    public HexBoltImpactParticleEffect(String id) {
        super(id);
    }

    public static NBTEffectData createData(class_243 direction) {
        class_2487 tag = new class_2487();
        class_2487 directionTag = new class_2487();
        directionTag.method_10549("x", direction.field_1352);
        directionTag.method_10549("y", direction.field_1351);
        directionTag.method_10549("z", direction.field_1350);
        tag.method_10566("direction", (class_2520)directionTag);
        return new NBTEffectData(tag);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.method_10545("direction")) {
                return;
            }
            class_2487 directionData = nbtData.compoundTag.method_10562("direction");
            double dirX = directionData.method_10574("x");
            double dirY = directionData.method_10574("y");
            double dirZ = directionData.method_10574("z");
            class_243 projectileDirection = new class_243(dirX, dirY, dirZ);
            float yRot = (float)(class_3532.method_15349((double)projectileDirection.field_1352, (double)projectileDirection.field_1350) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            class_243 left = new class_243(-Math.cos(yaw), 0.0, Math.sin(yaw));
            class_243 up = left.method_1036(projectileDirection);
            double posX = positionData.posX;
            double posY = positionData.posY;
            double posZ = positionData.posZ;
            class_243 pos = new class_243(posX, posY, posZ);
            MalumSpiritType spiritType = colorData.getSpiritType();
            for (int i = 0; i < 32; ++i) {
                float spread = RandomHelper.randomBetween((class_5819)random, (float)0.1f, (float)0.5f);
                float speed = RandomHelper.randomBetween((class_5819)random, (float)0.3f, (float)0.4f);
                float distance = RandomHelper.randomBetween((class_5819)random, (float)3.0f, (float)6.0f);
                float angle = (float)i / 32.0f * (float)Math.PI * 2.0f;
                class_243 direction = projectileDirection.method_1019(left.method_1021(Math.sin(angle) * (double)spread)).method_1019(up.method_1021(Math.cos(angle) * (double)spread)).method_1029().method_1021((double)speed);
                class_243 spawnPosition = pos.method_1019(direction.method_1021((double)distance));
                direction = direction.method_22882();
                float lifetimeMultiplier = 0.7f;
                if (random.method_43057() < 0.8f) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, spiritType);
                    lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).setMotion(direction);
                    lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(direction);
                    lightSpecs.spawnParticles();
                }
                if (!(random.method_43057() < 0.8f)) continue;
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, spiritType);
                sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().setMotion(direction.method_1021(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).modifyOptionalData(b -> b.getBehaviorData(SparkBehaviorComponent.class, SparkBehaviorComponent::getLengthData), d -> d.multiplyValue(3.0f));
                sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(direction.method_1021(1.5));
                sparks.spawnParticles();
            }
        };
    }
}

