/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.nitrate;

import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class EthericNitrateImpactParticleEffect
extends ParticleEffectType {
    public EthericNitrateImpactParticleEffect(String id) {
        super(id);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            int i;
            double posX = positionData.posX;
            double posY = positionData.posY;
            double posZ = positionData.posZ;
            class_243 pos = new class_243(posX, posY, posZ);
            Color primaryColor = colorData.getDefaultColorRecord().primaryColor();
            Color secondaryColor = colorData.getDefaultColorRecord().secondaryColor();
            ColorParticleData colorParticleData = ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).setEasing(Easing.SINE_IN_OUT).setCoefficient(0.9f).build();
            for (i = 0; i < 16; ++i) {
                boolean star;
                float lifetimeMultiplier = RandomHelper.randomBetween((class_5819)random, (float)2.0f, (float)2.5f);
                float gravityStrength = RandomHelper.randomBetween((class_5819)random, (float)0.01f, (float)0.05f);
                double horizontalAngle = random.method_43058() * Math.PI * 2.0;
                double x = Math.cos(horizontalAngle);
                double y = class_3532.method_15344((class_5819)random, (float)-1.0f, (float)1.0f);
                double z = Math.sin(horizontalAngle);
                class_243 direction = new class_243(x, y, z);
                class_243 motion = direction.method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)1.0f, (float)2.0f));
                class_243 spawnPosition = pos.method_1019(direction.method_1021(0.25));
                Consumer<LodestoneWorldParticle> slowDown = p -> {
                    class_243 velocity = p.getParticleSpeed().method_1021((double)0.8f);
                    if (velocity.equals((Object)class_243.field_1353)) {
                        velocity = p.getParticleSpeed();
                    }
                    p.method_34753(velocity.field_1352, (velocity.field_1351 - (double)gravityStrength) * (double)0.98f, velocity.field_1350);
                };
                boolean bl = star = random.method_43057() < 0.2f;
                if (random.method_43057() < 0.8f) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, colorParticleData, new WorldParticleOptions(star ? (class_2396)ParticleRegistry.STAR.get() : (class_2396)ParticleRegistry.LIGHT_SPEC_SMALL.get()));
                    lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).setMotion(motion);
                    lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(star ? 3.0f : 2.0f)).setMotion(motion);
                    lightSpecs.spawnParticles();
                }
                if (star || !(random.method_43057() < 0.8f)) continue;
                float scalar = RandomHelper.randomBetween((class_5819)random, (float)0.8f, (float)1.1f);
                GenericParticleData lengthData = GenericParticleData.create((float)(2.0f * scalar), (float)(0.5f * scalar), (float)0.0f).setEasing(Easing.QUARTIC_OUT, Easing.SINE_IN_OUT).build();
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, colorParticleData).act(b -> b.getParticleOptions().setBehavior((LodestoneBehaviorComponent)new SparkBehaviorComponent(lengthData)));
                sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().addTickActor(slowDown).setMotion(motion).setScaleData(GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN, Easing.QUAD_IN).build());
                sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).setMotion(motion);
                sparks.spawnParticles();
            }
            for (i = 0; i < 3; ++i) {
                SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)random, (float)class_3532.method_15344((class_5819)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build();
                float scaleMultiplier = (float)(1.0 + Math.pow(random.method_43057(), 2.0) * 0.5);
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.35f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setLifetime(15).setSpinData(spinData).setScaleData(GenericParticleData.create((float)(1.6f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setColorData(colorParticleData).setRandomOffset((double)0.6f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeat(level, posX, posY, posZ, 5);
            }
        };
    }
}

