/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.generic;

import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;

public class DrippingSmokeParticleEffect
extends ParticleEffectType {
    public final float intensity;

    public DrippingSmokeParticleEffect(String id, float intensity) {
        super(id);
        this.intensity = intensity;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            int spinOffset;
            int spinDirection;
            int i;
            ColorEffectData.ColorRecord colorRecord = colorData.getDefaultColorRecord();
            Color primaryColor = colorData.getPrimaryColor(colorRecord);
            Color secondaryColor = colorData.getSecondaryColor(colorRecord);
            double posX = positionData.posX + 0.5;
            double posY = positionData.posY + (double)0.65f;
            double posZ = positionData.posZ + 0.5;
            int adjustedLifespan = (int)(60.0f * this.intensity * 0.6f);
            Function<Float, Consumer> actorFunction = f -> p -> p.setParticleSpeed(p.getParticleSpeed().method_1019(new class_243(posX, posY, posZ).method_1020(p.getParticleSpeed()).method_1029().method_18805((double)f.floatValue(), 0.0, (double)f.floatValue())));
            for (i = 0; i < 2; ++i) {
                spinDirection = random.method_43056() ? 1 : -1;
                spinOffset = random.method_43048(360);
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.06f, (float)0.0f).setCoefficient(1.2f).setEasing(Easing.SINE_IN_OUT, Easing.QUAD_IN).build()).setSpinData(SpinParticleData.create((float)(0.05f * (float)spinDirection), (float)(0.2f * (float)spinDirection), (float)0.0f).setSpinOffset((float)spinOffset).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)0.8f, (float)0.4f, (float)0.0f).setEasing(Easing.QUARTIC_IN_OUT, Easing.QUAD_IN).build()).setColorData(ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).setEasing(Easing.BOUNCE_IN_OUT).build()).setLifetime((int)((float)adjustedLifespan * class_3532.method_15344((class_5819)random, (float)1.15f, (float)1.4f))).enableNoClip().setRandomOffset((double)0.2f, (double)0.4f).setRandomMotion((double)0.02f).addMotion(0.0, (double)(-0.0075f - random.method_43057() * 0.01f), 0.0).addTickActor(actorFunction.apply(Float.valueOf(0.015f))).repeat(level, posX, posY, posZ, (int)(3.0f * this.intensity));
            }
            for (i = 0; i < 2; ++i) {
                spinDirection = random.method_43056() ? 1 : -1;
                spinOffset = random.method_43048(360);
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.02f, (float)0.14f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.EXPO_OUT).build()).setSpinData(SpinParticleData.create((float)(0.1f * (float)spinDirection), (float)(0.25f * (float)spinDirection), (float)0.0f).setSpinOffset((float)spinOffset).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData(GenericParticleData.create((float)0.6f, (float)0.3f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.EXPO_OUT).build()).setColorData(ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).setEasing(Easing.BOUNCE_IN_OUT).build()).setLifetime((int)((float)adjustedLifespan * class_3532.method_15344((class_5819)random, (float)0.9f, (float)1.2f))).enableNoClip().setRandomOffset((double)0.2f, (double)0.4f).setRandomMotion((double)0.01f, 0.0).addMotion(0.0, (double)(-0.03f - random.method_43057() * 0.015f), 0.0).addTickActor(actorFunction.apply(Float.valueOf(0.04f))).repeat(level, posX, posY, posZ, (int)(2.0f * this.intensity));
            }
        };
    }
}

