/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.data;

import com.sammy.malum.MalumMod;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class ColorEffectData {
    public final ArrayList<ColorRecord> colorRecordList = new ArrayList();
    public int recordCycleCounter;

    public static ColorEffectData fromRecipe(Collection<SpiritWithCount> malumSpiritTypes) {
        return ColorEffectData.fromSpirits(malumSpiritTypes.stream().map(s -> s.type).collect(Collectors.toList()), ColorRecord::new);
    }

    public static ColorEffectData fromSpirits(Collection<MalumSpiritType> malumSpiritTypes) {
        return ColorEffectData.fromSpirits(malumSpiritTypes, ColorRecord::new);
    }

    public static ColorEffectData fromSpirits(Collection<MalumSpiritType> malumSpiritTypes, Function<MalumSpiritType, ColorRecord> spiritColorMapper) {
        return new ColorEffectData(malumSpiritTypes.stream().map(spiritColorMapper).collect(Collectors.toList()));
    }

    public ColorEffectData(ColorRecord colorRecord) {
        this.colorRecordList.add(colorRecord);
    }

    public ColorEffectData(Collection<ColorRecord> colorRecords) {
        this.colorRecordList.addAll(colorRecords);
    }

    public ColorEffectData(Color primaryColor) {
        this(new ColorRecord(primaryColor));
    }

    public ColorEffectData(MalumSpiritType spiritType) {
        this(new ColorRecord(spiritType));
    }

    public ColorEffectData(Color primaryColor, Color secondaryColor) {
        this(new ColorRecord(primaryColor, secondaryColor));
    }

    public ColorEffectData(Color primaryColor, Color secondaryColor, @Nullable MalumSpiritType spiritType) {
        this(new ColorRecord(primaryColor, secondaryColor, spiritType));
    }

    public ColorEffectData(class_2540 buf) {
        boolean isEmpty = buf.readBoolean();
        if (!isEmpty) {
            int colorDataCount = buf.readInt();
            for (int i = 0; i < colorDataCount; ++i) {
                this.colorRecordList.add(new ColorRecord(new Color(buf.readInt()), new Color(buf.readInt()), buf.readBoolean() ? SpiritHarvestHandler.getSpiritType(buf.method_19772()) : null));
            }
        }
    }

    public void encode(class_2540 buf) {
        buf.writeBoolean(this.colorRecordList.isEmpty());
        if (!this.colorRecordList.isEmpty()) {
            buf.writeInt(this.colorRecordList.size());
            for (ColorRecord colorRecord : this.colorRecordList) {
                buf.writeInt(colorRecord.primaryColor.getRGB());
                buf.writeInt(colorRecord.secondaryColor.getRGB());
                boolean NotNullSpirit = colorRecord.spiritType != null;
                buf.writeBoolean(NotNullSpirit);
                if (!NotNullSpirit) continue;
                buf.method_10814(colorRecord.spiritType.identifier);
            }
        }
    }

    public ColorRecord getDefaultColorRecord() {
        if (this.colorRecordList.isEmpty()) {
            return null;
        }
        return this.colorRecordList.get(0);
    }

    public ColorRecord getRandomColorRecord() {
        if (this.colorRecordList.isEmpty()) {
            return null;
        }
        return this.colorRecordList.get(MalumMod.RANDOM.method_43048(this.colorRecordList.size()));
    }

    public ColorRecord getCyclingColorRecord() {
        if (this.colorRecordList.isEmpty()) {
            return null;
        }
        return this.colorRecordList.get(this.recordCycleCounter++ % this.colorRecordList.size());
    }

    public Color getPrimaryColor(ColorRecord colorRecord) {
        return colorRecord.primaryColor;
    }

    public Color getSecondaryColor(ColorRecord colorRecord) {
        return colorRecord.secondaryColor;
    }

    @Nullable
    public MalumSpiritType getSpiritType() {
        return this.getSpiritType(this.getDefaultColorRecord());
    }

    @Nullable
    public MalumSpiritType getSpiritType(ColorRecord colorRecord) {
        return colorRecord.spiritType;
    }

    public record ColorRecord(Color primaryColor, Color secondaryColor, @Nullable MalumSpiritType spiritType) {
        public ColorRecord(Color color) {
            this(color, color);
        }

        public ColorRecord(MalumSpiritType type) {
            this(type.getPrimaryColor(), type.getSecondaryColor(), type);
        }

        public ColorRecord(Color primaryColor, Color secondaryColor) {
            this(primaryColor, secondaryColor, null);
        }
    }
}

