/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked;

import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class SapCollectionParticleEffect
extends ParticleEffectType {
    public SapCollectionParticleEffect(String id) {
        super(id);
    }

    public static NBTEffectData createData(class_2350 clickedFace) {
        NBTEffectData effectData = new NBTEffectData(new class_2487());
        effectData.compoundTag.method_10582("direction", clickedFace.method_10151());
        return effectData;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.method_10545("direction")) {
                return;
            }
            class_2350 direction = class_2350.method_10168((String)nbtData.compoundTag.method_10558("direction"));
            ColorEffectData.ColorRecord colorRecord = colorData.getDefaultColorRecord();
            Color primaryColor = colorData.getPrimaryColor(colorRecord);
            Color secondaryColor = colorData.getSecondaryColor(colorRecord);
            class_2338 blockPos = positionData.getAsBlockPos();
            class_243 pos = blockPos.method_46558().method_43206(direction, 0.5);
            class_243 playerPosition = class_310.method_1551().field_1724.method_19538();
            class_2382 normal = direction.method_10163();
            float yRot = (float)(class_3532.method_15349((double)normal.method_10263(), (double)normal.method_10260()) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            class_243 left = new class_243(-Math.cos(yaw), 0.0, Math.sin(yaw));
            class_243 up = left.method_1036(new class_243((double)normal.method_10263(), (double)normal.method_10264(), (double)normal.method_10260()));
            Consumer<LodestoneWorldParticle> acceleration = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)1.2f));
            for (int i = 0; i < 12; ++i) {
                float leftOffset = (random.method_43057() - 0.5f) * 0.75f;
                float upOffset = (random.method_43057() - 0.5f) * 0.75f;
                class_243 particlePosition = pos.method_1019(left.method_1021((double)leftOffset)).method_1019(up.method_1021((double)upOffset));
                class_243 particleMotion = playerPosition.method_1020(particlePosition).method_1029();
                class_243 targetPosition = pos.method_1019(particleMotion.method_1021(0.75));
                class_243 actualMotion = targetPosition.method_1020(particlePosition).method_1029().method_1021((double)0.01f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, ColorParticleData.create((Color)primaryColor, (Color)secondaryColor).build());
                lightSpecs.getBuilder().act(b -> b.addTickActor(acceleration).setMotion(actualMotion).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)1.0f, (float)2.0f))));
                lightSpecs.getBloomBuilder().act(b -> b.addTickActor(acceleration).setMotion(actualMotion).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)0.6f, (float)1.5f))));
                lightSpecs.spawnParticles();
            }
        };
    }
}

