/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked;

import com.sammy.malum.common.packets.ParticleEffectPacket;
import com.sammy.malum.registry.common.PacketRegistry;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import java.util.function.Supplier;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public abstract class ParticleEffectType {
    public final String id;

    public ParticleEffectType(String id) {
        this.id = id;
        ParticleEffectTypeRegistry.EFFECT_TYPES.put(id, this);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract Supplier<ParticleEffectActor> get();

    public void createEntityEffect(class_1297 entity) {
        this.createEntityEffect(entity, null);
    }

    public void createEntityEffect(class_1297 entity, ColorEffectData colorData) {
        this.createEntityEffect(entity, colorData, null);
    }

    public void createEntityEffect(class_1297 entity, ColorEffectData colorData, NBTEffectData nbtData) {
        PacketRegistry.MALUM_CHANNEL.sendToClientsTrackingAndSelf((S2CPacket)new ParticleEffectPacket(this.id, new PositionEffectData(entity), colorData, nbtData), entity);
    }

    public void createPositionedEffect(class_3218 level, PositionEffectData positionData) {
        this.createPositionedEffect(level, positionData, null, null);
    }

    public void createPositionedEffect(class_3218 level, PositionEffectData positionData, NBTEffectData nbtData) {
        this.createPositionedEffect(level, positionData, null, nbtData);
    }

    public void createPositionedEffect(class_3218 level, PositionEffectData positionData, ColorEffectData colorData) {
        this.createPositionedEffect(level, positionData, colorData, null);
    }

    public void createPositionedEffect(class_3218 level, PositionEffectData positionData, ColorEffectData colorData, NBTEffectData nbtData) {
        PacketRegistry.MALUM_CHANNEL.sendToClientsTracking((S2CPacket)new ParticleEffectPacket(this.id, positionData, colorData, nbtData), level, level.method_8500(positionData.getAsBlockPos()).method_12004());
    }

    public static interface ParticleEffectActor {
        public void act(class_1937 var1, class_5819 var2, PositionEffectData var3, ColorEffectData var4, NBTEffectData var5);
    }
}

