/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.void_depot.VoidDepotBlockEntity;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class WeepingWellParticleEffects {
    private static final class_265 WELL_SHAPE = class_2248.method_9541((double)-16.0, (double)4.0, (double)-16.0, (double)32.0, (double)5.0, (double)32.0);
    private static final class_265 DEPOT_SHAPE = class_2248.method_9541((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final GenericParticleData SMOKE_TRANSPARENCY = GenericParticleData.create((float)0.5f, (float)1.0f, (float)0.2f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build();

    public static Color getWeepingWellSmokeColor(class_5819 rand) {
        float colorMultiplier = RandomHelper.randomBetween((class_5819)rand, (float)0.6f, (float)1.2f);
        return new Color((int)(12.0f * colorMultiplier), (int)(3.0f * colorMultiplier), (int)(12.0f * colorMultiplier));
    }

    public static void spitOutItemParticles(class_1937 level, PositionEffectData positionEffectData) {
        int i;
        double posX = positionEffectData.posX;
        double posY = positionEffectData.posY;
        double posZ = positionEffectData.posZ;
        class_243 pos = new class_243(posX, posY, posZ);
        class_5819 rand = level.field_9229;
        Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
        ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
        Consumer<LodestoneWorldParticle> spawnBehavior = p -> p.tick(2);
        for (int i2 = 0; i2 < 64; ++i2) {
            float xVelocity = RandomHelper.randomBetween((class_5819)rand, (float)0.0f, (float)0.15f) * (float)(rand.method_43056() ? 1 : -1);
            float yVelocity = RandomHelper.randomBetween((class_5819)rand, (float)0.5f, (float)1.0f);
            float zVelocity = RandomHelper.randomBetween((class_5819)rand, (float)0.0f, (float)0.15f) * (float)(rand.method_43056() ? 1 : -1);
            float gravityStrength = RandomHelper.randomBetween((class_5819)rand, (float)0.75f, (float)1.0f);
            if (rand.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = WeepingWellParticleEffects.weepingWellSparks(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
                sparkParticles.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
                sparkParticles.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(rand.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
            lightSpecs.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        int spinOffset = rand.method_43048(360);
        for (i = 0; i < 4; ++i) {
            int spinDirection = rand.method_43056() ? 1 : -1;
            float scaleMultiplier = (float)(1.0 + Math.pow(rand.method_43057(), 2.0));
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.7f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.125f + rand.method_43057() * 0.075f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)(2.4f * scaleMultiplier), (float)0.8f, (float)0.0f).setEasing(Easing.QUAD_IN, Easing.SINE_IN).build()).setColorData(colorData).setLifetime(25).setRandomOffset((double)0.6f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).repeat(level, posX, posY + 0.25, posZ, 5);
        }
        for (i = 0; i < 8; ++i) {
            int finalI = 4 + i / 2;
            ParticleEffectSpawner squares = WeepingWellParticleEffects.weepingWellSquare(level, pos, colorData);
            squares.getBuilder().multiplyLifetime(0.5f).addSpawnActor(p -> p.tick(finalI));
            squares.spawnParticles();
        }
    }

    public static void passiveWeepingWellParticles(VoidConduitBlockEntity voidConduit) {
        class_1937 level = voidConduit.method_10997();
        if (level.method_8510() % 6L == 0L) {
            class_2338 blockPos = voidConduit.method_11016();
            class_5819 rand = level.field_9229;
            int lifetime = RandomHelper.randomBetween((class_5819)rand, (int)80, (int)120);
            float yMotion = 0.004f;
            Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
            ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE, (LodestoneBehaviorComponent)LodestoneBehaviorComponent.DIRECTIONAL).setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)rand, (float)0.02f, (float)0.04f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)0.6f, (float)0.3f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setColorData(colorData).setLifetime(lifetime).addMotion(0.0, (double)yMotion, 0.0).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).surroundVoxelShape(level, blockPos, WELL_SHAPE, 12);
            if (rand.method_43057() < 0.75f) {
                int rotation = rand.method_43048(16);
                class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)new class_243((double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.75f), (double)((float)blockPos.method_10260() + 0.5f)), (float)1.1f, (float)rotation, (float)16.0f, (long)level.method_8510(), (float)640.0f);
                float acceleration = RandomHelper.randomBetween((class_5819)rand, (float)0.002f, (float)0.02f);
                long gameTime = level.method_8510();
                Consumer<LodestoneWorldParticle> behavior = p -> {
                    if (level.method_8510() < gameTime + 10L) {
                        p.setParticleSpeed(p.getParticleSpeed().method_1031(0.0, (double)acceleration, 0.0));
                    }
                };
                for (int i = 0; i < 2; ++i) {
                    ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, offsetPosition);
                    lightSpecs.getBuilder().addTickActor(behavior);
                    lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.getBloomBuilder().addTickActor(behavior);
                    lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.spawnParticles();
                }
            }
        }
    }

    public static void passiveVoidDepotParticles(VoidDepotBlockEntity voidDepot) {
        class_1937 level = voidDepot.method_10997();
        if (level.method_8510() % 60L == 0L) {
            class_2338 blockPos = voidDepot.method_11016();
            class_5819 rand = level.field_9229;
            int lifetime = RandomHelper.randomBetween((class_5819)rand, (int)80, (int)120);
            float yMotion = 5.0E-4f;
            Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
            ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(new class_243(0.0, 1.0, 0.0))).setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)rand, (float)0.02f, (float)0.04f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)0.2f, (float)0.05f).setEasing(Easing.SINE_IN, Easing.SINE_OUT).build()).setColorData(colorData).setLifetime(lifetime).addMotion(0.0, (double)yMotion, 0.0).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).surroundVoxelShape(level, blockPos, DEPOT_SHAPE, 4);
            if (rand.method_43057() < 0.2f) {
                int rotation = rand.method_43048(16);
                class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)new class_243((double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.75f), (double)((float)blockPos.method_10260() + 0.5f)), (float)0.5f, (float)rotation, (float)16.0f, (long)level.method_8510(), (float)640.0f);
                float acceleration = RandomHelper.randomBetween((class_5819)rand, (float)0.002f, (float)0.02f);
                long gameTime = level.method_8510();
                Consumer<LodestoneWorldParticle> behavior = p -> {
                    if (level.method_8510() < gameTime + 4L) {
                        p.setParticleSpeed(p.getParticleSpeed().method_1031(0.0, (double)acceleration, 0.0));
                    }
                };
                for (int i = 0; i < 2; ++i) {
                    ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, offsetPosition);
                    lightSpecs.getBuilder().addTickActor(behavior);
                    lightSpecs.getBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.getBloomBuilder().addTickActor(behavior);
                    lightSpecs.getBloomBuilder().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER);
                    lightSpecs.spawnParticles();
                }
            }
        }
    }

    public static ParticleEffectSpawner weepingWellSparks(class_1937 level, class_243 pos) {
        class_5819 rand = level.field_9229;
        Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
        ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
        return WeepingWellParticleEffects.weepingWellSparks(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
    }

    public static ParticleEffectSpawner weepingWellSparks(class_1937 level, class_243 pos, ColorParticleData colorData, LodestoneWorldParticleRenderType renderType) {
        class_5819 rand = level.field_9229;
        ParticleEffectSpawner lightSpecs = SparkParticleEffects.spiritMotionSparks(level, pos, colorData);
        lightSpecs.getBuilder().act(b -> b.setRenderType((class_3999)renderType).multiplyLifetime(6.0f).modifyOptionalData(b.getBehaviorData(SparkBehaviorComponent.class, SparkBehaviorComponent::getLengthData), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)rand, (float)1.75f, (float)2.5f))).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)rand, (float)0.75f, (float)1.0f))).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)rand, (float)1.5f, (float)3.5f))));
        lightSpecs.getBloomBuilder().act(b -> b.setRenderType((class_3999)renderType).multiplyLifetime(6.0f).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.75f, (float)0.25f).build()).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)rand, (float)1.0f, (float)1.25f))));
        return lightSpecs;
    }

    public static ParticleEffectSpawner weepingWellSpecs(class_1937 level, class_243 pos) {
        class_5819 rand = level.field_9229;
        Color color = WeepingWellParticleEffects.getWeepingWellSmokeColor(rand);
        ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color.darker()).setCoefficient(0.5f).build();
        return WeepingWellParticleEffects.weepingWellSpecs(level, pos, colorData, LodestoneWorldParticleRenderType.LUMITRANSPARENT);
    }

    public static ParticleEffectSpawner weepingWellSpecs(class_1937 level, class_243 pos, ColorParticleData colorData, LodestoneWorldParticleRenderType renderType) {
        class_5819 rand = level.field_9229;
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, pos, colorData, new WorldParticleOptions((class_2396)ParticleRegistry.LIGHT_SPEC_SMALL.get()));
        lightSpecs.getBuilder().act(b -> b.setRenderType((class_3999)renderType).multiplyLifetime(6.0f).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)rand, (float)0.75f, (float)1.0f))).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)rand, (float)1.5f, (float)3.5f))));
        lightSpecs.getBloomBuilder().act(b -> b.setRenderType((class_3999)renderType).multiplyLifetime(6.0f).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.75f, (float)0.25f).build()).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)rand, (float)1.0f, (float)1.25f))));
        return lightSpecs;
    }

    public static ParticleEffectSpawner weepingWellSquare(class_1937 level, class_243 pos, ColorParticleData colorData) {
        class_5819 rand = level.field_9229;
        GenericParticleData scaleData = GenericParticleData.create((float)0.1f, (float)RandomHelper.randomBetween((class_5819)rand, (float)1.7f, (float)1.8f), (float)0.5f).setEasing(Easing.SINE_OUT, Easing.SINE_IN).setCoefficient(RandomHelper.randomBetween((class_5819)rand, (float)1.0f, (float)1.25f)).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.95f));
        float yMotion = RandomHelper.randomBetween((class_5819)rand, (float)0.04f, (float)0.06f);
        class_243 motion = new class_243(0.0, (double)yMotion, 0.0);
        WorldParticleBuilder squares = WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)ParticleRegistry.SQUARE.get()), (LodestoneBehaviorComponent)LodestoneBehaviorComponent.DIRECTIONAL).setTransparencyData(GenericParticleData.create((float)0.9f, (float)0.05f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.EXPO_IN).build()).setScaleData(scaleData).setColorData(colorData).setLifetime(100).setMotion(motion).enableNoClip().setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE).addTickActor(behavior);
        Consumer<WorldParticleBuilder> squareSpawner = b -> b.spawn(level, pos.field_1352, pos.field_1351, pos.field_1350).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.EXPO_OUT).build()).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(level, pos.field_1352, pos.field_1351, pos.field_1350);
        return new ParticleEffectSpawner(squares, squareSpawner);
    }
}

