/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ParticleRegistry;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class SpiritLightSpecs {
    public static void coolLookingShinyThing(class_1937 level, class_243 pos, MalumSpiritType spiritType) {
        ParticleEffectSpawner centralLightSpecs = SpiritLightSpecs.spiritLightSpecs(level, pos, spiritType, new WorldParticleOptions((class_2396)ParticleRegistry.LIGHT_SPEC_SMALL.get()));
        centralLightSpecs.getBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(6.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(3.0f));
        centralLightSpecs.getBloomBuilder().multiplyLifetime(0.6f).modifyColorData(d -> d.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(4.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(3.0f));
        centralLightSpecs.spawnParticles();
    }

    public static void rotatingLightSpecs(class_1937 level, class_243 pos, MalumSpiritType spiritType, float distance, int rotatingSpecs) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, spiritType, distance, rotatingSpecs, b -> {});
    }

    public static void rotatingLightSpecs(class_1937 level, class_243 pos, MalumSpiritType spiritType, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> sharedModifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, spiritType, distance, rotatingSpecs, new WorldParticleOptions((class_2396)ParticleRegistry.LIGHT_SPEC_SMALL.get()), sharedModifier);
    }

    public static void rotatingLightSpecs(class_1937 level, class_243 pos, MalumSpiritType spiritType, float distance, int rotatingSpecs, WorldParticleOptions options, Consumer<WorldParticleBuilder> sharedModifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, spiritType, distance, rotatingSpecs, options, sharedModifier, sharedModifier);
    }

    public static void rotatingLightSpecs(class_1937 level, class_243 pos, MalumSpiritType spiritType, float distance, int rotatingSpecs, Consumer<WorldParticleBuilder> lightSpecModifier, Consumer<WorldParticleBuilder> bloomModifier) {
        SpiritLightSpecs.rotatingLightSpecs(level, pos, spiritType, distance, rotatingSpecs, new WorldParticleOptions((class_2396)ParticleRegistry.LIGHT_SPEC_SMALL.get()), lightSpecModifier, bloomModifier);
    }

    public static void rotatingLightSpecs(class_1937 level, class_243 pos, MalumSpiritType spiritType, float distance, int rotatingSpecs, WorldParticleOptions options, Consumer<WorldParticleBuilder> lightSpecModifier, Consumer<WorldParticleBuilder> bloomModifier) {
        long gameTime = level.method_8510();
        if (level.method_8510() % 2L == 0L) {
            for (int i = 0; i < rotatingSpecs; ++i) {
                long offsetGameTime = gameTime + (long)i * 120L;
                double yOffset = Math.sin((float)(offsetGameTime % 360L) / 30.0f) * (double)0.1f;
                class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)pos.method_1031(0.0, yOffset, 0.0), (float)distance, (float)i, (float)rotatingSpecs, (long)gameTime, (float)160.0f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType, options);
                lightSpecs.getBuilder().act(lightSpecModifier).multiplyLifetime(2.0f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                lightSpecs.getBloomBuilder().act(bloomModifier).act(b -> b.multiplyLifetime(1.4f).modifyData(List.of(() -> ((WorldParticleBuilder)b).getScaleData(), () -> ((WorldParticleBuilder)b).getTransparencyData()), d -> d.multiplyValue(0.6f)));
                lightSpecs.spawnParticles();
            }
        }
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, pos, spiritType, options);
        lightSpecs.getBuilder().act(lightSpecModifier).multiplyLifetime(0.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.7f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.5f));
        lightSpecs.getBloomBuilder().act(bloomModifier).multiplyLifetime(0.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.3f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f));
        lightSpecs.spawnParticles();
    }

    public static ParticleEffectSpawner spiritLightSpecs(class_1937 level, class_243 pos, MalumSpiritType spiritType) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, spiritType, new WorldParticleOptions(ParticleRegistry.LIGHT_SPEC_SMALL));
    }

    public static ParticleEffectSpawner spiritLightSpecs(class_1937 level, class_243 pos, ColorParticleData colorData) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, colorData, new WorldParticleOptions(ParticleRegistry.LIGHT_SPEC_SMALL));
    }

    public static ParticleEffectSpawner spiritLightSpecs(class_1937 level, class_243 pos, MalumSpiritType spiritType, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType));
    }

    public static ParticleEffectSpawner spiritLightSpecs(class_1937 level, class_243 pos, ColorParticleData colorData, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData));
    }

    public static ParticleEffectSpawner spiritLightSpecs(class_1937 level, class_243 pos, WorldParticleOptions options) {
        return SpiritLightSpecs.spiritLightSpecs(level, pos, options, WorldParticleBuilder::create);
    }

    public static ParticleEffectSpawner spiritLightSpecs(class_1937 level, class_243 pos, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier) {
        WorldParticleBuilder builder = builderSupplier.apply(options);
        WorldParticleBuilder bloomBuilder = builderSupplier.apply(new WorldParticleOptions(LodestoneParticleRegistry.WISP_PARTICLE));
        return SpiritLightSpecs.spiritLightSpecs(level, pos, builder, bloomBuilder);
    }

    public static ParticleEffectSpawner spiritLightSpecs(class_1937 level, class_243 pos, WorldParticleBuilder builder, WorldParticleBuilder bloomBuilder) {
        class_5819 rand = level.method_8409();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)rand, (float)class_3532.method_15344((class_5819)rand, (float)0.05f, (float)0.1f)).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.95f));
        int lifetime = RandomHelper.randomBetween((class_5819)rand, (int)10, (int)20);
        WorldParticleBuilder worldParticleBuilder = builder.setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.0f).build()).setSpinData(spinData).setScaleData(GenericParticleData.create((float)0.025f, (float)RandomHelper.randomBetween((class_5819)rand, (float)0.2f, (float)0.3f), (float)0.0f).build()).setLifetime(lifetime).enableNoClip().addTickActor(slowDown);
        WorldParticleBuilder bloomParticleBuilder = SpiritLightSpecs.spiritBloom(level, bloomBuilder, lifetime).setSpinData(spinData).addTickActor(slowDown);
        return new ParticleEffectSpawner(level, pos, worldParticleBuilder, bloomParticleBuilder);
    }

    public static WorldParticleBuilder spiritBloom(class_1937 level, MalumSpiritType spiritType, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, spiritType, new WorldParticleOptions(LodestoneParticleRegistry.WISP_PARTICLE), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(class_1937 level, ColorParticleData colorData, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, colorData, new WorldParticleOptions(LodestoneParticleRegistry.WISP_PARTICLE), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(class_1937 level, MalumSpiritType spiritType, WorldParticleOptions options, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, options, (WorldParticleOptions o) -> SpiritBasedParticleBuilder.createSpirit(o).setSpirit(spiritType), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(class_1937 level, ColorParticleData colorData, WorldParticleOptions options, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, options, (WorldParticleOptions o) -> WorldParticleBuilder.create((WorldParticleOptions)o).setColorData(colorData), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(class_1937 level, WorldParticleOptions options, Function<WorldParticleOptions, WorldParticleBuilder> builderSupplier, int lifetime) {
        return SpiritLightSpecs.spiritBloom(level, builderSupplier.apply(options), lifetime);
    }

    public static WorldParticleBuilder spiritBloom(class_1937 level, WorldParticleBuilder builder, int lifetime) {
        class_5819 rand = level.field_9229;
        return builder.setTransparencyData(GenericParticleData.create((float)0.35f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.04f, (float)RandomHelper.randomBetween((class_5819)rand, (float)0.08f, (float)0.14f), (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setLifetime(lifetime).enableNoClip();
    }
}

