/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICrucibleAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_crucible.SpiritCrucibleCoreBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer.SpiritCatalyzerCoreBlockEntity;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritFocusingRecipe;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class SpiritCrucibleParticleEffects {
    public static void passiveCrucibleParticles(SpiritCrucibleCoreBlockEntity crucible) {
        ParticleEffectSpawner lightSpecs;
        MalumSpiritType spiritType;
        MalumSpiritType activeSpiritType = crucible.getActiveSpiritType();
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = crucible.method_10997();
        class_5819 random = level.field_9229;
        class_243 itemPos = crucible.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = crucible.spiritInventory;
        LodestoneBlockEntityInventory augmentInventory = crucible.augmentInventory;
        SpiritFocusingRecipe recipe = crucible.recipe;
        if (recipe != null) {
            for (ICrucibleAccelerator accelerator : crucible.acceleratorData.accelerators) {
                if (accelerator == null) continue;
                accelerator.addParticles(crucible, activeSpiritType);
            }
        }
        if (recipe != null) {
            ParticleEffectSpawner lightSpecs2 = SpiritLightSpecs.spiritLightSpecs(level, itemPos, activeSpiritType, new WorldParticleOptions((class_2396)ParticleRegistry.STAR.get()));
            lightSpecs2.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset((float)level.method_8510() * 0.05f % 6.28f).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.25f));
            lightSpecs2.getBloomBuilder().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.5f));
            lightSpecs2.spawnParticles();
        }
        int spiritsRendered = 0;
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            class_1799 item = spiritInventory.getStackInSlot(i);
            class_1792 class_17922 = item.method_7909();
            if (!(class_17922 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritSplinterItem = (SpiritShardItem)class_17922;
            class_243 offset = crucible.getSpiritItemOffset(spiritsRendered++, 0.0f);
            spiritType = spiritSplinterItem.type;
            class_2338 blockPos = crucible.method_11016();
            class_243 spiritPosition = new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
            if (recipe == null) continue;
            class_243 velocity = itemPos.method_1020(spiritPosition).method_1029().method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.03f, (float)0.06f));
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, spiritType);
                sparkParticles.getBuilder().setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, spiritType);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.method_1021(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
        if (level.method_8510() % 4L == 0L) {
            int augmentsRendered = 0;
            for (int i = 0; i < augmentInventory.slotCount; ++i) {
                class_1799 item = augmentInventory.getStackInSlot(i);
                spiritType = item.method_7909();
                if (!(spiritType instanceof AbstractAugmentItem)) continue;
                AbstractAugmentItem augmentItem = (AbstractAugmentItem)((Object)spiritType);
                class_243 offset = crucible.getAugmentItemOffset(augmentsRendered++, 0.0f);
                MalumSpiritType spiritType2 = augmentItem.spiritType;
                class_2338 blockPos = crucible.method_11016();
                class_243 particlePosition = new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
                if (recipe != null) {
                    class_243 velocity = itemPos.method_1020(particlePosition).method_1029().method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.01f, (float)0.02f));
                    if (random.method_43057() < 0.15f) {
                        ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, particlePosition, spiritType2);
                        sparkParticles.getBuilder().multiplyLifetime(2.5f).setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                        sparkParticles.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity);
                        sparkParticles.spawnParticles();
                    }
                    if (random.method_43057() < 0.15f) {
                        ParticleEffectSpawner lightSpecs3 = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType2);
                        lightSpecs3.getBuilder().multiplyLifetime(2.5f).setMotion(velocity.method_1021(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
                        lightSpecs3.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity);
                        lightSpecs3.spawnParticles();
                    }
                }
                lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType2);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.3f));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f);
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void activeSpiritCatalyzerParticles(SpiritCatalyzerCoreBlockEntity catalyzer, ICatalyzerAccelerationTarget target, MalumSpiritType spiritType) {
        class_1799 item;
        class_1792 spinData;
        class_243 velocity;
        class_1937 level = catalyzer.method_10997();
        class_2338 catalyzerPos = catalyzer.method_11016();
        class_243 startPos = catalyzer.getItemOffset().method_1031((double)catalyzerPos.method_10263(), (double)catalyzerPos.method_10264(), (double)catalyzerPos.method_10260());
        class_5819 random = level.field_9229;
        class_243 targetPos = target.getAccelerationPoint();
        if (level.method_8510() % 2L == 0L) {
            velocity = targetPos.method_1020(startPos).method_1029().method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.06f, (float)0.12f));
            class_243 sparkPos = startPos.method_1031((double)(0.05f - random.method_43057() * 0.1f), (double)(0.05f - random.method_43057() * 0.1f), (double)(0.05f - random.method_43057() * 0.1f));
            ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, sparkPos, spiritType);
            sparkParticles.getBuilder().setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f)).modifyOptionalData(b -> b.getBehaviorData(SparkBehaviorComponent.class, SparkBehaviorComponent::getLengthData), d -> d.multiplyValue(2.0f).multiplyCoefficient(0.75f)).modifyColorData(c -> c.multiplyCoefficient(0.8f));
            sparkParticles.getBloomBuilder().setMotion(velocity);
            sparkParticles.spawnParticlesRaw();
        }
        if (level.method_8510() % 10L == 0L) {
            velocity = targetPos.method_1020(startPos).method_1029().method_1021((double)0.02f * targetPos.method_1022(startPos));
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.98f));
            spinData = SpinParticleData.createRandomDirection((class_5819)random, (float)RandomHelper.randomBetween((class_5819)random, (float)0.1f, (float)0.2f)).randomSpinOffset(random).build();
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)ParticleRegistry.HEXAGON.get()), (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(velocity.method_1029())).setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData((SpinParticleData)spinData).setScaleData(GenericParticleData.create((float)0.15f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(spiritType.createColorData().build()).setLifetime(60).setMotion(velocity).enableNoClip().setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.RANDOM_SPRITE).addTickActor(behavior).spawn(level, startPos.field_1352, startPos.field_1351, startPos.field_1350);
        }
        if (level.method_8510() % 4L == 0L && (spinData = (item = catalyzer.augmentInventory.getStackInSlot(0)).method_7909()) instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)spinData;
            class_243 offset = catalyzer.getAugmentOffset();
            MalumSpiritType augmentSpiritType = augmentItem.spiritType;
            class_2338 blockPos = catalyzer.method_11016();
            class_243 particlePosition = new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
            class_243 velocity2 = targetPos.method_1020(particlePosition).method_1029().method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.03f, (float)0.06f));
            if (random.method_43057() < 0.15f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, particlePosition, augmentSpiritType);
                sparkParticles.getBuilder().multiplyLifetime(2.5f).setMotion(velocity2).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity2);
                sparkParticles.spawnParticles();
            }
            if (random.method_43057() < 0.15f) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, augmentSpiritType);
                lightSpecs.getBuilder().multiplyLifetime(2.5f).setMotion(velocity2.method_1021(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(velocity2);
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void craftItemParticles(SpiritCrucibleCoreBlockEntity crucible, ColorEffectData colorData) {
        int i;
        MalumSpiritType activeSpiritType = crucible.getActiveSpiritType();
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = crucible.method_10997();
        class_5819 random = level.field_9229;
        class_2338 altarPos = crucible.method_11016();
        class_243 targetPos = crucible.getCentralItemOffset().method_1031((double)altarPos.method_10263(), (double)altarPos.method_10264(), (double)altarPos.method_10260());
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, activeSpiritType);
        }
        for (i = 0; i < 24; ++i) {
            int lifeDelay = i / 8;
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            float xVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((class_5819)random, (float)0.2f, (float)0.5f);
            float zVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((class_5819)random, (float)0.75f, (float)1.0f);
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, targetPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            float xVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            float yVelocity = RandomHelper.randomBetween((class_5819)random, (float)0.015f, (float)0.035f);
            float zVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.025f, (float)0.025f);
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos.method_1023(0.0, 0.5, 0.0), cyclingSpiritType, new WorldParticleOptions((class_2396)ParticleRegistry.STRANGE_SMOKE.get()));
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(i).multiplyLifetime(5.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).modifyColorData(c -> c.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.1f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(i).multiplyLifetime(5.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).modifyColorData(c -> c.multiplyCoefficient(0.5f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.25f));
            lightSpecs.spawnParticles();
        }
    }

    public static void passiveSpiritCatalyzerParticles(SpiritCatalyzerCoreBlockEntity catalyzer) {
        class_1799 item;
        class_1792 class_17922;
        class_1937 level = catalyzer.method_10997();
        class_5819 random = level.field_9229;
        if (level.method_8510() % 16L == 0L && (class_17922 = (item = catalyzer.augmentInventory.getStackInSlot(0)).method_7909()) instanceof AbstractAugmentItem) {
            AbstractAugmentItem augmentItem = (AbstractAugmentItem)class_17922;
            class_243 offset = catalyzer.getAugmentOffset().method_1031((double)class_3532.method_15344((class_5819)random, (float)-0.1f, (float)0.1f), (double)class_3532.method_15344((class_5819)random, (float)-0.1f, (float)0.1f), (double)class_3532.method_15344((class_5819)random, (float)-0.1f, (float)0.1f));
            MalumSpiritType augmentSpiritType = augmentItem.spiritType;
            class_2338 blockPos = catalyzer.method_11016();
            class_243 particlePosition = new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, augmentSpiritType);
            lightSpecs.getBuilder().multiplyLifetime(2.5f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.3f));
            lightSpecs.getBloomBuilder().multiplyLifetime(1.5f);
            lightSpecs.spawnParticles();
        }
    }
}

