/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.obelisk.runewood.RunewoodObeliskBlockEntity;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.ItemCrumbleParticleEffects;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class SpiritAltarParticleEffects {
    public static MalumSpiritType getCentralSpiritType(SpiritAltarBlockEntity altar) {
        LodestoneBlockEntityInventory spiritInventory = altar.spiritInventory;
        int spiritCount = spiritInventory.nonEmptyItemAmount;
        class_1792 currentItem = spiritInventory.getStackInSlot(0).method_7909();
        if (spiritCount > 1) {
            float duration = 30.0f * (float)spiritCount;
            float gameTime = (float)altar.method_10997().method_8510() % duration / 30.0f;
            currentItem = spiritInventory.getStackInSlot(class_3532.method_15375((float)gameTime)).method_7909();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem.type;
    }

    public static void passiveSpiritAltarParticles(SpiritAltarBlockEntity altar) {
        MalumSpiritType activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = altar.method_10997();
        class_5819 random = level.field_9229;
        class_243 itemPos = altar.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = altar.spiritInventory;
        SpiritInfusionRecipe recipe = altar.recipe;
        if (recipe != null) {
            for (IAltarAccelerator accelerator : altar.accelerators) {
                if (accelerator == null) continue;
                accelerator.addParticles(altar, activeSpiritType);
            }
            SpiritLightSpecs.rotatingLightSpecs(level, itemPos, activeSpiritType, 0.5f, 3, b -> b.multiplyLifetime(1.2f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.2f)));
        }
        int spiritsRendered = 0;
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            class_1799 item = spiritInventory.getStackInSlot(i);
            class_1792 class_17922 = item.method_7909();
            if (!(class_17922 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritSplinterItem = (SpiritShardItem)class_17922;
            class_243 offset = altar.getSpiritItemOffset(spiritsRendered++, 0.0f);
            activeSpiritType = spiritSplinterItem.type;
            class_2338 blockPos = altar.method_11016();
            class_243 spiritPosition = new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
            SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType).spawnParticles();
            if (recipe == null) continue;
            class_243 velocity = itemPos.method_1020(spiritPosition).method_1029().method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.03f, (float)0.06f));
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, activeSpiritType);
                sparkParticles.getBuilder().setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.method_1021(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void eatItemParticles(SpiritAltarBlockEntity altar, IMalumSpecialItemAccessPoint holder, ColorEffectData colorData, class_1799 stack) {
        int i;
        MalumSpiritType activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = altar.method_10997();
        long gameTime = level.method_8510();
        class_5819 random = level.field_9229;
        class_243 altarTargetPos = altar.getItemPos();
        class_243 holderTargetPos = holder.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, holderTargetPos, activeSpiritType);
        }
        for (i = 0; i < 16; ++i) {
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            class_243 velocity = altarTargetPos.method_1020(holderTargetPos).method_1029().method_1021((double)0.025f);
            int finalI = i;
            class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)holderTargetPos, (float)0.5f, (float)i, (float)16.0f, (long)gameTime, (float)160.0f);
            Consumer<LodestoneWorldParticle> behavior = p -> {
                if (level.method_8510() > gameTime + (long)(finalI * 2) && level.method_8510() < gameTime + (long)((finalI + 4) * 2)) {
                    p.setParticleSpeed(p.getParticleSpeed().method_1019(velocity));
                }
            };
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, cyclingSpiritType);
            lightSpecs.getBuilder().act(b -> b.addTickActor(behavior).multiplyLifetime(2.5f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)1.0f, (float)2.0f))));
            lightSpecs.getBloomBuilder().act(b -> b.addTickActor(behavior).multiplyLifetime(2.0f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)0.6f, (float)1.5f))));
            lightSpecs.spawnParticles();
            ParticleEffectSpawner crumbles = ItemCrumbleParticleEffects.spawnItemCrumbs(level, holderTargetPos, stack);
            crumbles.getBuilder().setLifeDelay(i).addTickActor(behavior);
            crumbles.spawnParticles();
            crumbles.getBuilder().setRandomOffset((double)0.2f);
            crumbles.spawnParticles();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void craftItemParticles(SpiritAltarBlockEntity altar, ColorEffectData colorData) {
        int i;
        MalumSpiritType activeSpiritType = SpiritAltarParticleEffects.getCentralSpiritType(altar);
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = altar.method_10997();
        long gameTime = level.method_8510();
        class_5819 random = level.field_9229;
        class_2338 altarPos = altar.method_11016();
        class_243 targetPos = altar.getCentralItemOffset().method_1031((double)altarPos.method_10263(), (double)altarPos.method_10264(), (double)altarPos.method_10260());
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, activeSpiritType);
        }
        for (i = 0; i < 24; ++i) {
            int lifeDelay = i / 8;
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            float xVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((class_5819)random, (float)0.2f, (float)0.5f);
            float zVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((class_5819)random, (float)0.75f, (float)1.0f);
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, targetPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, targetPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            int finalI = i;
            class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)targetPos, (float)0.6f, (float)i, (float)8.0f, (long)gameTime, (float)160.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (level.method_8510() > gameTime + (long)(finalI * 4) && level.method_8510() < gameTime + (long)((finalI + 4) * 4)) {
                    p.setParticleSpeed(p.getParticleSpeed().method_1031(0.0, (double)0.015f, 0.0));
                }
            });
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, activeSpiritType);
            lightSpecs.getBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).multiplyLifetime(1.5f).setLifetime((Integer)b.getParticleOptions().lifetimeSupplier.get() + finalI * 2));
            lightSpecs.getBloomBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).setLifetime((int)((float)((Integer)b.getParticleOptions().lifetimeSupplier.get()).intValue() + (float)finalI * 2.5f)));
            lightSpecs.spawnParticles();
        }
    }

    public static void runewoodObeliskParticles(RunewoodObeliskBlockEntity obelisk, SpiritAltarBlockEntity altar, MalumSpiritType spiritType) {
        class_1937 level = obelisk.method_10997();
        class_2338 obeliskPos = obelisk.method_11016();
        class_243 startPos = obelisk.getParticleOffset().method_1031((double)obeliskPos.method_10263(), (double)obeliskPos.method_10264(), (double)obeliskPos.method_10260());
        SpiritLightSpecs.spiritLightSpecs(level, startPos, spiritType).spawnParticles();
        if (level.method_8510() % 2L == 0L) {
            class_5819 random = level.field_9229;
            long gameTime = level.method_8510();
            class_2338 altarPos = altar.method_11016();
            class_243 targetPos = altar.getCentralItemOffset().method_1031((double)altarPos.method_10263(), (double)altarPos.method_10264(), (double)altarPos.method_10260());
            class_243 velocity = targetPos.method_1020(startPos).method_1029().method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.01f, (float)0.02f));
            double yOffset = Math.sin((float)(gameTime % 360L) / 30.0f) * (double)0.1f;
            class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)startPos.method_1031(0.0, yOffset, 0.0), (float)0.45f, (float)0.0f, (float)1.0f, (long)gameTime, (float)30.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (gameTime % 6L == 0L) {
                    p.setParticleSpeed(p.getParticleSpeed().method_1021((double)1.05f));
                }
            });
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType);
            lightSpecs.getBuilder().act(b -> b.act(behavior).setMotion(velocity).multiplyLifetime(2.0f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)1.0f, (float)2.0f))));
            lightSpecs.getBloomBuilder().act(b -> b.act(behavior).setMotion(velocity).multiplyLifetime(1.5f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)0.6f, (float)1.5f))));
            lightSpecs.spawnParticles();
        }
    }
}

