/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.components.MalumComponents;
import com.sammy.malum.common.components.MalumLivingEntityDataComponent;
import com.sammy.malum.common.item.IVoidItem;
import com.sammy.malum.core.handlers.TouchOfDarknessHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.awt.Color;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class ScreenParticleEffects {
    public static void spawnRuneParticles(ScreenParticleHolder target, MalumSpiritType spiritType) {
        class_5819 rand = class_310.method_1551().field_1687.method_8409();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.SPARKLE, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.03f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)(0.5f + rand.method_43057() * 0.1f), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setColorData(spiritType.createColorData().build()).setLifetime(RandomHelper.randomBetween((class_5819)rand, (int)20, (int)30)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).spawnOnStack(0.0, -1.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.015f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(SpinParticleData.create((float)class_3532.method_15344((class_5819)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData(GenericParticleData.create((float)(0.3f + rand.method_43057() * 0.3f), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData(spiritType.createColorData().build()).setLifetime(RandomHelper.randomBetween((class_5819)rand, (int)20, (int)30)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).spawnOnStack(0.0, 0.0).setLifetime(RandomHelper.randomBetween((class_5819)rand, (int)8, (int)12)).setSpinData(SpinParticleData.create((float)class_3532.method_15344((class_5819)rand, (float)0.05f, (float)0.1f)).build()).setScaleData(GenericParticleData.create((float)(0.6f + rand.method_43057() * 0.3f), (float)0.0f).build()).setRandomMotion((double)0.01f, (double)0.01f).spawnOnStack(0.0, -1.0);
    }

    public static void spawnSpiritShardScreenParticles(ScreenParticleHolder target, MalumSpiritType spiritType) {
        class_5819 rand = class_310.method_1551().field_1687.method_8409();
        Color color = spiritType.getPrimaryColor();
        Color endColor = spiritType.getSecondaryColor();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.SPARKLE, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.04f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)(0.8f + rand.method_43057() * 0.1f), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(2.0f).build()).setLifetime(10 + rand.method_43048(10)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).spawnOnStack(0.0, 0.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setTransparencyData(GenericParticleData.create((float)0.03f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setSpinData(SpinParticleData.create((float)class_3532.method_15344((class_5819)rand, (float)0.2f, (float)0.4f)).setEasing(Easing.EXPO_OUT).build()).setScaleData(GenericParticleData.create((float)(0.6f + rand.method_43057() * 0.4f), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(1.25f).build()).setLifetime(20 + rand.method_43048(8)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).spawnOnStack(0.0, 0.0);
    }

    public static void spawnVoidItemScreenParticles(ScreenParticleHolder target, class_1937 level, float intensity, float partialTick) {
        float colorMultiplier = class_3532.method_15344((class_5819)level.field_9229, (float)0.4f, (float)1.2f);
        float timeMultiplier = class_3532.method_15344((class_5819)level.field_9229, (float)0.9f, (float)1.4f);
        Color color = new Color((int)(31.0f * colorMultiplier), (int)(19.0f * colorMultiplier), (int)(31.0f * colorMultiplier));
        Color endColor = new Color((int)(111.0f * colorMultiplier), (int)(31.0f * colorMultiplier), (int)(121.0f * colorMultiplier));
        float gameTime = (float)level.method_8510() + partialTick;
        class_5819 rand = class_310.method_1551().field_1687.method_8409();
        SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((class_5819)rand, (float)0.0f, (float)(level.field_9229.method_43056() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).setEasing(Easing.EXPO_IN_OUT).build();
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.STAR, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)(1.2f * intensity + rand.method_43057() * 0.1f * intensity), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.BOUNCE_IN_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor).setCoefficient(2.0f).build()).setSpinData(spinParticleData).setLifetime((int)((float)(10 + rand.method_43048(10)) * timeMultiplier)).setRandomOffset((double)0.05f).setRandomMotion((double)0.05f, (double)0.05f).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawnOnStack(0.0, 0.0);
        ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)(0.8f * intensity + rand.method_43057() * 0.6f * intensity), (float)0.0f).setEasing(Easing.EXPO_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.2f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData(spinParticleData).setLifetime(20 + rand.method_43048(8)).setRandomOffset((double)0.1f).setRandomMotion((double)0.4f, (double)0.4f).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawnOnStack(0.0, 0.0).setLifetime((int)((float)(10 + rand.method_43048(2)) * timeMultiplier)).setSpinData(SpinParticleData.create((float)class_3532.method_15344((class_5819)rand, (float)0.05f, (float)0.1f)).build()).setScaleData(GenericParticleData.create((float)(0.8f + rand.method_43057() * 0.4f), (float)0.0f).build()).setRandomMotion((double)0.01f, (double)0.01f).spawnOnStack(0.0, 0.0);
    }

    public static void spawnEncyclopediaEsotericaScreenParticles(ScreenParticleHolder target, class_1937 level, float partialTick) {
        class_5819 rand = level.method_8409();
        float distance = 7.5f;
        for (int i = 0; i < 2; ++i) {
            float time = (((float)level.method_8510() + partialTick) * 0.05f + (float)i * 3.14f) % 6.28f;
            float scalar = 0.6f;
            if (time > 1.57f && time < 4.71f) {
                scalar *= Easing.QUAD_IN.ease(Math.abs(3.14f - time) / 1.57f, 0.0f, 1.0f, 1.0f);
            }
            double xOffset = Math.sin(time) * (double)distance;
            double yOffset = Math.cos(time) * (double)distance * 0.5;
            float colorMultiplier = class_3532.method_15344((class_5819)level.field_9229, (float)0.7f, (float)1.0f);
            Color color = new Color((int)(255.0f * colorMultiplier), (int)(51.0f * colorMultiplier), (int)(195.0f * colorMultiplier));
            Color endColor = new Color((int)(56.0f * colorMultiplier), (int)(32.0f * colorMultiplier), (int)(77.0f * colorMultiplier));
            float gameTime = (float)level.method_8510() + partialTick;
            SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((class_5819)rand, (float)(level.field_9229.method_43056() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).build();
            ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)0.0f, (float)(0.1f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData(spinParticleData).setLifetime(60).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawnOnStack(xOffset, yOffset).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setScaleData(GenericParticleData.create((float)(0.25f * scalar), (float)(RandomHelper.randomBetween((class_5819)rand, (float)0.3f, (float)0.4f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).repeatOnStack(xOffset, yOffset, 2);
        }
    }

    public static class VoidTransmutableParticleEffect
    implements IVoidItem {
        public static VoidTransmutableParticleEffect INSTANCE = new VoidTransmutableParticleEffect();
        private boolean isNearWell;
        private boolean isItemReal;

        @Override
        public float getVoidParticleIntensity() {
            return 1.2f;
        }

        @Override
        public void spawnEarlyParticles(ScreenParticleHolder target, class_1937 level, float partialTick, class_1799 stack, float x, float y) {
            class_746 player = class_310.method_1551().field_1724;
            TouchOfDarknessHandler handler = ((MalumLivingEntityDataComponent)MalumComponents.MALUM_LIVING_ENTITY_COMPONENT.get((Object)player)).touchOfDarknessHandler;
            this.isNearWell = handler.isNearWeepingWell;
            if (!this.isNearWell) {
                return;
            }
            if (level.method_8510() % 20L == 0L) {
                this.isItemReal = class_310.method_1551().field_1724.method_31548().method_7379(stack);
            }
            if (this.isItemReal) {
                IVoidItem.super.spawnEarlyParticles(target, level, partialTick, stack, x, y);
            }
        }

        public void spawnLateParticles(ScreenParticleHolder target, class_1937 level, float partialTick, class_1799 stack, float x, float y) {
            if (!this.isNearWell || !this.isItemReal) {
                return;
            }
            class_5819 rand = level.method_8409();
            float distance = 7.5f;
            for (int i = 0; i < 2; ++i) {
                float time = ((i == 1 ? 3.14f : 0.0f) + ((float)level.method_8510() + partialTick) * 0.1f) % 6.28f;
                float scalar = 0.6f;
                double xOffset = Math.sin(time) * (double)distance;
                double yOffset = Math.cos(time) * (double)distance;
                float colorMultiplier = class_3532.method_15344((class_5819)level.field_9229, (float)0.7f, (float)1.0f);
                Color color = new Color((int)(255.0f * colorMultiplier), (int)(51.0f * colorMultiplier), (int)(195.0f * colorMultiplier));
                Color endColor = new Color((int)(56.0f * colorMultiplier), (int)(32.0f * colorMultiplier), (int)(77.0f * colorMultiplier));
                float gameTime = (float)level.method_8510() + partialTick;
                SpinParticleData spinParticleData = SpinParticleData.createRandomDirection((class_5819)rand, (float)(level.field_9229.method_43056() ? 1.0f : -2.0f)).setSpinOffset(0.025f * gameTime % 6.28f).build();
                ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleRegistry.WISP, (ScreenParticleHolder)target).setScaleData(GenericParticleData.create((float)(0.1f * scalar), (float)(RandomHelper.randomBetween((class_5819)rand, (float)0.2f, (float)0.3f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(ColorParticleData.create((Color)color, (Color)endColor.darker()).setCoefficient(1.25f).build()).setSpinData(spinParticleData).setLifetime(40).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawnOnStack(xOffset, yOffset).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).setScaleData(GenericParticleData.create((float)(0.25f * scalar), (float)(RandomHelper.randomBetween((class_5819)rand, (float)0.3f, (float)0.4f) * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT).setEasing(Easing.EXPO_OUT).build()).repeatOnStack(xOffset, yOffset, 2);
            }
        }
    }
}

