/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualPlinthBlockEntity;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.ParticleRegistry;
import com.sammy.malum.visual_effects.ItemCrumbleParticleEffects;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.DirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;

public class RitualPlinthParticleEffects {
    public static void failRitualParticles(RitualPlinthBlockEntity plinth, ColorEffectData colorData) {
        int i;
        MalumSpiritType spiritType = colorData.getSpiritType();
        class_1937 level = plinth.method_10997();
        class_5819 random = level.field_9229;
        class_243 ritualIconPos = plinth.getRitualIconPos();
        for (int i2 = 0; i2 < 6; ++i2) {
            float scale = 2.0f + (float)i2 * (i2 < 2 ? 6.0f : 1.0f) * Math.min(plinth.activeDuration, 30.0f) / 30.0f;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, ritualIconPos, spiritType, new WorldParticleOptions(i2 < 2 ? ParticleRegistry.STAR : LodestoneParticleRegistry.TWINKLE_PARTICLE));
            lightSpecs.getBuilder().setSpinData(SpinParticleData.create((float)0.4f, (float)0.0f).setSpinOffset((float)level.method_8510() * 0.05f % 6.28f).setEasing(Easing.CUBIC_IN).build()).setScaleData(GenericParticleData.create((float)(RandomHelper.randomBetween((class_5819)random, (float)0.2f, (float)0.3f) * scale), (float)(0.1f * scale), (float)0.0f).setEasing(Easing.QUAD_IN, Easing.SINE_IN).build()).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f));
            lightSpecs.getBloomBuilder().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(scale)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f));
            lightSpecs.spawnParticles();
        }
        int spinOffset = random.method_43048(360);
        for (i = 0; i < 4; ++i) {
            int spinDirection = random.method_43056() ? 1 : -1;
            float scaleMultiplier = (float)(1.0 + Math.pow(random.method_43057(), 2.0));
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.4f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.125f + random.method_43057() * 0.075f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)(1.2f * scaleMultiplier), (float)0.4f, (float)0.0f).setEasing(Easing.QUAD_IN, Easing.SINE_IN).build()).setColorData(spiritType.createColorData().build()).setLifetime(40).setRandomOffset((double)0.6f).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).repeat(level, ritualIconPos.field_1352, ritualIconPos.field_1351, ritualIconPos.field_1350, 3);
        }
        for (i = 0; i < 64; ++i) {
            boolean star;
            float lifetimeMultiplier = RandomHelper.randomBetween((class_5819)random, (float)2.0f, (float)2.5f);
            float gravityStrength = RandomHelper.randomBetween((class_5819)random, (float)0.01f, (float)0.05f);
            double horizontalAngle = random.method_43058() * Math.PI * 2.0;
            double x = Math.cos(horizontalAngle);
            double y = class_3532.method_15344((class_5819)random, (float)-1.0f, (float)1.5f);
            double z = Math.sin(horizontalAngle);
            class_243 direction = new class_243(x, y, z);
            class_243 motion = direction.method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.25f, (float)0.5f));
            class_243 spawnPosition = ritualIconPos.method_1019(direction.method_1021(0.25));
            Consumer<LodestoneWorldParticle> slowDown = p -> {
                class_243 velocity = p.getParticleSpeed().method_1021((double)0.95f);
                if (velocity.equals((Object)class_243.field_1353)) {
                    velocity = p.getParticleSpeed();
                }
                p.method_34753(velocity.field_1352, (velocity.field_1351 - (double)gravityStrength) * (double)0.98f, velocity.field_1350);
            };
            boolean bl = star = random.method_43057() < 0.2f;
            if (random.method_43057() < 0.8f) {
                WorldParticleOptions options = new WorldParticleOptions(star ? ParticleRegistry.STAR : ParticleRegistry.LIGHT_SPEC_SMALL);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, spiritType, options);
                lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f)).setMotion(motion);
                lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(star ? 2.4f : 1.2f)).setMotion(motion);
                lightSpecs.spawnParticles();
            }
            if (star || !(random.method_43057() < 0.8f)) continue;
            float scalar = RandomHelper.randomBetween((class_5819)random, (float)0.8f, (float)1.1f);
            GenericParticleData lengthData = GenericParticleData.create((float)(2.0f * scalar), (float)(0.5f * scalar), (float)0.0f).setEasing(Easing.QUARTIC_OUT, Easing.SINE_IN_OUT).build();
            ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, spiritType).act(b -> b.getParticleOptions().setBehavior((LodestoneBehaviorComponent)new SparkBehaviorComponent(lengthData)));
            sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().addTickActor(slowDown).setMotion(motion).setScaleData(GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN, Easing.QUAD_IN).build());
            sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).addTickActor(slowDown).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f)).setMotion(motion);
            sparks.spawnParticles();
        }
    }

    public static void incrementRitualTierParticles(RitualPlinthBlockEntity plinth, ColorEffectData colorData) {
        int i;
        MalumSpiritType spiritType = colorData.getSpiritType();
        class_1937 level = plinth.method_10997();
        class_5819 random = level.field_9229;
        class_243 ritualIconPos = plinth.getRitualIconPos();
        for (int i2 = 0; i2 < 6; ++i2) {
            float scale = 2.0f + (float)i2 * (i2 < 2 ? 6.0f : 1.25f);
            WorldParticleOptions options = new WorldParticleOptions(i2 < 2 ? ParticleRegistry.STAR : ParticleRegistry.LIGHT_SPEC_SMALL);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, ritualIconPos, spiritType, options);
            lightSpecs.getBuilder().setSpinData(SpinParticleData.create((float)0.4f, (float)0.0f).setSpinOffset((float)level.method_8510() * 0.05f % 6.28f).setEasing(Easing.CUBIC_IN).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((class_5819)random, (float)0.2f, (float)0.3f), (float)0.1f, (float)0.0f).setEasing(Easing.QUAD_IN, Easing.SINE_IN).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(scale)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f));
            lightSpecs.getBloomBuilder().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(scale)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f));
            lightSpecs.spawnParticles();
        }
        int spinOffset = random.method_43048(360);
        for (i = 0; i < 4; ++i) {
            int spinDirection = random.method_43056() ? 1 : -1;
            float scaleMultiplier = (float)(1.0 + Math.pow(random.method_43057(), 2.0));
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.4f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.125f + random.method_43057() * 0.075f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)(1.2f * scaleMultiplier), (float)0.4f, (float)0.0f).setEasing(Easing.QUAD_IN, Easing.SINE_IN).build()).setColorData(spiritType.createColorData().build()).setLifetime(40).setRandomOffset((double)0.6f).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).repeat(level, ritualIconPos.field_1352, ritualIconPos.field_1351, ritualIconPos.field_1350, 3);
        }
        for (i = 0; i < 48; ++i) {
            float angle = (float)i / 32.0f * (float)Math.PI * 2.0f;
            float speed = RandomHelper.randomBetween((class_5819)random, (float)0.05f, (float)0.15f);
            float distance = RandomHelper.randomBetween((class_5819)random, (float)1.5f, (float)2.5f);
            double x = Math.sin(angle);
            double y = random.method_43057() * (float)(random.method_43056() ? 1 : -1);
            double z = Math.cos(angle);
            class_243 offset = new class_243(x, y, z).method_1029();
            class_243 particlePosition = ritualIconPos.method_1019(offset.method_1021((double)distance));
            class_243 particleMotion = offset.method_1021((double)(-speed));
            float gravityStrength = 0.0f;
            GenericParticleData transparencyData = GenericParticleData.create((float)0.1f, (float)0.9f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build();
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, particlePosition, spiritType);
                sparkParticles.getBuilder().setTransparencyData(transparencyData).disableNoClip().multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion(particleMotion).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().setTransparencyData(transparencyData).disableNoClip().multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion(particleMotion).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType);
            lightSpecs.getBuilder().disableNoClip().multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion(particleMotion).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion(particleMotion).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
    }

    public static void beginChargingParticles(RitualPlinthBlockEntity plinth, ColorEffectData colorData) {
        float scale;
        int i;
        MalumSpiritType spiritType = colorData.getSpiritType();
        class_1937 level = plinth.method_10997();
        long gameTime = level.method_8510();
        class_5819 random = level.field_9229;
        class_243 plinthItemPos = plinth.getItemPos();
        class_243 ritualIconPos = plinth.getRitualIconPos().method_1031(0.0, 0.3125, 0.0);
        for (i = 0; i < 4; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, plinthItemPos, spiritType);
            scale = 1.0f + (float)i * (i < 2 ? 3.0f : 0.75f);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, plinthItemPos, spiritType, new WorldParticleOptions(i < 2 ? ParticleRegistry.STAR : LodestoneParticleRegistry.TWINKLE_PARTICLE));
            lightSpecs.getBuilder().setSpinData(SpinParticleData.create((float)0.2f, (float)0.0f).setSpinOffset((float)level.method_8510() * 0.05f % 6.28f).setEasing(Easing.CUBIC_IN).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(scale)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.5f)).multiplyLifetime(1.5f);
            lightSpecs.getBloomBuilder().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(scale)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f)).multiplyLifetime(1.5f);
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 6; ++i) {
            scale = 2.0f + (float)i * (i < 2 ? 4.0f : 1.0f);
            class_243 motion = new class_243(0.0, (double)0.15f, 0.0);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, ritualIconPos, spiritType, new WorldParticleOptions(i < 2 ? ParticleRegistry.STAR : LodestoneParticleRegistry.TWINKLE_PARTICLE));
            lightSpecs.getBuilder().setSpinData(SpinParticleData.create((float)0.2f, (float)0.0f).setSpinOffset((float)level.method_8510() * 0.05f % 6.28f).setEasing(Easing.CUBIC_IN).build()).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(scale)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.5f)).multiplyLifetime(1.5f).setMotion(motion);
            lightSpecs.getBloomBuilder().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(scale)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(0.75f)).multiplyLifetime(1.5f).setMotion(motion);
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 128; ++i) {
            int finalI = i;
            class_243 particlePosition = DataHelper.rotatingRadialOffset((class_243)plinthItemPos, (float)0.75f, (float)i, (float)64.0f, (long)gameTime, (float)160.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if ((float)level.method_8510() < (float)gameTime + (float)(finalI + 2) / 2.0f) {
                    p.method_34753(0.0, (double)(0.03f * ((float)finalI / 128.0f)), 0.0);
                }
            });
            Consumer<WorldParticleBuilder> behaviorSpark = b -> b.addTickActor(p -> {
                if ((float)level.method_8510() < (float)gameTime + (float)(finalI + 2) / 2.0f) {
                    p.method_34753(0.0, (double)(0.03f * ((float)finalI / 128.0f)), 0.0);
                }
                p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.95f));
            });
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)ParticleRegistry.SHARP_SPARK.get()), (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(plinthItemPos.method_1020(particlePosition).method_1029())).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.9f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)class_3532.method_15344((class_5819)random, (float)0.025f, (float)0.05f)).randomSpinOffset(random).build()).setScaleData(GenericParticleData.create((float)0.3f, (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(spiritType.createColorData().build().multiplyCoefficient(1.5f)).setLifetime(160 + finalI * 8).setMotion(new class_243(0.0, (double)0.005f, 0.0)).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).act(behaviorSpark).spawn(level, particlePosition.field_1352, particlePosition.field_1351, particlePosition.field_1350);
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType);
            lightSpecs.getBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).multiplyLifetime(5.0f).setLifetime((Integer)b.getParticleOptions().lifetimeSupplier.get() + finalI * 4));
            lightSpecs.getBloomBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).setLifetime((Integer)b.getParticleOptions().lifetimeSupplier.get() + finalI * 4));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 48; ++i) {
            int lifeDelay = i / 8;
            float xVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((class_5819)random, (float)0.1f, (float)0.2f);
            float zVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = 0.0f;
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, ritualIconPos, spiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, ritualIconPos, spiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
    }

    public static void eatItemParticles(RitualPlinthBlockEntity plinth, class_243 targetPos, ColorEffectData colorData, class_1799 stack) {
        int i;
        MalumSpiritType spiritType = colorData.getSpiritType();
        class_1937 level = plinth.method_10997();
        long gameTime = level.method_8510();
        class_5819 random = level.field_9229;
        class_243 plinthItemPos = plinth.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, spiritType);
            SpiritLightSpecs.coolLookingShinyThing(level, plinthItemPos, spiritType);
        }
        for (i = 0; i < 16; ++i) {
            class_243 velocity = plinthItemPos.method_1020(targetPos).method_1029().method_1021((double)0.025f);
            int finalI = i;
            class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)targetPos, (float)0.5f, (float)i, (float)16.0f, (long)gameTime, (float)160.0f);
            Consumer<LodestoneWorldParticle> behavior = p -> {
                if (level.method_8510() > gameTime + (long)(finalI * 2) && level.method_8510() < gameTime + (long)((finalI + 4) * 2)) {
                    p.setParticleSpeed(p.getParticleSpeed().method_1019(velocity));
                }
            };
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, spiritType);
            lightSpecs.getBuilder().act(b -> b.addTickActor(behavior).multiplyLifetime(2.5f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)1.0f, (float)2.0f))));
            lightSpecs.getBloomBuilder().act(b -> b.addTickActor(behavior).multiplyLifetime(2.0f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(RandomHelper.randomBetween((class_5819)random, (float)0.6f, (float)1.5f))));
            lightSpecs.spawnParticles();
            ParticleEffectSpawner crumbles = ItemCrumbleParticleEffects.spawnItemCrumbs(level, targetPos, stack);
            crumbles.getBuilder().setLifeDelay(i).addTickActor(behavior);
            crumbles.spawnParticles();
            crumbles.getBuilder().setRandomOffset((double)0.2f).getScaleData();
            crumbles.spawnParticles();
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 4; ++j) {
                class_243 particlePosition = DataHelper.rotatingRadialOffset((class_243)targetPos, (float)0.5f, (float)j, (float)4.0f, (long)(level.method_8510() + (long)(i * 4)), (float)160.0f);
                WorldParticleBuilder.create(ParticleRegistry.SHARP_SPARK, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(targetPos.method_1020(particlePosition).method_1029())).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)class_3532.method_15344((class_5819)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setScaleData(GenericParticleData.create((float)0.125f, (float)0.075f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setColorData(spiritType.createColorData().build().multiplyCoefficient(1.5f)).setLifetime(60).setLifeDelay(i * 2).setMotion(new class_243(0.0, (double)0.005f, 0.0)).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawn(level, particlePosition.field_1352, particlePosition.field_1351 - 0.125, particlePosition.field_1350);
            }
        }
    }

    public static void eatSpiritParticles(RitualPlinthBlockEntity plinth, class_243 targetPos, ColorEffectData colorData, class_1799 stack) {
        MalumSpiritType spiritType = colorData.getSpiritType();
        class_1937 level = plinth.method_10997();
        long gameTime = level.method_8510();
        class_5819 random = level.field_9229;
        class_243 plinthItemPos = plinth.getItemPos();
        for (int i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, targetPos, spiritType);
            SpiritLightSpecs.coolLookingShinyThing(level, plinthItemPos, spiritType);
        }
    }

    public static void holdingPrimeItemPlinthParticles(RitualPlinthBlockEntity plinth) {
        class_1937 level = plinth.method_10997();
        MalumSpiritType spiritType = plinth.ritualType != null ? plinth.ritualType.spirit : plinth.ritualRecipe.ritualType.spirit;
        class_5819 random = level.field_9229;
        class_243 itemPos = plinth.getItemPos();
        SpiritLightSpecs.rotatingLightSpecs(level, itemPos, spiritType, 0.5f, 3, b -> b.multiplyLifetime(1.2f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.2f)));
        if (level.method_8510() % 3L == 0L) {
            for (int i = 0; i < 8; ++i) {
                class_243 particlePosition = DataHelper.rotatingRadialOffset((class_243)itemPos, (float)0.5f, (float)i, (float)8.0f, (long)level.method_8510(), (float)320.0f);
                WorldParticleBuilder.create(ParticleRegistry.SHARP_SPARK, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(itemPos.method_1020(particlePosition).method_1029())).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)class_3532.method_15344((class_5819)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setScaleData(GenericParticleData.create((float)0.125f, (float)0.075f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setColorData(spiritType.createColorData().build().multiplyCoefficient(1.5f)).setLifetime(40).setMotion(new class_243(0.0, (double)0.005f, 0.0)).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawn(level, particlePosition.field_1352, particlePosition.field_1351 - 0.125, particlePosition.field_1350);
            }
        }
    }

    public static void riteActivePlinthParticles(RitualPlinthBlockEntity plinth) {
        class_1937 level = plinth.method_10997();
        MalumSpiritType spiritType = plinth.ritualType.spirit;
        class_5819 random = level.field_9229;
        class_243 ritualIconPos = plinth.getRitualIconPos();
        long gameTime = level.method_8510();
        if (gameTime % 24L == 0L) {
            float scale = 0.8f + 0.08f * (float)(plinth.ritualTier != null ? plinth.ritualTier.potency : 0);
            WorldParticleBuilder.create((RegistryObject)(random.method_43056() ? LodestoneParticleRegistry.TWINKLE_PARTICLE : LodestoneParticleRegistry.STAR_PARTICLE)).setTransparencyData(GenericParticleData.create((float)0.0f, (float)0.6f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)RandomHelper.randomBetween((class_5819)random, (float)0.025f, (float)0.05f)).randomSpinOffset(random).build()).setScaleData(GenericParticleData.create((float)0.4f, (float)scale, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setColorData(random.method_43056() ? spiritType.createColorData().build().multiplyCoefficient(0.5f) : spiritType.createColorData().build()).setLifetime(120).setRandomOffset((double)0.1f).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT).repeat(level, ritualIconPos.field_1352, ritualIconPos.field_1351, ritualIconPos.field_1350, 3);
        }
        for (class_2350 direction : class_2350.values()) {
            class_243 randomizedVelocity;
            if (direction.method_10166().equals((Object)class_2350.class_2351.field_11052)) continue;
            class_243 particlePosition = plinth.getParticlePositionPosition(direction);
            class_243 particleVelocity = new class_243((double)(0.03f * (float)direction.method_10148()), 0.0, (double)(0.03f * (float)direction.method_10165()));
            if (gameTime % 6L == 0L) {
                randomizedVelocity = particleVelocity.method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.8f, (float)1.2f));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, particlePosition, spiritType);
                lightSpecs.getBuilder().multiplyLifetime(1.75f).setMotion(randomizedVelocity);
                lightSpecs.getBloomBuilder().multiplyLifetime(1.5f).setMotion(randomizedVelocity);
                lightSpecs.spawnParticles();
            }
            if (gameTime % 6L == 0L) {
                randomizedVelocity = particleVelocity.method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.8f, (float)1.2f));
                class_243 sparkPos = particlePosition.method_1031((double)(0.05f - random.method_43057() * 0.1f), (double)(0.05f - random.method_43057() * 0.1f), (double)(0.05f - random.method_43057() * 0.1f));
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, sparkPos, spiritType);
                sparkParticles.getBuilder().setMotion(randomizedVelocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.25f)).modifyOptionalData(b -> b.getBehaviorData(SparkBehaviorComponent.class, SparkBehaviorComponent::getLengthData), d -> d.multiplyValue(1.75f).multiplyCoefficient(0.75f)).modifyColorData(c -> c.multiplyCoefficient(0.5f));
                sparkParticles.getBloomBuilder().setMotion(randomizedVelocity);
                sparkParticles.spawnParticlesRaw();
            }
            if (gameTime % 12L == 0L) {
                WorldParticleBuilder.create(gameTime % 24L == 0L ? ParticleRegistry.CIRCLE : ParticleRegistry.SQUARE, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(particleVelocity.method_1029())).setTransparencyData(GenericParticleData.create((float)0.8f, (float)1.0f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)class_3532.method_15344((class_5819)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)0.2f).setEasing(Easing.SINE_IN).build()).setColorData(spiritType.createColorData().setCoefficient(0.75f).build()).setLifetime(80).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawn(level, particlePosition.field_1352, particlePosition.field_1351, particlePosition.field_1350);
            }
            class_243 normalizedParticleVelocity = particleVelocity.method_1029();
            float yRot = (float)(class_3532.method_15349((double)normalizedParticleVelocity.field_1352, (double)normalizedParticleVelocity.field_1350) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            class_243 left = new class_243(-Math.cos(yaw), 0.0, Math.sin(yaw));
            class_243 up = left.method_1036(normalizedParticleVelocity);
            Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.98f));
            float angle = (float)(gameTime % 40L) / 40.0f * (float)Math.PI * 2.0f;
            class_243 randomizedVelocity2 = particleVelocity.method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.8f, (float)1.2f));
            class_243 particleDirection = particleVelocity.method_1019(left.method_1021(Math.sin(angle))).method_1019(up.method_1021(Math.cos(angle))).method_1029();
            particlePosition = particlePosition.method_1019(particleDirection.method_1021((double)0.075f));
            WorldParticleBuilder.create(ParticleRegistry.SHARP_SPARK, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(particleDirection)).setTransparencyData(GenericParticleData.create((float)0.6f, (float)0.4f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)class_3532.method_15344((class_5819)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setScaleData(GenericParticleData.create((float)0.125f, (float)0.075f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setColorData(spiritType.createColorData().build().multiplyCoefficient(1.5f)).setLifetime(30).setMotion(randomizedVelocity2).enableNoClip().addTickActor(behavior).spawn(level, particlePosition.field_1352, particlePosition.field_1351, particlePosition.field_1350);
        }
        if (gameTime % 16L == 0L) {
            class_243 particlePosition = plinth.method_11016().method_46558();
            for (int i = 0; i < 2; ++i) {
                GenericParticleData transparencyData = GenericParticleData.create((float)0.0f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build();
                GenericParticleData scaleData = GenericParticleData.create((float)0.35f).setEasing(Easing.SINE_IN).build();
                SpinParticleData spinData = SpinParticleData.create((float)0.0157f).setSpinOffset((i == 1 ? 0.0f : 0.785f) + 2.512f * (float)(gameTime % 800L) / 160.0f).build();
                Color color = i == 0 ? spiritType.getPrimaryColor() : spiritType.getSecondaryColor();
                ColorParticleData colorData = ColorParticleData.create((Color)color, (Color)color).build();
                WorldParticleBuilder.create(ParticleRegistry.RITUAL_CIRCLE, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(new class_243(0.0, 1.0, 0.0))).setTransparencyData(transparencyData).setSpinData(spinData).setScaleData(scaleData).setColorData(colorData).setLifetime(40).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawn(level, particlePosition.field_1352, particlePosition.field_1351 + 0.6875, particlePosition.field_1350);
                WorldParticleBuilder.create(ParticleRegistry.RITUAL_CIRCLE_WISP, (LodestoneBehaviorComponent)new DirectionalBehaviorComponent(new class_243(0.0, 1.0, 0.0))).setTransparencyData(transparencyData.multiplyValue(0.25f)).setSpinData(spinData).setScaleData(scaleData.multiplyValue(1.25f)).setColorData(colorData).setLifetime(40).enableNoClip().setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).spawn(level, particlePosition.field_1352, particlePosition.field_1351 + 0.6875, particlePosition.field_1350);
            }
        }
    }
}

