/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonCoreBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;

public class RepairPylonParticleEffects {
    public static MalumSpiritType getCentralSpiritType(RepairPylonCoreBlockEntity pylon) {
        LodestoneBlockEntityInventory spiritInventory = pylon.spiritInventory;
        int spiritCount = spiritInventory.nonEmptyItemAmount;
        class_1792 currentItem = spiritInventory.getStackInSlot(0).method_7909();
        if (spiritCount > 1) {
            float duration = 60.0f * (float)spiritCount;
            float gameTime = (float)pylon.method_10997().method_8510() % duration / 60.0f;
            currentItem = spiritInventory.getStackInSlot(class_3532.method_15375((float)gameTime)).method_7909();
        }
        if (!(currentItem instanceof SpiritShardItem)) {
            return null;
        }
        SpiritShardItem spiritItem = (SpiritShardItem)currentItem;
        return spiritItem.type;
    }

    public static void passiveRepairPylonParticles(RepairPylonCoreBlockEntity pylon) {
        MalumSpiritType activeSpiritType = RepairPylonParticleEffects.getCentralSpiritType(pylon);
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = pylon.method_10997();
        class_5819 random = level.field_9229;
        class_243 itemPos = pylon.getItemPos();
        LodestoneBlockEntityInventory spiritInventory = pylon.spiritInventory;
        SpiritRepairRecipe recipe = pylon.recipe;
        RepairPylonCoreBlockEntity.RepairPylonState state = pylon.state;
        if (recipe != null && !state.equals((Object)RepairPylonCoreBlockEntity.RepairPylonState.COOLDOWN)) {
            SpiritLightSpecs.rotatingLightSpecs(level, itemPos, activeSpiritType, 0.5f, 3, b -> b.multiplyLifetime(1.2f).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.2f)));
        }
        int spiritsRendered = 0;
        for (int i = 0; i < spiritInventory.slotCount; ++i) {
            class_1799 item = spiritInventory.getStackInSlot(i);
            class_1792 class_17922 = item.method_7909();
            if (!(class_17922 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritSplinterItem = (SpiritShardItem)class_17922;
            class_243 offset = pylon.getSpiritItemOffset(spiritsRendered++, 0.0f);
            activeSpiritType = spiritSplinterItem.type;
            class_2338 blockPos = pylon.method_11016();
            class_243 spiritPosition = new class_243((double)blockPos.method_10263() + offset.field_1352, (double)blockPos.method_10264() + offset.field_1351, (double)blockPos.method_10260() + offset.field_1350);
            SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType).spawnParticles();
            if (recipe == null || !state.equals((Object)RepairPylonCoreBlockEntity.RepairPylonState.CHARGING)) continue;
            class_243 velocity = itemPos.method_1020(spiritPosition).method_1029().method_1021((double)RandomHelper.randomBetween((class_5819)random, (float)0.03f, (float)0.06f));
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, spiritPosition, activeSpiritType);
                sparkParticles.getBuilder().setMotion(velocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.2f));
                sparkParticles.getBloomBuilder().setMotion(velocity);
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spiritPosition, activeSpiritType);
            lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(velocity.method_1021(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.6f));
            lightSpecs.getBloomBuilder().setMotion(velocity);
            lightSpecs.spawnParticles();
        }
    }

    public static void prepareRepairParticles(RepairPylonCoreBlockEntity pylon, IMalumSpecialItemAccessPoint holder, ColorEffectData colorData) {
        int i;
        MalumSpiritType activeSpiritType = RepairPylonParticleEffects.getCentralSpiritType(pylon);
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = pylon.method_10997();
        class_5819 random = level.field_9229;
        long gameTime = level.method_8510();
        class_243 pylonItemPos = pylon.getItemPos();
        class_243 holderItemPos = holder.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, pylonItemPos, activeSpiritType);
        }
        for (i = 0; i < 4; ++i) {
            long time;
            float distance;
            int j;
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            for (j = 0; j < 32; ++j) {
                distance = 0.8f * (1.0f - (float)j / 32.0f);
                time = gameTime + (long)(j * 3);
                class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)holderItemPos, (float)distance, (float)i, (float)4.0f, (long)time, (float)160.0f);
                if (random.method_43057() < 0.85f) {
                    ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, offsetPosition, cyclingSpiritType);
                    sparkParticles.getBuilder().disableNoClip().setLifeDelay(j).multiplyLifetime(0.75f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.0f));
                    sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(j).multiplyLifetime(0.75f).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                    sparkParticles.spawnParticles();
                }
                if (!(random.method_43057() < 0.85f)) continue;
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, cyclingSpiritType);
                lightSpecs.getBuilder().disableNoClip().setLifeDelay(j).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
                lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(j).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                lightSpecs.spawnParticles();
            }
            for (j = 0; j < 32; ++j) {
                distance = 0.8f * ((float)j / 32.0f);
                time = gameTime + (long)(j * 3);
                int lifeDelay = 32 - j;
                class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)pylonItemPos, (float)distance, (float)i, (float)4.0f, (long)time, (float)160.0f);
                if (random.method_43057() < 0.85f) {
                    ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, offsetPosition, cyclingSpiritType);
                    sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(0.75f).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.0f));
                    sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(0.75f).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                    sparkParticles.spawnParticles();
                }
                if (!(random.method_43057() < 0.85f)) continue;
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, cyclingSpiritType);
                lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
                lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void repairItemParticles(RepairPylonCoreBlockEntity pylon, IMalumSpecialItemAccessPoint holder, ColorEffectData colorData) {
        MalumSpiritType activeSpiritType = RepairPylonParticleEffects.getCentralSpiritType(pylon);
        if (activeSpiritType == null) {
            return;
        }
        class_1937 level = pylon.method_10997();
        RepairPylonParticleEffects.repairItemParticles(level, activeSpiritType, pylon.getItemPos(), colorData);
        RepairPylonParticleEffects.repairItemParticles(level, activeSpiritType, holder.getItemPos(), colorData);
    }

    public static void repairItemParticles(class_1937 level, MalumSpiritType activeSpiritType, class_243 itemPos, ColorEffectData colorData) {
        int i;
        long gameTime = level.method_8510();
        class_5819 random = level.field_9229;
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing(level, itemPos, activeSpiritType);
        }
        for (i = 0; i < 24; ++i) {
            int lifeDelay = i / 8;
            MalumSpiritType cyclingSpiritType = colorData.getCyclingColorRecord().spiritType();
            float xVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yVelocity = RandomHelper.randomBetween((class_5819)random, (float)0.2f, (float)0.5f);
            float zVelocity = RandomHelper.randomBetween((class_5819)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float gravityStrength = RandomHelper.randomBetween((class_5819)random, (float)0.75f, (float)1.0f);
            if (random.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = SparkParticleEffects.spiritMotionSparks(level, itemPos, cyclingSpiritType);
                sparkParticles.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.0f));
                sparkParticles.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(2.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(random.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, itemPos, cyclingSpiritType);
            lightSpecs.getBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(2.5f));
            lightSpecs.getBloomBuilder().disableNoClip().setLifeDelay(lifeDelay).multiplyLifetime(4.0f).setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            int finalI = i;
            class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)itemPos, (float)0.6f, (float)i, (float)8.0f, (long)gameTime, (float)160.0f);
            Consumer<WorldParticleBuilder> behavior = b -> b.addTickActor(p -> {
                if (level.method_8510() > gameTime + (long)(finalI * 4) && level.method_8510() < gameTime + (long)((finalI + 4) * 4)) {
                    p.setParticleSpeed(p.getParticleSpeed().method_1031(0.0, (double)0.015f, 0.0));
                }
            });
            ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetPosition, activeSpiritType);
            lightSpecs.getBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).multiplyLifetime(1.5f).setLifetime((Integer)b.getParticleOptions().lifetimeSupplier.get() + finalI * 2));
            lightSpecs.getBloomBuilder().act(b -> b.act(behavior).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyData(() -> ((WorldParticleBuilder)b).getScaleData(), d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyData(() -> ((WorldParticleBuilder)b).getTransparencyData(), d -> d.multiplyCoefficient(0.9f)).setLifetime((int)((float)((Integer)b.getParticleOptions().lifetimeSupplier.get()).intValue() + (float)finalI * 2.5f)));
            lightSpecs.spawnParticles();
        }
    }
}

