/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import com.sammy.malum.visual_effects.WeepingWellParticleEffects;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;

public class RadiantParticleEffects {
    public static final List<Color> RADIANT_COLORS = List.of(new Color(179, 35, 218), new Color(224, 210, 68), new Color(42, 146, 218));

    public static void spitOutWeepingWellRadiance(class_1937 level, PositionEffectData positionEffectData) {
        int i;
        double posX = positionEffectData.posX;
        double posY = positionEffectData.posY;
        double posZ = positionEffectData.posZ;
        class_243 pos = new class_243(posX, posY, posZ);
        class_5819 rand = level.field_9229;
        Consumer<LodestoneWorldParticle> spawnBehavior = p -> p.tick(2);
        for (int i2 = 0; i2 < 64; ++i2) {
            Color color = RADIANT_COLORS.get(i2 % 12 / 4);
            ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
            float xVelocity = RandomHelper.randomBetween((class_5819)rand, (float)0.0f, (float)0.15f) * (float)(rand.method_43056() ? 1 : -1);
            float yVelocity = RandomHelper.randomBetween((class_5819)rand, (float)0.5f, (float)1.0f);
            float zVelocity = RandomHelper.randomBetween((class_5819)rand, (float)0.0f, (float)0.15f) * (float)(rand.method_43056() ? 1 : -1);
            float gravityStrength = RandomHelper.randomBetween((class_5819)rand, (float)0.75f, (float)1.0f);
            if (rand.method_43057() < 0.85f) {
                ParticleEffectSpawner sparkParticles = WeepingWellParticleEffects.weepingWellSparks(level, pos, colorData, LodestoneWorldParticleRenderType.ADDITIVE);
                sparkParticles.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(2.0f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
                sparkParticles.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength / 2.0f).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
                sparkParticles.spawnParticles();
            }
            if (!(rand.method_43057() < 0.85f)) continue;
            ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, pos, colorData, LodestoneWorldParticleRenderType.ADDITIVE);
            lightSpecs.getBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)(xVelocity *= 1.25f), (double)(yVelocity *= 0.75f), (double)(zVelocity *= 1.25f)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.5f));
            lightSpecs.getBloomBuilder().addSpawnActor(spawnBehavior).disableNoClip().setGravityStrength(gravityStrength).setMotion((double)xVelocity, (double)yVelocity, (double)zVelocity).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(1.25f));
            lightSpecs.spawnParticles();
        }
        int spinOffset = rand.method_43048(360);
        for (i = 0; i < 3; ++i) {
            int lifeDelay = 4 * i;
            Color color = RADIANT_COLORS.get((int)((level.method_8510() % 3L + (long)i) % 3L));
            ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
            int spinDirection = rand.method_43056() ? 1 : -1;
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARKLE_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.4f, (float)0.0f).setEasing(Easing.QUAD_IN, Easing.CIRC_IN).build()).setSpinData(SpinParticleData.create((float)((0.05f + rand.method_43057() * 0.025f) * (float)spinDirection)).setSpinOffset((float)spinOffset).build()).setScaleData(GenericParticleData.create((float)3.0f, (float)5.0f, (float)0.6f).setEasing(Easing.QUARTIC_OUT, Easing.SINE_IN).build()).setColorData(colorData).setLifeDelay(lifeDelay).setLifetime(25 + lifeDelay).setRandomOffset((double)0.6f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).repeat(level, posX, posY + 0.25, posZ, 5);
        }
        for (i = 0; i < 27; ++i) {
            int finalI = 4 + i;
            Color color = RADIANT_COLORS.get((int)(level.method_8510() - 27L + (long)i) % 27 / 9);
            ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
            ParticleEffectSpawner squares = WeepingWellParticleEffects.weepingWellSquare(level, pos, colorData);
            squares.getBuilder().addSpawnActor(p -> p.tick(finalI));
            squares.spawnParticles();
        }
    }

    public static void radiantWeepingWellParticles(VoidConduitBlockEntity voidConduit) {
        class_1937 level = voidConduit.method_10997();
        class_5819 rand = level.field_9229;
        Color color = RADIANT_COLORS.get((int)level.method_8510() % 27 / 9);
        class_2338 blockPos = voidConduit.method_11016();
        ColorParticleData colorData = ColorParticleData.create((Color)color.brighter(), (Color)color).setCoefficient(0.5f).build();
        if (level.method_8510() % 3L == 0L) {
            WeepingWellParticleEffects.weepingWellSquare(level, new class_243((double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.75f), (double)((float)blockPos.method_10260() + 0.5f)), colorData).spawnParticles();
        }
        float acceleration = RandomHelper.randomBetween((class_5819)rand, (float)0.002f, (float)0.02f);
        long gameTime = level.method_8510();
        Consumer<LodestoneWorldParticle> behavior = p -> {
            if (level.method_8510() < gameTime + 5L) {
                p.setParticleSpeed(p.getParticleSpeed().method_1031(0.0, (double)acceleration, 0.0));
            }
        };
        if (level.method_8510() % 2L == 0L) {
            int rotation = (int)((float)level.method_8510() / 2.0f % 16.0f);
            class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)new class_243((double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.75f), (double)((float)blockPos.method_10260() + 0.5f)), (float)1.1f, (float)rotation, (float)16.0f, (long)voidConduit.method_10997().method_8510(), (float)640.0f);
            ParticleEffectSpawner lightSpecs = WeepingWellParticleEffects.weepingWellSpecs(level, offsetPosition, colorData, LodestoneWorldParticleRenderType.ADDITIVE);
            lightSpecs.getBuilder().addTickActor(behavior);
            lightSpecs.getBloomBuilder().addTickActor(behavior);
            lightSpecs.spawnParticles();
        }
    }
}

