/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.BedrockDirectionalBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.LodestoneItemCrumbsParticleOptions;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

@Environment(value=EnvType.CLIENT)
public class ItemCrumbleParticleEffects {
    public static ParticleEffectSpawner spawnItemCrumbs(class_1937 level, class_243 pos, class_1799 stack) {
        class_5819 rand = level.method_8409();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)rand, (float)class_3532.method_15344((class_5819)rand, (float)0.5f, (float)0.75f), (float)0.0f).setCoefficient(0.6f).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.925f));
        int lifetime = RandomHelper.randomBetween((class_5819)rand, (int)30, (int)40);
        WorldParticleBuilder crumbs = ItemCrumbleParticleEffects.makeCrumbs(rand, stack, spinData, lifetime, slowDown);
        return new ParticleEffectSpawner(level, pos, crumbs);
    }

    public static ParticleEffectSpawner spawnGlowingItemCrumbs(class_1937 level, class_243 pos, class_1799 stack, MalumSpiritType spiritType) {
        class_5819 rand = level.method_8409();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((class_5819)rand, (float)0.0f, (float)class_3532.method_15344((class_5819)rand, (float)0.5f, (float)0.75f), (float)0.0f).setCoefficient(0.6f).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().method_1021((double)0.925f));
        int lifetime = RandomHelper.randomBetween((class_5819)rand, (int)30, (int)40);
        WorldParticleBuilder crumbs = ItemCrumbleParticleEffects.makeCrumbs(rand, stack, spinData, lifetime, slowDown);
        WorldParticleBuilder bloom = SpiritLightSpecs.spiritBloom(level, spiritType, lifetime).setSpinData(spinData).addTickActor(slowDown);
        return new ParticleEffectSpawner(level, pos, crumbs, bloom);
    }

    public static WorldParticleBuilder makeCrumbs(class_5819 rand, class_1799 stack, SpinParticleData spinData, int lifetime, Consumer<LodestoneWorldParticle> slowDown) {
        LodestoneItemCrumbsParticleOptions options = new LodestoneItemCrumbsParticleOptions((class_2396)LodestoneParticleRegistry.ITEM_PARTICLE.get(), stack);
        return WorldParticleBuilder.create((WorldParticleOptions)options).setSpinData(spinData).setTransparencyData(GenericParticleData.create((float)0.5f, (float)1.0f, (float)0.25f).setEasing(Easing.EXPO_IN, Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)0.05f, (float)RandomHelper.randomBetween((class_5819)rand, (float)0.06f, (float)0.07f), (float)0.0f).build()).setLifetime(lifetime).setDiscardFunction(SimpleParticleOptions.ParticleDiscardFunctionType.ENDING_CURVE_INVISIBLE).setRenderType(class_3999.field_17827).addTickActor(slowDown);
    }

    public static LodestoneBehaviorComponent makeCrumbParticleBehavior(class_1937 level) {
        return level.method_8409().method_43056() ? new BedrockDirectionalBehaviorComponent() : null;
    }
}

