/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.awt.Color;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.ExtrudingSparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class GluttonyParticleEffects {
    private static final Color GLUTTONY_GREEN = new Color(47, 81, 28);
    private static final Color GLUTTONY_DARK = new Color(31, 35, 30);
    private static final Color GLUTTONY_SHADE = new Color(14, 14, 16);

    public static void incrementGluttonyStatusEffect(PositionEffectData positionData, float gluttonyPotency) {
        class_638 level = class_310.method_1551().field_1687;
        class_5819 random = level.field_9229;
        for (int i = 0; i < 2; ++i) {
            int lifetime = RandomHelper.randomBetween((class_5819)random, (int)20, (int)30);
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.7f, (float)0.0f).build().multiplyValue(gluttonyPotency)).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.05f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.75f, (float)0.0f).setCoefficient(1.25f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setLifetime(lifetime).setColorData(ColorParticleData.create((Color)GLUTTONY_DARK, (Color)GLUTTONY_SHADE).setCoefficient(2.0f).build()).enableNoClip().setRandomOffset((double)0.2f, 0.0).setMotion(0.0, (double)0.001f, 0.0).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT.withDepthFade()).repeat((class_1937)level, positionData.posX, positionData.posY, positionData.posZ, 2);
        }
        float distance = 0.5f;
        float length = 0.75f * gluttonyPotency;
        float scale = 0.2f * gluttonyPotency;
        int count = gluttonyPotency < 1.0f ? 6 : 8;
        ParticleEffectSpawner ring = GluttonyParticleEffects.gluttonyRing(positionData.getAsVector(), new WorldParticleOptions(LodestoneParticleRegistry.SPARKLE_PARTICLE), distance, count);
        ring.getBuilder().replaceExistingBehavior(SparkBehaviorComponent.class, c -> new SparkBehaviorComponent(c.getLengthData().multiplyValue(length).bake())).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(gluttonyPotency)).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build());
        ring.spawnParticles();
    }

    public static void thrownGluttonySplash(PositionEffectData positionData) {
        class_638 level = class_310.method_1551().field_1687;
        class_5819 random = level.field_9229;
        for (int i = 0; i < 4; ++i) {
            int lifetime = RandomHelper.randomBetween((class_5819)random, (int)30, (int)40);
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.WISP_PARTICLE, (LodestoneBehaviorComponent)LodestoneBehaviorComponent.DIRECTIONAL).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.7f, (float)0.0f).build()).setColorData(ColorParticleData.create((Color)GLUTTONY_DARK, (Color)GLUTTONY_SHADE).setCoefficient(2.0f).build()).setScaleData(GenericParticleData.create((float)2.0f, (float)0.0f).setEasing(Easing.EXPO_IN).build()).setSpinData(SpinParticleData.createRandomDirection((class_5819)random, (float)0.05f).build()).setRenderType((class_3999)LodestoneWorldParticleRenderType.LUMITRANSPARENT.withDepthFade()).setRandomOffset(1.0, 0.0).setMotion(0.0, (double)0.001f, 0.0).setLifetime(lifetime).enableNoClip().repeat((class_1937)level, positionData.posX, positionData.posY, positionData.posZ, 2);
        }
        RegistryObject particle = LodestoneParticleRegistry.THIN_EXTRUDING_SPARK_PARTICLE;
        ParticleEffectSpawner ring = GluttonyParticleEffects.gluttonyRing(positionData.getAsVector(), new WorldParticleOptions(particle), 1.2f, 32);
        ring.spawnParticles();
        ring = GluttonyParticleEffects.gluttonyRing(positionData.getAsVector(), new WorldParticleOptions(particle), 0.4f, 16, 0.5f);
        ring.getBuilder().replaceExistingBehavior(SparkBehaviorComponent.class, c -> new ExtrudingSparkBehaviorComponent(c.getLengthData().multiplyValue(0.5f).bake()));
        ring.spawnParticles();
    }

    public static ParticleEffectSpawner gluttonyRing(class_243 center, WorldParticleOptions options, float distance, int count) {
        return GluttonyParticleEffects.gluttonyRing(center, options, distance, count, 1.0f);
    }

    public static ParticleEffectSpawner gluttonyRing(class_243 center, WorldParticleOptions options, float distance, int count, float lifetimeScalar) {
        class_638 level = class_310.method_1551().field_1687;
        class_5819 random = level.field_9229;
        GenericParticleData lengthData = GenericParticleData.create((float)0.1f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).setCoefficient(1.25f).build();
        WorldParticleBuilder builder = WorldParticleBuilder.create((WorldParticleOptions)options.setBehaviorIfDefault((LodestoneBehaviorComponent)new ExtrudingSparkBehaviorComponent(lengthData))).setScaleData(GenericParticleData.create((float)0.025f, (float)RandomHelper.randomBetween((class_5819)random, (float)0.2f, (float)0.3f), (float)0.0f).build()).setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.0f).build());
        return GluttonyParticleEffects.gluttonyRing(center, builder, distance, count, lifetimeScalar);
    }

    public static ParticleEffectSpawner gluttonyRing(class_243 center, WorldParticleBuilder builder, float distance, int count) {
        return GluttonyParticleEffects.gluttonyRing(center, builder, distance, count, 1.0f);
    }

    public static ParticleEffectSpawner gluttonyRing(class_243 center, WorldParticleBuilder builder, float distance, int count, float lifetimeScalar) {
        class_638 level = class_310.method_1551().field_1687;
        long gameTime = level.method_8510();
        class_5819 random = level.field_9229;
        return new ParticleEffectSpawner(builder, arg_0 -> GluttonyParticleEffects.lambda$gluttonyRing$6(count, center, distance, gameTime, random, builder, lifetimeScalar, (class_1937)level, arg_0));
    }

    private static /* synthetic */ void lambda$gluttonyRing$6(int count, class_243 center, float distance, long gameTime, class_5819 random, WorldParticleBuilder builder, float lifetimeScalar, class_1937 level, WorldParticleBuilder b) {
        for (int i = 0; i < count; ++i) {
            class_243 offsetPosition = DataHelper.rotatingRadialOffset((class_243)center, (float)distance, (float)i, (float)count, (long)gameTime, (float)320.0f);
            for (int j = 0; j < 3; ++j) {
                boolean isAdditive = j == 0;
                Color bright = j < 2 ? GLUTTONY_GREEN : GLUTTONY_DARK;
                Color dark = j < 2 ? GLUTTONY_GREEN : GLUTTONY_SHADE;
                float alphaMultiplier = isAdditive ? 1.5f : 3.0f;
                float scaleMultiplier = (isAdditive ? 1.25f : 2.5f) * RandomHelper.randomBetween((class_5819)random, (float)0.8f, (float)1.2f);
                float lengthMultiplier = (isAdditive ? 0.75f : 1.25f) * RandomHelper.randomBetween((class_5819)random, (float)0.8f, (float)1.2f);
                float colorCoefficient = isAdditive ? 1.0f : 1.75f;
                LodestoneWorldParticleRenderType renderType = isAdditive ? LodestoneWorldParticleRenderType.ADDITIVE : LodestoneWorldParticleRenderType.LUMITRANSPARENT;
                RenderHandler.LodestoneRenderLayer renderTarget = j < 2 ? RenderHandler.LATE_DELAYED_RENDER : RenderHandler.DELAYED_RENDER;
                builder.modifyOptionalData(b.getBehaviorComponent(SparkBehaviorComponent.class).map(SparkBehaviorComponent::getLengthData), d -> d.overrideValueMultiplier(lengthMultiplier)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.bake().multiplyValue(alphaMultiplier)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.bake().multiplyValue(scaleMultiplier)).setColorData(ColorParticleData.create((Color)bright, (Color)dark).setCoefficient(colorCoefficient).build()).setLifetime((int)((float)RandomHelper.randomBetween((class_5819)random, (int)30, (int)60) * lifetimeScalar)).setMotion(0.0, (double)0.001f, 0.0).setRenderTarget(renderTarget).setRenderType((class_3999)renderType).enableNoClip().spawn(level, offsetPosition.field_1352, offsetPosition.field_1351, offsetPosition.field_1350);
            }
        }
    }
}

