/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder.vanilla;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import org.jetbrains.annotations.Nullable;

public class TheDeviceRecipeBuilder
implements class_5797 {
    private final class_1792 result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final class_161.class_162 advancement = class_161.class_162.method_707();
    @Nullable
    private String group;

    public TheDeviceRecipeBuilder(class_1935 pResult, int pCount) {
        this.result = pResult.method_8389();
        this.count = pCount;
    }

    public static TheDeviceRecipeBuilder shaped(class_1935 pResult) {
        return TheDeviceRecipeBuilder.shaped(pResult, 1);
    }

    public static TheDeviceRecipeBuilder shaped(class_1935 pResult, int pCount) {
        return new TheDeviceRecipeBuilder(pResult, pCount);
    }

    public TheDeviceRecipeBuilder define(Character pSymbol, class_6862<class_1792> pTag) {
        return this.define(pSymbol, class_1856.method_8106(pTag));
    }

    public TheDeviceRecipeBuilder define(Character pSymbol, class_1935 pItem) {
        return this.define(pSymbol, class_1856.method_8091((class_1935[])new class_1935[]{pItem}));
    }

    public TheDeviceRecipeBuilder define(Character pSymbol, class_1856 pIngredient) {
        if (this.key.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(pSymbol, pIngredient);
        return this;
    }

    public TheDeviceRecipeBuilder pattern(String pPattern) {
        if (!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pPattern);
        return this;
    }

    public TheDeviceRecipeBuilder unlockedBy(String pCriterionName, class_184 pCriterionTrigger) {
        this.advancement.method_709(pCriterionName, pCriterionTrigger);
        return this;
    }

    public TheDeviceRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_17972(Consumer<class_2444> pFinishedRecipeConsumer, class_2960 pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)pRecipeId)).method_703(class_170.class_171.method_753((class_2960)pRecipeId)).method_704(class_193.field_1257);
        pFinishedRecipeConsumer.accept((class_2444)new class_2447.class_2448(pRecipeId, this.result, this.count, this.group == null ? "" : this.group, class_7710.field_40251, this.rows, this.key, this.advancement, new class_2960(pRecipeId.method_12836(), "recipes/the_device/" + pRecipeId.method_12832()), false));
    }

    private void ensureValid(class_2960 pId) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + pId + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + pId + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + pId);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + pId + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }
}

