/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritRepairRecipeBuilder {
    public final String itemIdRegex;
    public final String modIdRegex;
    public final float durabilityPercentage;
    public final List<class_1792> inputs = new ArrayList<class_1792>();
    public final IngredientWithCount repairMaterial;
    public final List<SpiritWithCount> spirits = new ArrayList<SpiritWithCount>();

    public SpiritRepairRecipeBuilder(String itemIdRegex, String modIdRegex, float durabilityPercentage, IngredientWithCount repairMaterial) {
        this.itemIdRegex = itemIdRegex;
        this.modIdRegex = modIdRegex;
        this.durabilityPercentage = durabilityPercentage;
        this.repairMaterial = repairMaterial;
    }

    public SpiritRepairRecipeBuilder(String itemIdRegex, float durabilityPercentage, class_1856 repairMaterial, int repairMaterialCount) {
        this(itemIdRegex, "", durabilityPercentage, new IngredientWithCount(repairMaterial, repairMaterialCount));
    }

    public SpiritRepairRecipeBuilder(float durabilityPercentage, class_1856 repairMaterial, int repairMaterialCount) {
        this("", "", durabilityPercentage, new IngredientWithCount(repairMaterial, repairMaterialCount));
    }

    public SpiritRepairRecipeBuilder addItem(class_1792 item) {
        this.inputs.add(item);
        return this;
    }

    public SpiritRepairRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<class_2444> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("spirit_crucible/repair/" + recipeName));
    }

    public void build(Consumer<class_2444> consumerIn, class_2960 id) {
        consumerIn.accept(new Result(id));
    }

    public void build(Consumer<class_2444> consumerIn) {
        this.build(consumerIn, class_7923.field_41178.method_10221((Object)this.inputs.get(0)).method_12832());
    }

    public class Result
    implements class_2444 {
        private final class_2960 id;

        public Result(class_2960 id) {
            this.id = id;
        }

        public void method_10416(JsonObject json) {
            JsonArray inputsJson = new JsonArray();
            for (class_1792 item : SpiritRepairRecipeBuilder.this.inputs) {
                inputsJson.add(class_7923.field_41178.method_10221((Object)item).toString());
            }
            JsonArray spiritsJson = new JsonArray();
            for (SpiritWithCount spirit : SpiritRepairRecipeBuilder.this.spirits) {
                spiritsJson.add((JsonElement)spirit.serialize());
            }
            json.addProperty("itemIdRegex", SpiritRepairRecipeBuilder.this.itemIdRegex);
            json.addProperty("modIdRegex", SpiritRepairRecipeBuilder.this.modIdRegex);
            json.addProperty("durabilityPercentage", (Number)Float.valueOf(SpiritRepairRecipeBuilder.this.durabilityPercentage));
            json.add("inputs", (JsonElement)inputsJson);
            json.add("repairMaterial", (JsonElement)SpiritRepairRecipeBuilder.this.repairMaterial.serialize());
            json.add("spirits", (JsonElement)spiritsJson);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return (class_1865)RecipeSerializerRegistry.REPAIR_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

