/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class SpiritInfusionRecipeBuilder {
    private final IngredientWithCount input;
    private final class_1799 output;
    private final List<SpiritWithCount> spirits = Lists.newArrayList();
    private final List<IngredientWithCount> extraItems = Lists.newArrayList();

    public SpiritInfusionRecipeBuilder(class_1856 input, int inputCount, class_1799 output) {
        this.input = new IngredientWithCount(input, inputCount);
        this.output = output;
    }

    public SpiritInfusionRecipeBuilder(class_1856 input, int inputCount, class_1935 output, int outputCount) {
        this(input, inputCount, new class_1799(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder(class_1935 input, int inputCount, class_1799 output) {
        this(class_1856.method_8091((class_1935[])new class_1935[]{input}), inputCount, output);
    }

    public SpiritInfusionRecipeBuilder(class_1935 input, int inputCount, class_1935 output, int outputCount) {
        this(class_1856.method_8091((class_1935[])new class_1935[]{input}), inputCount, new class_1799(output, outputCount));
    }

    public SpiritInfusionRecipeBuilder addExtraItem(class_1856 ingredient, int count) {
        this.extraItems.add(new IngredientWithCount(ingredient, count));
        return this;
    }

    public SpiritInfusionRecipeBuilder addExtraItem(class_1792 input, int count) {
        this.extraItems.add(new IngredientWithCount(class_1856.method_8091((class_1935[])new class_1935[]{input}), count));
        return this;
    }

    public SpiritInfusionRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<class_2444> consumerIn) {
        this.build(consumerIn, class_7923.field_41178.method_10221((Object)this.output.method_7909()).method_12832());
    }

    public void build(Consumer<class_2444> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("spirit_infusion/" + recipeName));
    }

    public void build(Consumer<class_2444> consumerIn, class_2960 id) {
        consumerIn.accept(new Result(id));
    }

    public class Result
    implements class_2444 {
        private final class_2960 id;

        public Result(class_2960 id) {
            this.id = id;
        }

        public void method_10416(JsonObject json) {
            JsonObject inputObject = SpiritInfusionRecipeBuilder.this.input.serialize();
            JsonElement outputObject = class_1856.method_8101((class_1799[])new class_1799[]{SpiritInfusionRecipeBuilder.this.output}).method_8089();
            if (SpiritInfusionRecipeBuilder.this.output.method_7947() != 1) {
                outputObject.getAsJsonObject().addProperty("count", (Number)SpiritInfusionRecipeBuilder.this.output.method_7947());
            }
            JsonArray extraItemsJson = new JsonArray();
            for (IngredientWithCount extraItem : SpiritInfusionRecipeBuilder.this.extraItems) {
                extraItemsJson.add((JsonElement)extraItem.serialize());
            }
            JsonArray spiritsJson = new JsonArray();
            for (SpiritWithCount spirit : SpiritInfusionRecipeBuilder.this.spirits) {
                spiritsJson.add((JsonElement)spirit.serialize());
            }
            json.add("input", (JsonElement)inputObject);
            json.add("output", outputObject);
            json.add("extra_items", (JsonElement)extraItemsJson);
            json.add("spirits", (JsonElement)spiritsJson);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return (class_1865)RecipeSerializerRegistry.INFUSION_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

