/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.recipe.builder;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.malum.MalumMod;
import com.sammy.malum.core.systems.recipe.SpiritWithCount;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.recipe.RecipeSerializerRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SpiritFocusingRecipeBuilder {
    private final int time;
    private final int durabilityCost;
    private final class_1856 input;
    private final class_1799 output;
    private final List<SpiritWithCount> spirits = Lists.newArrayList();

    public SpiritFocusingRecipeBuilder(int time, int durabilityCost, class_1856 input, class_1799 output) {
        this.time = time;
        this.durabilityCost = durabilityCost;
        this.input = input;
        this.output = output;
    }

    public SpiritFocusingRecipeBuilder(int time, int durabilityCost, class_1856 input, class_1935 output, int outputCount) {
        this(time, durabilityCost, input, new class_1799(output, outputCount));
    }

    public SpiritFocusingRecipeBuilder addSpirit(MalumSpiritType type, int count) {
        this.spirits.add(new SpiritWithCount(type, count));
        return this;
    }

    public void build(Consumer<class_2444> consumerIn, String recipeName) {
        this.build(consumerIn, MalumMod.malumPath("spirit_crucible/" + recipeName));
    }

    public void build(Consumer<class_2444> consumerIn) {
        this.build(consumerIn, class_7923.field_41178.method_10221((Object)this.output.method_7909()).method_12832());
    }

    public void build(Consumer<class_2444> consumerIn, class_2960 id) {
        consumerIn.accept(new Result(id));
    }

    public class Result
    implements class_2444 {
        private final class_2960 id;

        public Result(class_2960 id) {
            this.id = id;
        }

        public void method_10416(JsonObject json) {
            JsonObject inputObject = SpiritFocusingRecipeBuilder.this.input.method_8089().getAsJsonObject();
            JsonElement outputObject = class_1856.method_8101((class_1799[])new class_1799[]{SpiritFocusingRecipeBuilder.this.output}).method_8089();
            if (SpiritFocusingRecipeBuilder.this.output.method_7947() != 1) {
                outputObject.getAsJsonObject().addProperty("count", (Number)SpiritFocusingRecipeBuilder.this.output.method_7947());
            }
            JsonArray spiritJson = new JsonArray();
            for (SpiritWithCount spirit : SpiritFocusingRecipeBuilder.this.spirits) {
                spiritJson.add((JsonElement)spirit.serialize());
            }
            json.addProperty("time", (Number)SpiritFocusingRecipeBuilder.this.time);
            json.addProperty("durabilityCost", (Number)SpiritFocusingRecipeBuilder.this.durabilityCost);
            json.add("input", (JsonElement)inputObject);
            json.add("output", outputObject);
            json.add("spirits", (JsonElement)spiritJson);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return (class_1865)RecipeSerializerRegistry.FOCUSING_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }
}

