/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.core.systems.spirit.SpiritVisualMotif;
import java.awt.Color;
import java.util.function.Function;
import java.util.function.Supplier;

public class SpiritTypeBuilder {
    public final String identifier;
    public final Supplier<SpiritShardItem> spiritShard;
    public final SpiritVisualMotif spiritVisualMotif;
    public Color itemColor;

    public SpiritTypeBuilder(String identifier, SpiritVisualMotif spiritVisualMotif, Supplier<SpiritShardItem> spiritShard) {
        this.identifier = identifier;
        this.spiritVisualMotif = spiritVisualMotif;
        this.spiritShard = spiritShard;
    }

    public SpiritTypeBuilder setItemColor(Function<SpiritVisualMotif, Color> colorFunction) {
        return this.setItemColor(colorFunction.apply(this.spiritVisualMotif));
    }

    public SpiritTypeBuilder setItemColor(Color itemColor) {
        this.itemColor = itemColor;
        return this;
    }

    public MalumSpiritType build() {
        return this.build((identifier1, spiritShard1, visualMotif, itemColor1) -> new MalumSpiritType(identifier1, visualMotif, spiritShard1, itemColor1));
    }

    public <T extends MalumSpiritType> T build(SpiritTypeSupplier<T> supplier) {
        return supplier.makeType(this.identifier, this.spiritShard, this.spiritVisualMotif, this.itemColor);
    }

    public static interface SpiritTypeSupplier<T extends MalumSpiritType> {
        public T makeType(String var1, Supplier<SpiritShardItem> var2, SpiritVisualMotif var3, Color var4);
    }
}

